/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker;

import com.github.javafaker.Faker;
import com.github.javafaker.service.FakerIDN;
import com.github.javafaker.service.RandomService;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class Internet {
    private final Faker faker;

    protected Internet(Faker faker) {
        this.faker = faker;
    }

    public String emailAddress() {
        return this.emailAddress(this.faker.name().username());
    }

    public String emailAddress(String localPart) {
        return StringUtils.join((Object[])new String[]{localPart, "@", FakerIDN.toASCII(this.faker.fakeValuesService().resolve("internet.free_email", this, this.faker))});
    }

    public String safeEmailAddress() {
        return this.safeEmailAddress(this.faker.name().username());
    }

    public String safeEmailAddress(String localPart) {
        return StringUtils.join((Object[])new String[]{localPart, "@", FakerIDN.toASCII(this.faker.fakeValuesService().resolve("internet.safe_email", this, this.faker))});
    }

    public String domainName() {
        return this.domainWord() + "." + this.domainSuffix();
    }

    public String domainWord() {
        return FakerIDN.toASCII(this.faker.name().lastName().toLowerCase().replaceAll("'", ""));
    }

    public String domainSuffix() {
        return this.faker.fakeValuesService().resolve("internet.domain_suffix", this, this.faker);
    }

    public String url() {
        return StringUtils.join((Object[])new Object[]{"www", ".", FakerIDN.toASCII(this.faker.name().firstName().toLowerCase().replaceAll("'", "") + "-" + this.domainWord()), ".", this.domainSuffix()});
    }

    public String avatar() {
        return "https://s3.amazonaws.com/uifaces/faces/twitter/" + this.faker.fakeValuesService().resolve("internet.avatar", this, this.faker);
    }

    public String image() {
        String[] dimension = StringUtils.split((String)this.faker.fakeValuesService().resolve("internet.image_dimension", this, this.faker), (char)'x');
        if (dimension.length == 0) {
            return "";
        }
        return this.image(Integer.valueOf(StringUtils.trim((String)dimension[0])), Integer.valueOf(StringUtils.trim((String)dimension[1])), this.faker.bool().bool(), null);
    }

    public String image(Integer width, Integer height, Boolean gray, String text) {
        return String.format("http://lorempixel.com/%s%s/%s/%s/%s", gray != false ? "g/" : "", width, height, this.faker.fakeValuesService().resolve("internet.image_category", this, this.faker), StringUtils.isEmpty((CharSequence)text) ? "" : text);
    }

    public String password() {
        return this.password(8, 16);
    }

    public String password(int minimumLength, int maximumLength) {
        return this.password(minimumLength, maximumLength, false);
    }

    public String password(int minimumLength, int maximumLength, boolean includeUppercase) {
        return this.password(minimumLength, maximumLength, includeUppercase, false);
    }

    public String password(int minimumLength, int maximumLength, boolean includeUppercase, boolean includeSpecial) {
        if (includeSpecial) {
            char[] password = this.faker.lorem().characters(minimumLength, maximumLength, includeUppercase).toCharArray();
            char[] special = new char[]{'!', '@', '#', '$', '%', '^', '&', '*'};
            for (int i = 0; i < this.faker.random().nextInt(minimumLength); ++i) {
                password[this.faker.random().nextInt((int)password.length)] = special[this.faker.random().nextInt(special.length)];
            }
            return new String(password);
        }
        return this.faker.lorem().characters(minimumLength, maximumLength, includeUppercase);
    }

    public String macAddress(String prefix) {
        String tmp = prefix == null ? "" : prefix;
        int prefixLength = tmp.trim().length() == 0 ? 0 : tmp.split(":").length;
        StringBuilder out = new StringBuilder(tmp);
        for (int i = 0; i < 6 - prefixLength; ++i) {
            if (out.length() > 0) {
                out.append(':');
            }
            out.append(Integer.toHexString(this.faker.random().nextInt(16)));
            out.append(Integer.toHexString(this.faker.random().nextInt(16)));
        }
        return out.toString();
    }

    public String macAddress() {
        return this.macAddress("");
    }

    public String ipV4Address() {
        return String.format("%d.%d.%d.%d", this.faker.random().nextInt(254) + 2, this.faker.random().nextInt(254) + 2, this.faker.random().nextInt(254) + 2, this.faker.random().nextInt(254) + 2);
    }

    public String privateIpV4Address() {
        Integer[] PRIVATE_FIRST_OCTET = new Integer[]{10, 127, 169, 192, 172};
        Integer[] PRIVATE_SECOND_OCTET_172 = new Integer[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
        RandomService r = this.faker.random();
        int first = this.random(PRIVATE_FIRST_OCTET);
        int second = r.nextInt(256);
        int third = r.nextInt(256);
        int fourth = r.nextInt(256);
        switch (first) {
            case 172: {
                second = this.random(PRIVATE_SECOND_OCTET_172);
                break;
            }
            case 192: {
                second = 168;
                break;
            }
            case 169: {
                second = 254;
            }
        }
        return String.format("%d.%d.%d.%d", first, second, third, fourth);
    }

    public String publicIpV4Address() {
        RandomService r = this.faker.random();
        int[] PRIVATE_FIRST_OCTET = new int[]{10, 127, 169, 192, 172};
        int first = r.nextInt(256);
        int second = r.nextInt(256);
        int third = r.nextInt(256);
        int fourth = r.nextInt(256);
        while (Arrays.binarySearch(PRIVATE_FIRST_OCTET, first) > 0) {
            first = r.nextInt(256);
        }
        return String.format("%d.%d.%d.%d", first, second, third, fourth);
    }

    public String ipV4Cidr() {
        return this.ipV4Address() + '/' + (this.faker.random().nextInt(31) + 1);
    }

    public String ipV6Address() {
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            if (i > 0) {
                tmp.append(":");
            }
            tmp.append(Integer.toHexString(this.faker.random().nextInt(16)));
            tmp.append(Integer.toHexString(this.faker.random().nextInt(16)));
            tmp.append(Integer.toHexString(this.faker.random().nextInt(16)));
            tmp.append(Integer.toHexString(this.faker.random().nextInt(16)));
        }
        return tmp.toString();
    }

    public String ipV6Cidr() {
        return this.ipV6Address() + '/' + (this.faker.random().nextInt(127) + 1);
    }

    public String slug() {
        return this.slug(this.faker.lorem().words(2), "_");
    }

    public String slug(List<String> wordsOrNull, String glueOrNull) {
        String glue = glueOrNull == null ? "_" : glueOrNull;
        List<String> words = wordsOrNull == null ? this.faker.lorem().words(2) : wordsOrNull;
        StringBuilder slug = new StringBuilder();
        for (int i = 0; i < words.size(); ++i) {
            if (i > 0) {
                slug.append(glue);
            }
            slug.append(words.get(i));
        }
        return slug.toString();
    }

    public String uuid() {
        return UUID.randomUUID().toString();
    }

    private <T> T random(T[] src) {
        return src[this.faker.random().nextInt(src.length)];
    }
}

