/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.core.util.CertificateUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLContext;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glassfish.jersey.SslConfigurator;

public class LocalDirectorySSLConfig
implements SSLConfig,
Serializable {
    private static final long serialVersionUID = -4736328026418377358L;
    private final String dockerCertPath;

    public LocalDirectorySSLConfig(String dockerCertPath) {
        Preconditions.checkNotNull((Object)dockerCertPath);
        this.dockerCertPath = dockerCertPath;
    }

    public String getDockerCertPath() {
        return this.dockerCertPath;
    }

    @Override
    public SSLContext getSSLContext() {
        boolean certificatesExist = CertificateUtils.verifyCertificatesExist(this.dockerCertPath);
        if (certificatesExist) {
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
                String caPemPath = this.dockerCertPath + File.separator + "ca.pem";
                String keyPemPath = this.dockerCertPath + File.separator + "key.pem";
                String certPemPath = this.dockerCertPath + File.separator + "cert.pem";
                String keypem = new String(Files.readAllBytes(Paths.get(keyPemPath, new String[0])));
                String certpem = new String(Files.readAllBytes(Paths.get(certPemPath, new String[0])));
                String capem = new String(Files.readAllBytes(Paths.get(caPemPath, new String[0])));
                SslConfigurator sslConfig = SslConfigurator.newInstance((boolean)true);
                sslConfig.securityProtocol("TLSv1.2");
                sslConfig.keyStore(CertificateUtils.createKeyStore(keypem, certpem));
                sslConfig.keyStorePassword("docker");
                sslConfig.trustStore(CertificateUtils.createTrustStore(capem));
                return sslConfig.createSSLContext();
            }
            catch (Exception e) {
                throw new DockerClientException(e.getMessage(), e);
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalDirectorySSLConfig that = (LocalDirectorySSLConfig)o;
        return this.dockerCertPath.equals(that.dockerCertPath);
    }

    public int hashCode() {
        return this.dockerCertPath.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "dockerCertPath=" + this.dockerCertPath + "}";
    }
}

