/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class PortBinding
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Ports.Binding binding;
    private final ExposedPort exposedPort;

    public PortBinding(Ports.Binding binding, ExposedPort exposedPort) {
        this.binding = binding;
        this.exposedPort = exposedPort;
    }

    public Ports.Binding getBinding() {
        return this.binding;
    }

    public ExposedPort getExposedPort() {
        return this.exposedPort;
    }

    public static PortBinding parse(String serialized) throws IllegalArgumentException {
        try {
            String[] parts = StringUtils.splitByWholeSeparator((String)serialized, (String)":");
            switch (parts.length) {
                case 3: {
                    return PortBinding.createFromSubstrings(parts[0] + ":" + parts[1], parts[2]);
                }
                case 2: {
                    return PortBinding.createFromSubstrings(parts[0], parts[1]);
                }
                case 1: {
                    return PortBinding.createFromSubstrings("", parts[0]);
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing PortBinding '" + serialized + "'", e);
        }
    }

    private static PortBinding createFromSubstrings(String binding, String exposedPort) throws IllegalArgumentException {
        return new PortBinding(Ports.Binding.parse(binding), ExposedPort.parse(exposedPort));
    }

    public boolean equals(Object obj) {
        if (obj instanceof PortBinding) {
            PortBinding other = (PortBinding)obj;
            return new EqualsBuilder().append((Object)this.binding, (Object)other.getBinding()).append((Object)this.exposedPort, (Object)other.getExposedPort()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.binding).append((Object)this.exposedPort).toHashCode();
    }
}

