/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.api;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import me.chanjar.weixin.common.api.WxMessageDuplicateChecker;

public class WxMessageInMemoryDuplicateChecker
implements WxMessageDuplicateChecker {
    private final Long timeToLive;
    private final Long clearPeriod;
    private final ConcurrentHashMap<String, Long> msgId2Timestamp = new ConcurrentHashMap();
    private final AtomicBoolean backgroundProcessStarted = new AtomicBoolean(false);

    public WxMessageInMemoryDuplicateChecker() {
        this.timeToLive = 15000L;
        this.clearPeriod = 5000L;
    }

    public WxMessageInMemoryDuplicateChecker(Long timeToLive, Long clearPeriod) {
        this.timeToLive = timeToLive;
        this.clearPeriod = clearPeriod;
    }

    protected void checkBackgroundProcessStarted() {
        if (this.backgroundProcessStarted.getAndSet(true)) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    block2: while (true) {
                        Thread.sleep(WxMessageInMemoryDuplicateChecker.this.clearPeriod);
                        Long now = System.currentTimeMillis();
                        Iterator iterator = WxMessageInMemoryDuplicateChecker.this.msgId2Timestamp.entrySet().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block2;
                            Map.Entry entry = iterator.next();
                            if (now - (Long)entry.getValue() <= WxMessageInMemoryDuplicateChecker.this.timeToLive) continue;
                            WxMessageInMemoryDuplicateChecker.this.msgId2Timestamp.entrySet().remove(entry);
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }

    @Override
    public boolean isDuplicate(String messageId) {
        if (messageId == null) {
            return false;
        }
        this.checkBackgroundProcessStarted();
        Long timestamp = this.msgId2Timestamp.putIfAbsent(messageId, System.currentTimeMillis());
        return timestamp != null;
    }
}

