/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.visitor.springmvc;

import com.github.apiggs.ast.Classes;
import com.github.apiggs.ast.Comments;
import com.github.apiggs.ast.ResolvedTypes;
import com.github.apiggs.http.HttpMessage;
import com.github.apiggs.http.HttpRequest;
import com.github.apiggs.http.HttpRequestMethod;
import com.github.apiggs.schema.Group;
import com.github.apiggs.schema.Node;
import com.github.apiggs.schema.Tree;
import com.github.apiggs.util.URL;
import com.github.apiggs.visitor.NodeVisitor;
import com.github.apiggs.visitor.springmvc.Controllers;
import com.github.apiggs.visitor.springmvc.Parameters;
import com.github.apiggs.visitor.springmvc.RequestMappings;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.google.common.base.Strings;
import java.util.Optional;

public class SpringVisitor
extends NodeVisitor {
    public void visit(ClassOrInterfaceDeclaration n, Node arg) {
        if (!Comments.isIgnore((com.github.javaparser.ast.Node)n) && arg instanceof Tree) {
            Tree tree = (Tree)arg;
            if (Controllers.accept((NodeList<AnnotationExpr>)n.getAnnotations())) {
                Optional<RequestMappings> optional;
                String name = Classes.getNameInScope(n);
                String fullName = Classes.getFullName(n);
                Group group = new Group();
                group.setParent(tree);
                group.setId(fullName);
                group.setName(name);
                group.setRest(Controllers.isResponseBody(n));
                if (n.getComment().isPresent()) {
                    Comments comments = Comments.of((Comment)n.getComment().get());
                    if (!Strings.isNullOrEmpty((String)comments.name)) {
                        group.setName(comments.name);
                    }
                    group.setDescription(comments.description);
                    group.setIndex(Comments.getIndexTag(n.getComment()));
                }
                if ((optional = RequestMappings.of(n)).isPresent()) {
                    group.getExt().put("path", optional.get().getPath().get(0));
                    group.getExt().put("method", optional.get().getMethod());
                }
                super.visit(n, (Object)group);
                if (!group.isEmpty()) {
                    tree.getGroups().add(group);
                }
            }
        }
        super.visit(n, (Object)arg);
    }

    public void visit(MethodDeclaration n, Node arg) {
        Group group;
        if (!Comments.isIgnore((com.github.javaparser.ast.Node)n) && arg instanceof Group && RequestMappings.accept((NodeList<AnnotationExpr>)n.getAnnotations()) && ((group = (Group)arg).isRest() || RequestMappings.isRequestBody(n))) {
            HttpMessage message = new HttpMessage();
            message.setParent(group);
            message.setName(n.getNameAsString());
            message.setId(group.getId() + "." + message.getName());
            group.getNodes().add(message);
            this.visit(n.getType(), message);
            n.getAnnotations().forEach(p -> this.visit((AnnotationExpr)p, message));
            n.getParameters().forEach(p -> this.visit((Parameter)p, message));
            n.getComment().ifPresent(l -> this.visit((Comment)l, message));
        }
        super.visit(n, (Object)arg);
    }

    private void visit(Type type, HttpMessage message) {
        ResolvedTypes astResolvedType = ResolvedTypes.of(type);
        if (astResolvedType.resolved) {
            message.getResponse().setBody(astResolvedType.getValue());
            message.getResponse().getCells().addAll(astResolvedType.cells);
        }
    }

    private void visit(Parameter n, HttpMessage message) {
        HttpRequest request = message.getRequest();
        Parameters parameters = Parameters.of(n);
        request.getCells().addAll(parameters.getCells());
        if (parameters.isFile()) {
            if (HttpRequestMethod.GET.equals(request.getMethod())) {
                request.setMethod(HttpRequestMethod.POST);
            }
            request.getHeaders().setContentType("multipart/form-data");
        } else if (parameters.isHeader()) {
            request.getHeaders().put(parameters.getName(), String.valueOf(parameters.getValue()));
        } else if (parameters.isRequestBody()) {
            if (HttpRequestMethod.GET.equals(request.getMethod())) {
                request.setMethod(HttpRequestMethod.POST);
            }
            request.getHeaders().setContentType("application/json");
            request.setBody(parameters.getValue());
        }
    }

    private void visit(AnnotationExpr n, HttpMessage message) {
        if (!RequestMappings.accept(n)) {
            return;
        }
        Group group = message.getParent();
        RequestMappings requestMappings = RequestMappings.of(n);
        message.getRequest().setMethod(requestMappings.getMethod());
        message.getRequest().checkContentType();
        for (String path : requestMappings.getPath()) {
            message.getRequest().getUris().add(URL.normalize(group.getExt().get("path"), path));
        }
        message.getRequest().getHeaders().add(requestMappings.getHeaders());
    }

    private void visit(Comment n, HttpMessage message) {
        SymbolReference symbolReference;
        Comments comments = Comments.of(n);
        if (!Strings.isNullOrEmpty((String)comments.name)) {
            message.setName(comments.name);
        }
        if (!Strings.isNullOrEmpty((String)comments.description)) {
            message.setDescription(comments.description);
        }
        if (comments.returnTag != null && !Strings.isNullOrEmpty((String)comments.returnTag.content) && (symbolReference = this.context.getEnv().getTypeSolver().tryToSolveType(comments.returnTag.content)).isSolved()) {
            ResolvedReferenceTypeDeclaration typeDeclaration = (ResolvedReferenceTypeDeclaration)symbolReference.getCorrespondingDeclaration();
            ResolvedTypes resolvedTypes = ResolvedTypes.of(typeDeclaration);
            if (resolvedTypes.resolved) {
                message.getResponse().setBody(resolvedTypes.getValue());
                message.getResponse().getCells().addAll(resolvedTypes.cells);
            }
        }
    }
}

