/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.visitor.springmvc;

import com.github.apiggs.ast.Annotations;
import com.github.apiggs.ast.Comments;
import com.github.apiggs.ast.Defaults;
import com.github.apiggs.ast.ResolvedTypes;
import com.github.apiggs.schema.Cell;
import com.github.apiggs.util.loging.Logger;
import com.github.apiggs.util.loging.LoggerFactory;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Parameters {
    static Logger log = LoggerFactory.getLogger(Parameters.class);
    public static final String REQUEST_BODY = "RequestBody";
    public static final String REQUEST_PARAM = "RequestParam";
    public static final String REQUEST_HEADER = "RequestHeader";
    public static final String PATH_VARIABLE = "PathVariable";
    public static final String MVC_MODEL = "MODEL";
    public static final Set<String> MVCS = Sets.newHashSet((Object[])new String[]{"MODEL"});
    boolean primitive;
    boolean pathVariable;
    boolean requestBody;
    boolean header;
    boolean file;
    boolean mvc;
    String name;
    String type;
    Object value;
    String description;
    List<Cell> cells = new ArrayList<Cell>();

    public static Parameters of(Parameter expr) {
        Parameters parameters = new Parameters();
        if (expr.isAnnotationPresent(PATH_VARIABLE)) {
            parameters.setPathVariable(true);
            parameters.resolvePath(expr);
        } else if (expr.isAnnotationPresent(REQUEST_HEADER)) {
            parameters.setHeader(true);
            parameters.resolveHeader(expr);
        } else {
            if (expr.isAnnotationPresent(REQUEST_BODY)) {
                parameters.setRequestBody(true);
            }
            parameters.tryResolve(expr);
        }
        return parameters;
    }

    private void resolvePath(Parameter expr) {
        Cell cell = new Cell(expr.getNameAsString(), expr.getTypeAsString(), true);
        cell.setDescription(Comments.getCommentFromMethod(expr));
        cell.setValue(Defaults.get(cell.getType()));
        this.cells.add(cell);
    }

    private void resolveHeader(Parameter expr) {
        this.name = expr.getNameAsString();
        this.type = expr.getTypeAsString();
        this.value = Defaults.get(this.type);
        Object valueAttr = Annotations.getAttr(expr.getAnnotationByName(REQUEST_HEADER), "value");
        Object defaultValueAttr = Annotations.getAttr(expr.getAnnotationByName(REQUEST_HEADER), "defaultValue");
        if (valueAttr != null) {
            this.name = String.valueOf(valueAttr);
        }
        if (defaultValueAttr != null) {
            this.value = defaultValueAttr;
        }
        Cell cell = new Cell(this.name, this.type, true);
        cell.setDescription(Comments.getCommentFromMethod(expr));
        cell.setValue(this.value);
        this.cells.add(cell);
    }

    private void tryResolve(Parameter expr) {
        try {
            ResolvedParameterDeclaration parameterDeclaration = expr.resolve();
            ResolvedType resolvedType = parameterDeclaration.getType();
            ResolvedTypes astResolvedType = ResolvedTypes.of(resolvedType);
            if (!astResolvedType.resolved) {
                return;
            }
            this.setPrimitive(astResolvedType.primitive);
            this.setValue(astResolvedType.getValue());
            if (astResolvedType.primitive) {
                Cell cell = new Cell(expr.getNameAsString(), astResolvedType.name, astResolvedType.getValue());
                Object valueAttr = Annotations.getAttr(expr.getAnnotationByName(REQUEST_PARAM), "value");
                Object defaultValueAttr = Annotations.getAttr(expr.getAnnotationByName(REQUEST_PARAM), "defaultValue");
                if (valueAttr != null) {
                    cell.setName(String.valueOf(valueAttr));
                }
                if (defaultValueAttr != null) {
                    cell.setValue(defaultValueAttr);
                }
                cell.setDescription(Comments.getCommentFromMethod(expr));
                this.cells.add(cell);
            }
            this.cells.addAll(astResolvedType.cells);
        }
        catch (Exception e) {
            log.debug("parameters parse fail:{}", expr.toString());
        }
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public void setPrimitive(boolean primitive) {
        this.primitive = primitive;
    }

    public boolean isPathVariable() {
        return this.pathVariable;
    }

    public void setPathVariable(boolean pathVariable) {
        this.pathVariable = pathVariable;
    }

    public boolean isRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(boolean requestBody) {
        this.requestBody = requestBody;
    }

    public boolean isFile() {
        return this.file;
    }

    public void setFile(boolean file) {
        this.file = file;
    }

    public boolean isMvc() {
        return this.mvc;
    }

    public void setMvc(boolean mvc) {
        this.mvc = mvc;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    public void setCells(List<Cell> cells) {
        this.cells = cells;
    }

    public boolean isHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }
}

