/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.util.loging;

import com.github.apiggs.util.loging.Logger;
import com.github.apiggs.util.loging.SimpleLogger;

public class LoggerFactory {
    private static Class<? extends Logger> loggerClass = SimpleLogger.class;

    public static Logger getLogger(Class clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        Logger logger = LoggerFactory.newInstance();
        logger.setName(name);
        return logger;
    }

    private static synchronized Logger newInstance() {
        try {
            return loggerClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static void setLoggerClass(Class<? extends Logger> loggerClass) {
        LoggerFactory.loggerClass = loggerClass;
    }
}

