/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.schema;

import com.google.common.collect.Lists;
import java.util.List;

public class Cell {
    String name;
    String type;
    Object value;
    String description;
    boolean disabled;

    public Cell() {
    }

    public Cell(String name, String type, Object value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public Cell(String name, String type) {
        this(name, type, null);
    }

    public Cell(String name, String type, boolean disabled) {
        this(name, type);
        this.disabled = disabled;
    }

    public List<String> allList() {
        return Lists.newArrayList((Object[])new String[]{this.name, this.type, this.value == null ? "" : String.valueOf(this.value), this.description});
    }

    public List<String> nameValueList() {
        return Lists.newArrayList((Object[])new String[]{this.name, this.value == null ? "" : String.valueOf(this.value), this.description});
    }

    public static String join(List<Cell> cells) {
        StringBuilder sb = new StringBuilder();
        for (Cell cell : cells) {
            if (cell.disabled) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(cell.getName()).append("=").append(cell.getValue());
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }
}

