/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.apiggs.http.HttpHeaders;
import com.github.apiggs.http.HttpRequestMethod;
import com.github.apiggs.schema.Cell;
import com.github.apiggs.util.ObjectMappers;
import java.util.ArrayList;
import java.util.List;

public class HttpRequest {
    HttpRequestMethod method;
    List<String> uris = new ArrayList<String>();
    HttpHeaders headers = new HttpHeaders();
    Object body;
    List<Cell> cells = new ArrayList<Cell>();

    public HttpRequestMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpRequestMethod method) {
        this.method = method;
    }

    public List<String> getUris() {
        return this.uris;
    }

    public void setUris(List<String> uris) {
        this.uris = uris;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    public void setCells(List<Cell> cells) {
        this.cells = cells;
    }

    public Object queryString() {
        if (HttpRequestMethod.GET.equals(this.method)) {
            return this.cells.size() > 0 ? "?" + Cell.join(this.cells) : "";
        }
        return "";
    }

    public boolean hasBody() {
        return !HttpRequestMethod.GET.equals(this.method) && (this.body != null || this.hasParameter());
    }

    public String bodyString() {
        if (this.getBody() != null && this.getBody() instanceof JsonNode) {
            return ObjectMappers.toPretty(this.getBody());
        }
        return Cell.join(this.cells);
    }

    public boolean hasParameter() {
        for (Cell cell : this.cells) {
            if (cell.isDisabled()) continue;
            return true;
        }
        return false;
    }

    public void checkContentType() {
        if (this.hasBody()) {
            this.headers.setContentType("application/x-www-form-urlencoded");
        }
    }
}

