/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.handler.postman.schema;

import com.github.apiggs.http.HttpRequestMethod;
import com.github.apiggs.markup.asciidoc.Color;
import com.github.apiggs.util.loging.Logger;
import com.github.apiggs.util.loging.LoggerFactory;

public enum Method {
    GET,
    POST,
    PUT,
    DELETE,
    OPTIONS,
    PATCH,
    COPY,
    HEAD,
    LINK,
    UNLINK,
    PURGE,
    LOCK,
    UNLOCK,
    PROPFIND,
    VIEW;

    static Logger log;

    public static Method of(HttpRequestMethod method) {
        return Method.valueOf(method.name());
    }

    public static Color getColor(String method) {
        try {
            switch (Method.valueOf(method)) {
                case GET: {
                    return Color.GREEN;
                }
                case POST: {
                    return Color.YELLOW;
                }
                case PUT: {
                    return Color.BLUE;
                }
                case DELETE: {
                    return Color.RED;
                }
            }
        }
        catch (Exception e) {
            log.debug("parse method error:{}", method);
        }
        return Color.BLACK;
    }

    static {
        log = LoggerFactory.getLogger(Method.class);
    }
}

