/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.handler;

import com.github.apiggs.Environment;
import com.github.apiggs.handler.TreeHandler;
import com.github.apiggs.http.HttpMessage;
import com.github.apiggs.http.HttpRequest;
import com.github.apiggs.http.HttpResponse;
import com.github.apiggs.markup.MarkupBuilder;
import com.github.apiggs.markup.asciidoc.AsciiDoc;
import com.github.apiggs.schema.Appendix;
import com.github.apiggs.schema.Cell;
import com.github.apiggs.schema.Group;
import com.github.apiggs.schema.Tree;
import com.github.apiggs.util.loging.Logger;
import com.github.apiggs.util.loging.LoggerFactory;
import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class AsciidocTreeHandler
implements TreeHandler {
    Logger log = LoggerFactory.getLogger(this.getClass());
    MarkupBuilder builder = MarkupBuilder.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Tree tree, Environment env) {
        this.builder.header(tree.getName(), AsciiDoc.DOCTYPE_BOOK, AsciiDoc.TOC_LEFT);
        if (Objects.nonNull(tree.getVersion())) {
            this.builder.paragraph("version:" + tree.getVersion(), new CharSequence[0]);
        }
        if (Objects.nonNull(tree.getDescription())) {
            this.builder.paragraph(tree.getDescription(), new CharSequence[0]);
        }
        int section = 1;
        if (!Strings.isNullOrEmpty((String)tree.getReadme())) {
            this.builder.title(1, section + " \u6587\u6863\u8bf4\u660e");
            this.builder.paragraph(tree.getReadme(), new CharSequence[0]);
            ++section;
        }
        for (Group group : tree.getGroups()) {
            this.buildGroup(group, section++);
        }
        if (!tree.getAppendices().isEmpty()) {
            this.builder.title(1, section + " \u9644\u5f55");
            for (int i = 0; i < tree.getAppendices().size(); ++i) {
                Appendix appendix = tree.getAppendices().get(i);
                if (appendix.getCells().isEmpty()) continue;
                this.builder.title(2, section + "." + (i + 1) + " " + appendix.getName());
                this.nvd(appendix.getCells());
            }
            ++section;
        }
        try {
            Path adoc = env.getOutPath().resolve(env.getId() + AsciiDoc.EXTENSION);
            this.write(adoc, this.builder.getContent(), StandardCharsets.UTF_8, new OpenOption[0]);
            this.log.info("Build {}", adoc);
        }
        finally {
            this.builder.clean();
        }
    }

    private void buildGroup(Group group, int num) {
        this.builder.title(1, num + " " + group.getName());
        if (Objects.nonNull(group.getDescription())) {
            this.builder.paragraph(group.getDescription(), new CharSequence[0]);
        }
        for (int i = 0; i < group.getNodes().size(); ++i) {
            HttpMessage httpMessage = group.getNodes().get(i);
            this.buildHttpMessage(httpMessage, num + ".", i + 1);
        }
    }

    private void buildHttpMessage(HttpMessage message, String prefix, int num) {
        this.builder.title(2, prefix + num + " " + message.getName());
        if (Objects.nonNull(message.getDescription())) {
            this.builder.paragraph(message.getDescription(), new CharSequence[0]);
        }
        HttpRequest request = message.getRequest();
        this.builder.listing(builder -> {
            for (String uri : request.getUris()) {
                builder.textLine(request.getMethod() + " " + uri + request.queryString() + " " + (Object)((Object)message.getVersion()));
            }
            request.getHeaders().forEach((k, v) -> builder.textLine(k + ": " + v));
            if (request.hasBody()) {
                builder.br();
                builder.text(request.bodyString());
            }
        }, "source,REQUEST");
        this.ntdd(request.getCells());
        HttpResponse response = message.getResponse();
        if (!response.isEmpty()) {
            this.builder.listing(builder -> {
                builder.textLine((Object)((Object)message.getVersion()) + " " + response.getStatus());
                response.getHeaders().forEach((k, v) -> builder.textLine(k + ": " + v));
                if (response.hasBody()) {
                    builder.br();
                    builder.text(response.bodyString());
                }
            }, "source,RESPONSE");
            this.ntdd(response.getCells());
        }
    }

    private void ntdd(List<Cell> cells) {
        if (cells.size() > 0) {
            ArrayList<List<String>> responseTable = new ArrayList<List<String>>();
            responseTable.add(Arrays.asList("NAME", "TYPE", "DEFAULT", "DESCRIPTION"));
            cells.forEach(parameter -> responseTable.add(parameter.allList()));
            this.builder.table(responseTable);
        }
    }

    private void nvd(List<Cell> cells) {
        if (cells.size() > 0) {
            ArrayList<List<String>> responseTable = new ArrayList<List<String>>();
            cells.forEach(parameter -> responseTable.add(parameter.nameValueList()));
            this.builder.table(responseTable, false, false);
        }
    }
}

