/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.ast;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.apiggs.Environment;
import com.github.apiggs.ast.CharSequences;
import com.github.apiggs.ast.Collections;
import com.github.apiggs.ast.Comments;
import com.github.apiggs.ast.Dates;
import com.github.apiggs.ast.Defaults;
import com.github.apiggs.ast.Fields;
import com.github.apiggs.ast.Langs;
import com.github.apiggs.ast.Maps;
import com.github.apiggs.ast.Numbers;
import com.github.apiggs.schema.Cell;
import com.github.apiggs.util.ObjectMappers;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedTypeVariable;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserFieldDeclaration;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ResolvedTypes {
    private static Map<Object, ResolvedTypes> POOL = new ConcurrentHashMap<Object, ResolvedTypes>();
    public boolean resolved;
    public boolean primitive;
    public String name;
    public Object value;
    public ObjectNode objectNode;
    public List<Cell> cells = new ArrayList<Cell>();

    public Object getValue() {
        return this.value == null ? this.objectNode : this.value;
    }

    public static ResolvedTypes of(Type type) {
        try {
            ResolvedType resolvedType = type.resolve();
            return ResolvedTypes.of(resolvedType);
        }
        catch (UnsolvedSymbolException e) {
            return ResolvedTypes.tryResolveTypeArguments(type);
        }
    }

    public static ResolvedTypes of(ResolvedType resolvedType) {
        if (POOL.containsKey(resolvedType)) {
            return POOL.get(resolvedType).duplicate();
        }
        ResolvedTypes resolvedTypes = new ResolvedTypes();
        POOL.put(resolvedType, resolvedTypes);
        if (!resolvedType.isTypeVariable()) {
            resolvedTypes.resolve(resolvedType);
            resolvedTypes.resolved = true;
        }
        return resolvedTypes.duplicate();
    }

    public static ResolvedTypes of(ResolvedReferenceTypeDeclaration typeDeclaration) {
        if (POOL.containsKey(typeDeclaration)) {
            return POOL.get(typeDeclaration).duplicate();
        }
        ResolvedTypes resolvedTypes = new ResolvedTypes();
        POOL.put(typeDeclaration, resolvedTypes);
        resolvedTypes.name = typeDeclaration.getName();
        resolvedTypes.resolved = true;
        resolvedTypes.resolve(typeDeclaration, null);
        return resolvedTypes;
    }

    public static ResolvedTypes ofTypeVariable(ResolvedType type, List<Pair<ResolvedTypeParameterDeclaration, ResolvedType>> typeParametersMap) {
        if (!type.isTypeVariable()) {
            return ResolvedTypes.of(type);
        }
        ResolvedTypeVariable resolvedType = type.asTypeVariable();
        if (typeParametersMap != null) {
            for (int i = 0; i < typeParametersMap.size(); ++i) {
                Pair<ResolvedTypeParameterDeclaration, ResolvedType> pair = typeParametersMap.get(i);
                if (!Objects.equals(resolvedType.asTypeParameter(), pair.a)) continue;
                return ResolvedTypes.of((ResolvedType)pair.b);
            }
        }
        return new ResolvedTypes();
    }

    private static ResolvedTypes tryResolveTypeArguments(Type type) {
        ClassOrInterfaceType classType;
        ResolvedTypes typeArgumentResolvedTypes = new ResolvedTypes();
        if (type instanceof ClassOrInterfaceType && (classType = (ClassOrInterfaceType)type).getTypeArguments().isPresent()) {
            ArrayList<ResolvedTypes> types = new ArrayList<ResolvedTypes>();
            for (int i = 0; i < ((NodeList)classType.getTypeArguments().get()).size(); ++i) {
                Type typeArgument = (Type)((NodeList)classType.getTypeArguments().get()).get(i);
                ResolvedTypes argumentResolved = ResolvedTypes.of(typeArgument);
                if (!argumentResolved.resolved) continue;
                types.add(argumentResolved);
            }
            if (types.size() == 1) {
                ResolvedTypes resolvedTypes = (ResolvedTypes)types.get(0);
                typeArgumentResolvedTypes.value = resolvedTypes.getValue();
                typeArgumentResolvedTypes.resolved = true;
                typeArgumentResolvedTypes.cells.addAll(resolvedTypes.cells);
            } else {
                ArrayNode arrayNode = ObjectMappers.instance().createArrayNode();
                int i = 0;
                for (ResolvedTypes resolvedTypes : types) {
                    String field = "?" + i++;
                    resolvedTypes.prefix(field + ".");
                    arrayNode.addPOJO(resolvedTypes.getValue());
                    typeArgumentResolvedTypes.resolved = true;
                    typeArgumentResolvedTypes.cells.addAll(resolvedTypes.cells);
                }
                typeArgumentResolvedTypes.value = arrayNode;
            }
        }
        return typeArgumentResolvedTypes;
    }

    private void resolve(ResolvedType resolvedType) {
        this.resolveName(resolvedType);
        if (Environment.getIgnoreTypes().contains(this.name)) {
            return;
        }
        if (resolvedType.isPrimitive() || Numbers.isAssignableBy(resolvedType)) {
            this.primitive = true;
            this.value = Defaults.DEFAULT_INTEGER;
        } else if (CharSequences.isAssignableBy(resolvedType)) {
            this.primitive = true;
            this.value = "";
        } else if (resolvedType.isArray()) {
            this.resolveArray(resolvedType);
        } else if (resolvedType.isReferenceType()) {
            ResolvedReferenceType referenceType = resolvedType.asReferenceType();
            ResolvedReferenceTypeDeclaration typeDeclaration = referenceType.getTypeDeclaration();
            List typeParametersMap = referenceType.getTypeParametersMap();
            this.resolve(typeDeclaration, typeParametersMap);
        }
    }

    private void resolve(ResolvedReferenceTypeDeclaration typeDeclaration, List<Pair<ResolvedTypeParameterDeclaration, ResolvedType>> typeParametersMap) {
        if (typeDeclaration.isEnum()) {
            this.primitive = true;
            this.value = "";
        } else if (Collections.isAssignableBy(typeDeclaration)) {
            this.resolveCollection(typeParametersMap);
        } else if (Maps.isAssignableBy(typeDeclaration)) {
            this.value = Defaults.DEFAULT_MAP;
        } else if (Dates.isAssignableBy(typeDeclaration)) {
            this.value = "";
        } else if (!Langs.isAssignableBy(typeDeclaration)) {
            this.resolvePojo(typeDeclaration, typeParametersMap);
        }
    }

    private void resolveName(ResolvedType resolvedType) {
        this.name = resolvedType.describe();
        if (resolvedType instanceof ReferenceTypeImpl) {
            this.name = ((ReferenceTypeImpl)resolvedType).getTypeDeclaration().getName();
        }
    }

    private void resolveArray(ResolvedType resolvedType) {
        if (resolvedType.isArray()) {
            ArrayNode arrayNode = ObjectMappers.instance().createArrayNode();
            ResolvedTypes componentType = ResolvedTypes.of(resolvedType.asArrayType().getComponentType());
            componentType.prefix("[].");
            if (componentType.resolved) {
                arrayNode.addPOJO(componentType.getValue());
                this.value = arrayNode;
                this.cells.addAll(componentType.cells);
            }
        }
    }

    private void resolveCollection(List<Pair<ResolvedTypeParameterDeclaration, ResolvedType>> typeParametersMap) {
        if (typeParametersMap != null && typeParametersMap.size() == 1) {
            ArrayNode arrayNode = ObjectMappers.instance().createArrayNode();
            if (!"?".equals(((ResolvedType)typeParametersMap.get((int)0).b).describe())) {
                ResolvedTypes componentType = ResolvedTypes.of((ResolvedType)typeParametersMap.get((int)0).b);
                componentType.prefix("[].");
                if (componentType.resolved) {
                    arrayNode.addPOJO(componentType.getValue());
                    this.cells.addAll(componentType.cells);
                }
            }
            this.value = arrayNode;
        }
    }

    private void resolvePojo(ResolvedReferenceTypeDeclaration typeDeclaration, List<Pair<ResolvedTypeParameterDeclaration, ResolvedType>> typeParametersMap) {
        this.objectNode = ObjectMappers.instance().createObjectNode();
        this.resolveFields(typeDeclaration, typeParametersMap);
    }

    private void resolveFields(ResolvedReferenceTypeDeclaration typeDeclaration, List<Pair<ResolvedTypeParameterDeclaration, ResolvedType>> typeParametersMap) {
        try {
            typeDeclaration.getAncestors().forEach(direct -> this.merge(ResolvedTypes.of((ResolvedType)direct)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ResolvedFieldDeclaration next : typeDeclaration.getDeclaredFields()) {
            if (next.isStatic() || typeDeclaration.equals(next.getType())) continue;
            String description = null;
            String name = Fields.getName(next);
            ResolvedTypes resolvedTypes = ResolvedTypes.ofTypeVariable(next.getType(), typeParametersMap);
            resolvedTypes.prefix(name + ".");
            if (next instanceof JavaParserFieldDeclaration) {
                JavaParserFieldDeclaration field = (JavaParserFieldDeclaration)next;
                if (Comments.isIgnore((Node)field.getWrappedNode())) continue;
                description = Comments.getCommentAsString(field);
                Object value = Fields.getInitializer(field);
                if (value != null) {
                    resolvedTypes.value = value;
                }
            }
            this.put(name, resolvedTypes, description);
        }
    }

    private void merge(ResolvedTypes other) {
        if (other.resolved && !other.primitive) {
            if (other.getValue() instanceof ObjectNode) {
                ObjectNode directValue = (ObjectNode)other.getValue();
                this.objectNode.setAll(directValue);
            }
            this.cells.addAll(other.cells);
        }
    }

    private void put(String key, ResolvedTypes other, String description) {
        if (other.resolved) {
            if (Objects.nonNull(other.getValue())) {
                this.objectNode.putPOJO(key, other.getValue());
            }
            Cell cell = new Cell(key, other.name);
            if (other.primitive) {
                cell.setValue(String.valueOf(other.getValue()));
            }
            if (description != null) {
                cell.setDescription(description);
            }
            this.cells.add(cell);
            this.cells.addAll(other.cells);
        }
    }

    public void prefix(String prefix) {
        for (Cell cell : this.cells) {
            cell.setName(prefix + cell.getName());
        }
    }

    private ResolvedTypes duplicate() {
        ResolvedTypes resolvedTypes = new ResolvedTypes();
        resolvedTypes.name = this.name;
        resolvedTypes.resolved = this.resolved;
        resolvedTypes.primitive = this.primitive;
        resolvedTypes.value = this.value;
        resolvedTypes.objectNode = this.objectNode;
        for (Cell cell : this.cells) {
            Cell newCell = new Cell(cell.getName(), cell.getType(), cell.isDisabled());
            newCell.setValue(cell.getValue());
            newCell.setDescription(cell.getDescription());
            resolvedTypes.cells.add(newCell);
        }
        return resolvedTypes;
    }
}

