/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.ast;

import com.github.apiggs.ast.extend.DocTag;
import com.github.apiggs.util.loging.Logger;
import com.github.apiggs.util.loging.LoggerFactory;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import com.github.javaparser.javadoc.description.JavadocDescriptionElement;
import com.github.javaparser.javadoc.description.JavadocInlineTag;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserFieldDeclaration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Comments {
    static Logger log = LoggerFactory.getLogger(Comments.class);
    public String name;
    public String description;
    public String content;
    public List<Tag> tags = new ArrayList<Tag>();
    public Tag returnTag;

    public static Optional<Comments> of(Optional<Comment> optional) {
        return optional.map(Comments::of);
    }

    public static Comments of(Comment n) {
        Comments comments = new Comments();
        comments.parse(n);
        return comments;
    }

    private void parse(Comment n) {
        if (n.isJavadocComment()) {
            this.parse(n.asJavadocComment());
        } else {
            this.setContent(n.getContent());
        }
    }

    private void parse(JavadocComment n) {
        StringBuilder builder = new StringBuilder();
        Javadoc javadoc = n.parse();
        for (JavadocDescriptionElement element : javadoc.getDescription().getElements()) {
            builder.append(element.toText());
        }
        this.setContent(builder.toString());
        for (JavadocBlockTag blockTag : javadoc.getBlockTags()) {
            Tag tag = new Tag();
            tag.name = blockTag.getTagName();
            tag.key = blockTag.getName().isPresent() ? (String)blockTag.getName().get() : null;
            StringBuilder tagDescription = new StringBuilder();
            for (JavadocDescriptionElement element : blockTag.getContent().getElements()) {
                if (element instanceof JavadocInlineTag) {
                    JavadocInlineTag inlineTag = (JavadocInlineTag)element;
                    if (inlineTag.getType().equals((Object)JavadocInlineTag.Type.LINK)) {
                        tag.link = inlineTag.getContent();
                        continue;
                    }
                    tag.inline.put(inlineTag.getName(), inlineTag.getContent());
                    continue;
                }
                tagDescription.append(element.toText());
            }
            tag.content = tagDescription.toString();
            this.tags.add(tag);
            if (!"return".equals(tag.name)) continue;
            this.returnTag = tag;
        }
    }

    public static String getTagContent(Optional<Comment> optional, String name) {
        Optional<Comments> optionalComments = Comments.of(optional);
        if (optionalComments.isPresent()) {
            Comments comments = optionalComments.get();
            for (Tag tag : comments.tags) {
                if (!Objects.equals(tag.name, name)) continue;
                return tag.content;
            }
        }
        return null;
    }

    public static Optional<Tag> getParamTag(Optional<Comment> optional, String name) {
        Optional<Comments> optionalComments = Comments.of(optional);
        if (optionalComments.isPresent()) {
            Comments comments = optionalComments.get();
            for (Tag tag : comments.tags) {
                if (!Objects.equals(tag.name, "param") || !Objects.equals(tag.key, name)) continue;
                return Optional.of(tag);
            }
        }
        return Optional.empty();
    }

    public static Optional<Integer> getIndexTag(Optional<Comment> optional) {
        String indexString = Comments.getTagContent(optional, DocTag.index.toString());
        if (indexString != null) {
            try {
                return Optional.of(Integer.parseInt(indexString));
            }
            catch (Exception e) {
                log.debug("read index fail:{}", indexString);
            }
        }
        return Optional.empty();
    }

    private void setContent(String content) {
        if (Objects.isNull(content)) {
            return;
        }
        this.content = content;
        String[] arr = content.split("(\\r\\n)|(\\r)|(\\n)+", 2);
        if (arr.length >= 1) {
            this.name = arr[0];
        }
        if (arr.length >= 2) {
            this.description = arr[1];
        }
    }

    public static String getCommentAsString(JavaParserFieldDeclaration declaration) {
        Optional optional = declaration.getWrappedNode().getComment();
        return Comments.of(optional).map(comments -> comments.content).orElse(null);
    }

    public static String getCommentFromMethod(Parameter expr) {
        MethodDeclaration method;
        Optional<Tag> tagOptional;
        if (expr.getParentNode().isPresent() && (tagOptional = Comments.getParamTag((method = (MethodDeclaration)expr.getParentNode().get()).getComment(), expr.getNameAsString())).isPresent()) {
            return tagOptional.get().content;
        }
        return null;
    }

    public static boolean isIgnore(Node node) {
        Optional<Comments> optional = Comments.of(node.getComment());
        if (optional.isPresent()) {
            for (Tag tag : optional.get().tags) {
                if (!Objects.equals(DocTag.ignore.name(), tag.name)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Tag {
        public String name;
        public String key;
        public String content;
        public String link;
        public Map<String, String> inline = new HashMap<String, String>();
    }
}

