/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.ast;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;

public class Classes {
    public static String getFullName(ClassOrInterfaceDeclaration n) {
        return Classes.getPackageName(n) + "." + Classes.getNameInScope(n);
    }

    public static String getPackageName(ClassOrInterfaceDeclaration n) {
        if (n.getParentNode().isPresent()) {
            CompilationUnit cu;
            if (n.getParentNode().get() instanceof CompilationUnit && (cu = (CompilationUnit)n.getParentNode().get()).getPackageDeclaration().isPresent()) {
                PackageDeclaration packageDeclaration = (PackageDeclaration)cu.getPackageDeclaration().get();
                return packageDeclaration.getNameAsString();
            }
            if (n.getParentNode().get() instanceof ClassOrInterfaceDeclaration) {
                return Classes.getPackageName((ClassOrInterfaceDeclaration)n.getParentNode().get());
            }
        }
        return "";
    }

    public static String getNameInScope(ClassOrInterfaceDeclaration n) {
        StringBuilder stringBuilder = new StringBuilder();
        Classes.appendNameInScope(n, stringBuilder);
        return stringBuilder.toString();
    }

    private static void appendNameInScope(ClassOrInterfaceDeclaration n, StringBuilder stringBuilder) {
        stringBuilder.insert(0, n.getNameAsString());
        if (n.getParentNode().isPresent() && n.getParentNode().get() instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration scope = (ClassOrInterfaceDeclaration)n.getParentNode().get();
            stringBuilder.insert(0, ".");
            Classes.appendNameInScope(scope, stringBuilder);
        }
    }
}

