/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs;

import com.github.apiggs.handler.AsciidocTreeHandler;
import com.github.apiggs.handler.HtmlTreeHandler;
import com.github.apiggs.handler.TreeHandler;
import com.github.apiggs.handler.postman.PostmanTreeHandler;
import com.github.apiggs.util.loging.Logger;
import com.github.apiggs.util.loging.LoggerFactory;
import com.github.apiggs.visitor.NodeVisitor;
import com.github.apiggs.visitor.springmvc.SpringVisitor;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JarTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;

public class Environment {
    Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String NAME = "apiggs";
    public static final Path DEFAULT_PRODUCTION = Paths.get("apiggs", new String[0]);
    public static final Path DEFAULT_SOURCE_STRUCTURE = Paths.get("src", "main", "java");
    public static final Path DEFAULT_PROJECT_PATH = Paths.get(System.getProperty("user.dir"), new String[0]);
    public static final Path DEFAULT_OUT = Paths.get("build", new String[0]);
    public static Iterable<TreeHandler> DEFAULT_PIPELINE = Lists.newArrayList((Object[])new TreeHandler[]{new PostmanTreeHandler(), new AsciidocTreeHandler(), new HtmlTreeHandler()});
    private Path project = DEFAULT_PROJECT_PATH;
    private Set<Path> sources = Sets.newHashSet();
    private Set<Path> dependencies = Sets.newHashSet();
    private Set<Path> jars = Sets.newHashSet();
    private Path production = DEFAULT_PRODUCTION;
    private Path out = DEFAULT_OUT;
    private String id = "index";
    private String title;
    private String description;
    private String version;
    public static ThreadLocal<Set<String>> ignoreTypes = new ThreadLocal();
    private Framework currentFramework = Framework.SPRINGMVC;
    private CombinedTypeSolver typeSolver;

    public Environment source(Path ... values) {
        for (Path value : values) {
            if (!value.isAbsolute()) {
                value = this.project.resolve(value);
            }
            if (!Files.exists(value, new LinkOption[0])) continue;
            this.sources.add(value);
        }
        this.dependency(values);
        return this;
    }

    public Environment dependency(Path ... values) {
        for (Path value : values) {
            if (!value.isAbsolute()) {
                value = this.project.resolve(value);
            }
            if (!Files.exists(value, new LinkOption[0])) continue;
            this.dependencies.add(value);
        }
        return this;
    }

    public Environment jar(Path ... values) {
        for (Path value : values) {
            if (!value.isAbsolute()) {
                value = this.project.resolve(value);
            }
            if (!Files.exists(value, new LinkOption[0])) continue;
            if (!Files.isDirectory(value, new LinkOption[0]) && value.toString().endsWith("jar")) {
                this.jars.add(value);
            }
            try {
                Files.list(value).forEach(xva$0 -> this.jar((Path)xva$0));
            }
            catch (IOException e) {
                this.log.debug("read list of {} error", value);
            }
        }
        return this;
    }

    public Environment id(String value) {
        this.id = value;
        return this;
    }

    public Environment project(Path value) {
        this.project = value;
        return this;
    }

    public Environment production(Path value) {
        this.production = value;
        return this;
    }

    public Environment out(Path value) {
        this.out = value;
        return this;
    }

    public Environment title(String value) {
        this.title = value;
        return this;
    }

    public Environment description(String value) {
        this.description = value;
        return this;
    }

    public Environment version(String value) {
        this.version = value;
        return this;
    }

    public Environment ignore(String ... values) {
        Environment.getIgnoreTypes().addAll(Sets.newHashSet((Object[])values));
        return this;
    }

    public Iterable<TreeHandler> pipeline() {
        return DEFAULT_PIPELINE;
    }

    public Framework currentFramework() {
        return this.currentFramework;
    }

    public ParserConfiguration buildParserConfiguration() {
        if (this.sources.isEmpty()) {
            this.source(this.project.resolve(DEFAULT_SOURCE_STRUCTURE));
        }
        this.typeSolver = new CombinedTypeSolver(new TypeSolver[0]);
        this.typeSolver.add((TypeSolver)new ReflectionTypeSolver());
        this.dependencies.forEach(value -> this.typeSolver.add((TypeSolver)new JavaParserTypeSolver(value)));
        this.jars.forEach(value -> {
            try {
                this.typeSolver.add((TypeSolver)new JarTypeSolver(value));
            }
            catch (IOException e) {
                this.log.debug("read jar fail:{}", value);
            }
        });
        ParserConfiguration parserConfiguration = new ParserConfiguration();
        parserConfiguration.setSymbolResolver((SymbolResolver)new JavaSymbolSolver((TypeSolver)this.typeSolver));
        return parserConfiguration;
    }

    public NodeVisitor visitor() {
        return this.currentFramework().visitor();
    }

    public Set<Path> getSources() {
        return this.sources;
    }

    public Set<Path> getDependencies() {
        return this.dependencies;
    }

    public Set<Path> getJars() {
        return this.jars;
    }

    public Path getOutPath() {
        if (this.out.isAbsolute()) {
            return this.out.resolve(this.production);
        }
        return this.project.resolve(this.out).resolve(this.production);
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public static Set<String> getIgnoreTypes() {
        HashSet ignores = ignoreTypes.get();
        if (ignores == null) {
            ignores = Sets.newHashSet();
            ignoreTypes.set(ignores);
        }
        return ignores;
    }

    public String getVersion() {
        return this.version;
    }

    public CombinedTypeSolver getTypeSolver() {
        return this.typeSolver;
    }

    public Path getProject() {
        return this.project;
    }

    private static enum Framework {
        SPRINGMVC(new SpringVisitor());

        private NodeVisitor visitor;

        private Framework(NodeVisitor visitor) {
            this.visitor = visitor;
        }

        public NodeVisitor visitor() {
            return this.visitor;
        }
    }
}

