/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs;

import com.github.apiggs.Environment;
import com.github.apiggs.handler.TreeHandler;
import com.github.apiggs.schema.Group;
import com.github.apiggs.schema.Tree;
import com.github.apiggs.util.loging.Logger;
import com.github.apiggs.util.loging.LoggerFactory;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.SourceRoot;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

public class Apiggs {
    Logger log = LoggerFactory.getLogger(this.getClass());
    Environment env;
    Tree tree;

    public Apiggs() {
        this(new Environment());
    }

    public Apiggs(Environment env) {
        this.env = env;
        this.tree = new Tree();
        this.tree.setId(env.getId());
        this.tree.setName(env.getTitle());
        this.tree.setDescription(env.getDescription());
        this.tree.setVersion(env.getVersion());
        env.visitor().setContext(this);
    }

    public Apiggs(String root) {
        this(new Environment().source(Paths.get(root, new String[0])));
    }

    public Apiggs lookup() {
        ParserConfiguration configuration = this.env.buildParserConfiguration();
        for (Path source : this.env.getSources()) {
            this.log.info("Parsing source : {}", source);
            SourceRoot root = new SourceRoot(source, configuration);
            root.tryToParseParallelized().forEach(result -> result.ifSuccessful(cu -> cu.accept((VoidVisitor)this.env.visitor(), (Object)this.getTree())));
        }
        this.tree.getGroups().sort(Group.COMPARATOR);
        Integer totalNodes = this.tree.getGroups().stream().map(g -> g.getNodes().size()).reduce(0, (sum, i) -> {
            sum = sum + i;
            return sum;
        });
        this.log.info("\r\nFound {} Controllers, {} Endpoints", this.tree.getGroups().size(), totalNodes);
        return this;
    }

    public void build() {
        this.env.pipeline().forEach(this::build);
    }

    public void build(TreeHandler ... handlers) {
        Arrays.stream(handlers).forEach(this::build);
    }

    public void build(TreeHandler handler) {
        handler.handle(this.tree, this.env);
    }

    public Tree getTree() {
        return this.tree;
    }

    public Environment getEnv() {
        return this.env;
    }
}

