/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.pathfinding.astar;

import com.almasb.fxgl.pathfinding.CellState;
import com.almasb.fxgl.pathfinding.Pathfinder;
import com.almasb.fxgl.pathfinding.astar.AStarCell;
import com.almasb.fxgl.pathfinding.astar.AStarGrid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class AStarPathfinder
implements Pathfinder<AStarCell> {
    private final AStarGrid grid;

    public AStarPathfinder(AStarGrid grid) {
        this.grid = grid;
    }

    public AStarGrid getGrid() {
        return this.grid;
    }

    @Override
    public List<AStarCell> findPath(int sourceX, int sourceY, int targetX, int targetY) {
        return this.findPath((AStarCell[][])this.grid.getData(), (AStarCell)this.grid.get(sourceX, sourceY), (AStarCell)this.grid.get(targetX, targetY), new AStarCell[0]);
    }

    @Override
    public List<AStarCell> findPath(int sourceX, int sourceY, int targetX, int targetY, List<AStarCell> busyCells) {
        return this.findPath((AStarCell[][])this.grid.getData(), (AStarCell)this.grid.get(sourceX, sourceY), (AStarCell)this.grid.get(targetX, targetY), busyCells.toArray(new AStarCell[0]));
    }

    public List<AStarCell> findPath(AStarCell[][] grid, AStarCell start, AStarCell target, AStarCell ... busyNodes) {
        if (start == target || target.getState() == CellState.NOT_WALKABLE) {
            return Collections.emptyList();
        }
        for (int y = 0; y < grid[0].length; ++y) {
            for (int x = 0; x < grid.length; ++x) {
                grid[x][y].setHCost(Math.abs(target.getX() - x) + Math.abs(target.getY() - y));
                grid[x][y].setParent(null);
                grid[x][y].setGCost(0);
            }
        }
        ArrayList<AStarCell> open = new ArrayList<AStarCell>();
        ArrayList<AStarCell> closed = new ArrayList<AStarCell>();
        AStarCell current = start;
        boolean found = false;
        while (!found && !closed.contains((Object)target)) {
            for (AStarCell neighbor : this.getValidNeighbors(current, busyNodes)) {
                if (neighbor == target) {
                    target.setParent(current);
                    found = true;
                    closed.add(target);
                    break;
                }
                if (closed.contains((Object)neighbor)) continue;
                if (open.contains((Object)neighbor)) {
                    int newG = current.getGCost() + 10;
                    if (newG >= neighbor.getGCost()) continue;
                    neighbor.setParent(current);
                    neighbor.setGCost(newG);
                    continue;
                }
                neighbor.setParent(current);
                neighbor.setGCost(current.getGCost() + 10);
                open.add(neighbor);
            }
            if (found) continue;
            closed.add(current);
            open.remove((Object)current);
            if (open.isEmpty()) {
                return Collections.emptyList();
            }
            AStarCell acc = (AStarCell)((Object)open.get(0));
            for (AStarCell a : open) {
                acc = a.getFCost() < acc.getFCost() ? a : acc;
            }
            current = acc;
        }
        return this.buildPath(start, target);
    }

    private List<AStarCell> buildPath(AStarCell start, AStarCell target) {
        ArrayList<AStarCell> path = new ArrayList<AStarCell>();
        AStarCell tmp = target;
        do {
            path.add(tmp);
        } while ((tmp = tmp.getParent()) != start);
        Collections.reverse(path);
        return path;
    }

    protected List<AStarCell> getValidNeighbors(AStarCell node, AStarCell ... busyNodes) {
        List<AStarCell> busyNodesList = Arrays.asList(busyNodes);
        return this.grid.getNeighbors(node.getX(), node.getY()).stream().filter(AStarCell::isWalkable).filter(neighbor -> !busyNodesList.contains(neighbor)).collect(Collectors.toList());
    }
}

