/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.KeySequence;
import com.baomidou.mybatisplus.annotation.OrderBy;
import com.baomidou.mybatisplus.annotation.Relation;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.incrementer.IKeyGenerator;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.Reflector;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.SimpleTypeRegistry;

public class TableInfoHelper {
    private static final Log logger = LogFactory.getLog(TableInfoHelper.class);
    private static final Map<Class<?>, TableInfo> TABLE_INFO_CACHE = new ConcurrentHashMap();
    private static final Map<String, TableInfo> TABLE_NAME_INFO_CACHE = new ConcurrentHashMap<String, TableInfo>();
    private static final String DEFAULT_ID_NAME = "id";

    public static TableInfo getTableInfo(Class<?> clazz) {
        if (clazz == null || clazz.isPrimitive() || SimpleTypeRegistry.isSimpleType(clazz) || clazz.isInterface()) {
            return null;
        }
        Class<?> targetClass = ClassUtils.getUserClass(clazz);
        TableInfo tableInfo = TABLE_INFO_CACHE.get(targetClass);
        if (null != tableInfo) {
            return tableInfo;
        }
        for (Class<?> currentClass = clazz; null == tableInfo && Object.class != currentClass; currentClass = currentClass.getSuperclass()) {
            tableInfo = TABLE_INFO_CACHE.get(ClassUtils.getUserClass(currentClass));
        }
        if (tableInfo != null) {
            TABLE_INFO_CACHE.put(targetClass, tableInfo);
        }
        return tableInfo;
    }

    public static TableInfo getTableInfo(String tableName) {
        if (StringUtils.isBlank(tableName)) {
            return null;
        }
        return TABLE_NAME_INFO_CACHE.get(tableName);
    }

    public static List<TableInfo> getTableInfos() {
        return Collections.unmodifiableList(new ArrayList<TableInfo>(TABLE_INFO_CACHE.values()));
    }

    public static void remove(Class<?> entityClass) {
        TABLE_INFO_CACHE.remove(entityClass);
    }

    public static synchronized TableInfo initTableInfo(MapperBuilderAssistant builderAssistant, Class<?> clazz, boolean isInitNamespace) {
        TableInfo targetTableInfo = TABLE_INFO_CACHE.get(clazz);
        Configuration configuration = builderAssistant.getConfiguration();
        if (targetTableInfo != null) {
            Configuration oldConfiguration = targetTableInfo.getConfiguration();
            if (!oldConfiguration.equals(configuration)) {
                targetTableInfo = TableInfoHelper.initTableInfo(configuration, isInitNamespace ? builderAssistant.getCurrentNamespace() : null, clazz, builderAssistant);
            }
            if (targetTableInfo.getCurrentNamespace() == null && isInitNamespace) {
                targetTableInfo.setCurrentNamespace(builderAssistant.getCurrentNamespace());
            }
            return targetTableInfo;
        }
        return TableInfoHelper.initTableInfo(configuration, isInitNamespace ? builderAssistant.getCurrentNamespace() : null, clazz, builderAssistant);
    }

    public static synchronized TableInfo initTableInfo(MapperBuilderAssistant builderAssistant, Class<?> clazz) {
        return TableInfoHelper.initTableInfo(builderAssistant, clazz, true);
    }

    private static synchronized TableInfo initTableInfo(Configuration configuration, String currentNamespace, Class<?> clazz, MapperBuilderAssistant builderAssistant) {
        TableInfo tableInfo = new TableInfo(configuration, clazz);
        tableInfo.setCurrentNamespace(currentNamespace);
        GlobalConfig globalConfig = GlobalConfigUtils.getGlobalConfig(configuration);
        String[] excludeProperty = TableInfoHelper.initTableName(clazz, globalConfig, tableInfo);
        List<String> excludePropertyList = excludeProperty != null && excludeProperty.length > 0 ? Arrays.asList(excludeProperty) : Collections.emptyList();
        TableInfoHelper.initTableFields(clazz, globalConfig, tableInfo, excludePropertyList, builderAssistant);
        tableInfo.initResultMapIfNeed();
        TABLE_INFO_CACHE.put(clazz, tableInfo);
        TABLE_NAME_INFO_CACHE.put(tableInfo.getTableName(), tableInfo);
        LambdaUtils.installCache(tableInfo);
        return tableInfo;
    }

    private static String[] initTableName(Class<?> clazz, GlobalConfig globalConfig, TableInfo tableInfo) {
        GlobalConfig.DbConfig dbConfig = globalConfig.getDbConfig();
        TableName table = clazz.getAnnotation(TableName.class);
        String tableName = clazz.getSimpleName();
        String tablePrefix = dbConfig.getTablePrefix();
        String schema = dbConfig.getSchema();
        boolean tablePrefixEffect = true;
        String[] excludeProperty = null;
        if (table != null) {
            if (StringUtils.isNotBlank(table.value())) {
                tableName = table.value();
                if (StringUtils.isNotBlank(tablePrefix) && !table.keepGlobalPrefix()) {
                    tablePrefixEffect = false;
                }
            } else {
                tableName = TableInfoHelper.initTableNameWithDbConfig(tableName, dbConfig);
            }
            if (StringUtils.isNotBlank(table.schema())) {
                schema = table.schema();
            }
            if (StringUtils.isNotBlank(table.resultMap())) {
                tableInfo.setResultMap(table.resultMap());
            }
            tableInfo.setAutoInitResultMap(table.autoResultMap());
            excludeProperty = table.excludeProperty();
        } else {
            tableName = TableInfoHelper.initTableNameWithDbConfig(tableName, dbConfig);
        }
        String targetTableName = tableName;
        if (StringUtils.isNotBlank(tablePrefix) && tablePrefixEffect) {
            targetTableName = tablePrefix + targetTableName;
        }
        if (StringUtils.isNotBlank(schema)) {
            targetTableName = schema + "." + targetTableName;
        }
        tableInfo.setTableName(targetTableName);
        if (CollectionUtils.isNotEmpty(dbConfig.getKeyGenerators())) {
            tableInfo.setKeySequence(clazz.getAnnotation(KeySequence.class));
        }
        if (table != null) {
            if (table.dbType() == null || table.dbType() == DbType.NONE) {
                tableInfo.setDbType(DbType.getDbType((String)dbConfig.getDbType()));
            } else {
                tableInfo.setDbType(table.dbType());
            }
        }
        return excludeProperty;
    }

    private static String initTableNameWithDbConfig(String className, GlobalConfig.DbConfig dbConfig) {
        String tableName = className;
        if (dbConfig.isTableUnderline()) {
            tableName = StringUtils.camelToUnderline(tableName);
        }
        tableName = dbConfig.isCapitalMode() ? tableName.toUpperCase() : StringUtils.firstToLowerCase(tableName);
        return tableName;
    }

    private static void initTableFields(Class<?> clazz, GlobalConfig globalConfig, TableInfo tableInfo, List<String> excludeProperty, MapperBuilderAssistant builderAssistant) {
        GlobalConfig.DbConfig dbConfig = globalConfig.getDbConfig();
        Reflector reflector = tableInfo.getReflector();
        List<Field> list = TableInfoHelper.getAllFields(clazz);
        List<Field> tableNotExistFields = TableInfoHelper.getTableNotExistFields(clazz);
        boolean isReadPK = false;
        boolean existTableId = TableInfoHelper.isExistTableId(list);
        boolean existTableLogic = TableInfoHelper.isExistTableLogic(list);
        ArrayList<TableFieldInfo> fieldList = new ArrayList<TableFieldInfo>(list.size());
        ArrayList<TableFieldInfo> relationFieldList = new ArrayList<TableFieldInfo>();
        for (Field field : list) {
            boolean isOrderBy;
            if (excludeProperty.contains(field.getName())) continue;
            boolean isPK = false;
            boolean bl = isOrderBy = field.getAnnotation(OrderBy.class) != null;
            if (existTableId) {
                TableId tableId = field.getAnnotation(TableId.class);
                if (tableId != null) {
                    if (isReadPK) {
                        throw ExceptionUtils.mpe("@TableId can't more than one in Class: \"%s\".", clazz.getName());
                    }
                    TableInfoHelper.initTableIdWithAnnotation(dbConfig, tableInfo, field, tableId);
                    isReadPK = true;
                    isPK = true;
                }
            } else if (!isReadPK) {
                isPK = isReadPK = TableInfoHelper.initTableIdWithoutAnnotation(dbConfig, tableInfo, field);
            }
            if (isPK) {
                if (!isOrderBy) continue;
                tableInfo.getOrderByFields().add(new TableFieldInfo(dbConfig, tableInfo, field, reflector, existTableLogic, true));
                continue;
            }
            TableField tableField = field.getAnnotation(TableField.class);
            if (tableField != null && tableField.relation() == Relation.NONE) {
                fieldList.add(new TableFieldInfo(dbConfig, tableInfo, field, tableField, reflector, existTableLogic, isOrderBy));
                continue;
            }
            if (tableField != null && tableField.relation() != Relation.NONE) {
                relationFieldList.add(new TableFieldInfo(dbConfig, tableInfo, field, tableField, reflector, existTableLogic, isOrderBy, tableField.relation(), tableField.target(), builderAssistant));
                continue;
            }
            fieldList.add(new TableFieldInfo(dbConfig, tableInfo, field, reflector, existTableLogic, isOrderBy));
        }
        ArrayList<TableFieldInfo> funFieldList = new ArrayList<TableFieldInfo>();
        for (Field field : tableNotExistFields) {
            TableField tableField = field.getAnnotation(TableField.class);
            if (tableField != null && tableField.relation() != Relation.NONE) {
                relationFieldList.add(new TableFieldInfo(dbConfig, tableInfo, field, tableField, reflector, existTableLogic, false, tableField.relation(), tableField.target(), builderAssistant));
                continue;
            }
            if (tableField == null || !tableField.funField()) continue;
            funFieldList.add(new TableFieldInfo(dbConfig, tableInfo, field, tableField, reflector, existTableLogic, false));
        }
        tableInfo.setFieldList(fieldList);
        tableInfo.setRelationFieldList(relationFieldList);
        tableInfo.setFunFieldList(funFieldList);
        tableInfo.init();
        if (!isReadPK) {
            logger.warn(String.format("Can not find table primary key in Class: \"%s\".", clazz.getName()));
        }
    }

    public static boolean isExistTableId(List<Field> list) {
        return list.stream().anyMatch(field -> field.isAnnotationPresent(TableId.class));
    }

    public static boolean isExistTableLogic(List<Field> list) {
        return list.stream().anyMatch(field -> field.isAnnotationPresent(TableLogic.class));
    }

    public static boolean isExistOrderBy(List<Field> list) {
        return list.stream().anyMatch(field -> field.isAnnotationPresent(OrderBy.class));
    }

    private static void initTableIdWithAnnotation(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field, TableId tableId) {
        boolean underCamel = tableInfo.isUnderCamel();
        String property = field.getName();
        if (field.getAnnotation(TableField.class) != null) {
            logger.warn(String.format("This \"%s\" is the table primary key by @TableId annotation in Class: \"%s\",So @TableField annotation will not work!", property, tableInfo.getEntityType().getName()));
        }
        if (IdType.NONE == tableId.type()) {
            tableInfo.setIdType(dbConfig.getIdType());
        } else {
            tableInfo.setIdType(tableId.type());
        }
        String column = property;
        if (StringUtils.isNotBlank(tableId.value())) {
            column = tableId.value();
        } else {
            if (underCamel) {
                column = StringUtils.camelToUnderline(column);
            }
            if (dbConfig.isCapitalMode()) {
                column = column.toUpperCase();
            }
        }
        Class keyType = tableInfo.getReflector().getGetterType(property);
        if (keyType.isPrimitive()) {
            logger.warn(String.format("This primary key of \"%s\" is primitive !\u4e0d\u5efa\u8bae\u5982\u6b64\u8bf7\u4f7f\u7528\u5305\u88c5\u7c7b in Class: \"%s\"", property, tableInfo.getEntityType().getName()));
        }
        tableInfo.setKeyRelated(TableInfoHelper.checkRelated(underCamel, property, column)).setKeyColumn(column).setKeyProperty(property).setKeyType(keyType).setKeyField(field);
    }

    private static boolean initTableIdWithoutAnnotation(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field) {
        String property = field.getName();
        if (DEFAULT_ID_NAME.equalsIgnoreCase(property)) {
            Class keyType;
            if (field.getAnnotation(TableField.class) != null) {
                logger.warn(String.format("This \"%s\" is the table primary key by default name for `id` in Class: \"%s\",So @TableField will not work!", property, tableInfo.getEntityType().getName()));
            }
            String column = property;
            if (dbConfig.isCapitalMode()) {
                column = column.toUpperCase();
            }
            if ((keyType = tableInfo.getReflector().getGetterType(property)).isPrimitive()) {
                logger.warn(String.format("This primary key of \"%s\" is primitive !\u4e0d\u5efa\u8bae\u5982\u6b64\u8bf7\u4f7f\u7528\u5305\u88c5\u7c7b in Class: \"%s\"", property, tableInfo.getEntityType().getName()));
            }
            tableInfo.setKeyRelated(TableInfoHelper.checkRelated(tableInfo.isUnderCamel(), property, column)).setIdType(dbConfig.getIdType()).setKeyColumn(column).setKeyProperty(property).setKeyType(keyType).setKeyField(field);
            return true;
        }
        return false;
    }

    public static boolean checkRelated(boolean underCamel, String property, String column) {
        column = StringUtils.getTargetColumn(column);
        String propertyUpper = property.toUpperCase(Locale.ENGLISH);
        String columnUpper = column.toUpperCase(Locale.ENGLISH);
        if (underCamel) {
            return !propertyUpper.equals(columnUpper) && !propertyUpper.equals(columnUpper.replace("_", ""));
        }
        return !propertyUpper.equals(columnUpper);
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        List<Field> fieldList = ReflectionKit.getFieldList(ClassUtils.getUserClass(clazz));
        return fieldList.stream().filter(field -> {
            TableField tableField = field.getAnnotation(TableField.class);
            return tableField == null || tableField.exist();
        }).collect(Collectors.toList());
    }

    public static List<Field> getTableNotExistFields(Class<?> clazz) {
        List<Field> fieldList = ReflectionKit.getFieldList(ClassUtils.getUserClass(clazz));
        return fieldList.stream().filter(field -> {
            TableField tableField = field.getAnnotation(TableField.class);
            return tableField != null && !tableField.exist();
        }).collect(Collectors.toList());
    }

    public static KeyGenerator genKeyGenerator(String baseStatementId, TableInfo tableInfo, MapperBuilderAssistant builderAssistant) {
        KeySequence keySequence;
        List<IKeyGenerator> keyGenerators = GlobalConfigUtils.getKeyGenerators(builderAssistant.getConfiguration());
        if (CollectionUtils.isEmpty(keyGenerators)) {
            throw new IllegalArgumentException("not configure IKeyGenerator implementation class.");
        }
        IKeyGenerator keyGenerator = null;
        if (keyGenerators.size() > 1 && null != (keySequence = tableInfo.getKeySequence()) && DbType.OTHER != keySequence.dbType()) {
            keyGenerator = keyGenerators.stream().filter(k -> k.dbType() == keySequence.dbType()).findFirst().get();
        }
        if (null == keyGenerator) {
            keyGenerator = keyGenerators.get(0);
        }
        tableInfo.setKeyGenerator(keyGenerator);
        Configuration configuration = builderAssistant.getConfiguration();
        String id = builderAssistant.getCurrentNamespace() + "." + baseStatementId + "!selectKey";
        ResultMap resultMap = new ResultMap.Builder(builderAssistant.getConfiguration(), id, tableInfo.getKeyType(), new ArrayList()).build();
        MappedStatement mappedStatement = new MappedStatement.Builder(builderAssistant.getConfiguration(), id, (SqlSource)new StaticSqlSource(configuration, keyGenerator.executeSql(tableInfo.getKeySequence().value())), SqlCommandType.SELECT).keyProperty(tableInfo.getKeyProperty()).resultMaps(Collections.singletonList(resultMap)).build();
        configuration.addMappedStatement(mappedStatement);
        return new SelectKeyGenerator(mappedStatement, true);
    }
}

