/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.injector.methods;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;

public class UpdateBatch
extends AbstractMethod {
    private static Map<DbType, GenUpdateSql> DB_FUNCTIONS = new HashMap<DbType, GenUpdateSql>();
    public static final Set<DbType> WARN_SET = new HashSet<DbType>();

    public UpdateBatch() {
        super(SqlMethod.UPDATE_BATCH.getMethod());
    }

    public UpdateBatch(String name) {
        super(name);
    }

    @Override
    public MappedStatement injectMappedStatement(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {
        SqlMethod sqlMethod = SqlMethod.UPDATE_BATCH;
        String sql = "";
        if (!DB_FUNCTIONS.containsKey(tableInfo.getDbType()) && !WARN_SET.contains(tableInfo.getDbType())) {
            logger.warn("db type: " + tableInfo.getDbType().getDb() + " does not support batch update");
            WARN_SET.add(tableInfo.getDbType());
        } else if (DB_FUNCTIONS.containsKey(tableInfo.getDbType())) {
            sql = DB_FUNCTIONS.get(tableInfo.getDbType()).genSql(mapperClass, modelClass, tableInfo);
        }
        sql = String.format(sqlMethod.getSql(), sql);
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        return this.addUpdateMappedStatement(mapperClass, modelClass, this.getMethod(sqlMethod), sqlSource);
    }

    public String genMysqlUpdateBatchSql(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {
        StringBuilder sql = new StringBuilder(" UPDATE ");
        sql.append(tableInfo.getTableName()).append("  a ").append("JOIN").append("(");
        String selectColumns = tableInfo.getAllInsertSqlColumn(null);
        String[] columns = selectColumns.split(",");
        String sqlProperty = tableInfo.getAllInsertSqlProperty("item.");
        String[] sqlPropertys = sqlProperty.split("},");
        StringBuilder selectValueField = new StringBuilder();
        if (tableInfo.getIdType() == IdType.AUTO) {
            selectValueField.append("#{item." + tableInfo.getKeyProperty() + "}").append(" AS ").append(tableInfo.getKeyColumn()).append(",");
        }
        try {
            for (int i = 0; i < sqlPropertys.length; ++i) {
                if (!StringUtils.isNotBlank(sqlPropertys[i])) continue;
                selectValueField.append(sqlPropertys[i]).append(" AS ").append(columns[i]).append(",");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String selectFrom = SqlScriptUtils.convertForeach(" SELECT " + SqlScriptUtils.convertTrim(selectValueField.toString(), null, null, null, ","), "coll", "index", "item", " UNION ALL ");
        sql.append(selectFrom);
        sql.append(")").append("  b ").append(" USING ").append("(").append(tableInfo.getKeyColumn()).append(")");
        sql.append("  SET  ");
        String tableA = "a.";
        String tableB = "b.";
        StringBuilder set = new StringBuilder();
        for (String column : columns) {
            set.append(tableA).append(column).append("=").append(tableB).append(column).append(",");
        }
        sql.append(SqlScriptUtils.convertTrim(set.toString(), null, null, null, ","));
        return sql.toString();
    }

    public String genPostgresqlUpdateBatchSql(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {
        StringBuilder sql = new StringBuilder(" UPDATE ").append(tableInfo.getTableName());
        String selectColumns = tableInfo.getAllInsertSqlColumn(null);
        String[] columns = selectColumns.split(",");
        StringBuilder set = new StringBuilder();
        String vtable = " vtable";
        for (String column : columns) {
            set.append(column).append("=").append(vtable).append(".").append(column.trim()).append(",");
        }
        sql.append(SqlScriptUtils.convertSet(SqlScriptUtils.convertTrim(set.toString(), null, null, null, ",")));
        sql.append(" FROM ").append("(").append(" VALUES ");
        String sqlProperty = tableInfo.getAllInsertSqlProperty("item.");
        String[] sqlPropertys = sqlProperty.split("},");
        StringBuilder selectValueField = new StringBuilder();
        if (tableInfo.getIdType() == IdType.AUTO) {
            selectValueField.append("#{item." + tableInfo.getKeyProperty() + "}");
        }
        for (int i = 0; i < sqlPropertys.length; ++i) {
            if (!StringUtils.isNotBlank(sqlPropertys[i])) continue;
            selectValueField.append(SqlScriptUtils.convertChoose(this.parsePropertyPostgresqlNotNull(sqlPropertys[i]), sqlPropertys[i], "null")).append(",");
        }
        sql.append(SqlScriptUtils.convertForeach(SqlScriptUtils.convertTrim(selectValueField.toString(), "(", ")", null, ","), "coll", "index", "item", ","));
        sql.append(")").append(" AS ").append(vtable).append("(");
        if (tableInfo.getIdType() == IdType.AUTO) {
            selectColumns = tableInfo.getKeyColumn() + "," + selectColumns;
        }
        sql.append(SqlScriptUtils.convertTrim(selectColumns, null, null, null, ","));
        sql.append(")").append("WHERE").append(vtable).append(".").append(tableInfo.getKeyColumn()).append("=").append(tableInfo.getTableName()).append(".").append(tableInfo.getKeyColumn());
        return sql.toString();
    }

    private String parsePropertyPostgresqlNotNull(String property) {
        return property.replaceAll("#\\{", "").replaceAll("}", "") + "!=null";
    }

    public String genOracleUpdateBatchSql(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {
        String template = "UPDATE %s %s WHERE %s=#{%s} %s";
        String additional = this.optlockVersion(tableInfo) + tableInfo.getLogicDeleteSql(true, true);
        String oneRowUpdateSql = String.format(template, tableInfo.getTableName(), this.sqlSet(tableInfo.isWithLogicDelete(), false, tableInfo, false, "item", "item."), tableInfo.getKeyColumn(), "item." + tableInfo.getKeyProperty(), additional);
        return SqlScriptUtils.convertForeach(oneRowUpdateSql, "coll", "index", "item", ";", "begin", ";end;");
    }

    public UpdateBatch init() {
        DB_FUNCTIONS.put(DbType.MYSQL, this::genMysqlUpdateBatchSql);
        DB_FUNCTIONS.put(DbType.ORACLE, this::genOracleUpdateBatchSql);
        DB_FUNCTIONS.put(DbType.ORACLE_12C, this::genOracleUpdateBatchSql);
        DB_FUNCTIONS.put(DbType.POSTGRE_SQL, this::genPostgresqlUpdateBatchSql);
        return this;
    }

    @FunctionalInterface
    public static interface GenUpdateSql {
        public String genSql(Class<?> var1, Class<?> var2, TableInfo var3);
    }
}

