/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.injector.methods;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;

public class InsertBatch
extends AbstractMethod {
    private static Map<DbType, GenSql> DB_FUNCTIONS = new HashMap<DbType, GenSql>();
    public static final Set<DbType> WARN_SET = new HashSet<DbType>();

    public InsertBatch() {
        super(SqlMethod.INSERT_BATCH.getMethod());
    }

    public InsertBatch(String name) {
        super(name);
    }

    @Override
    public MappedStatement injectMappedStatement(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {
        NoKeyGenerator keyGenerator = NoKeyGenerator.INSTANCE;
        SqlMethod sqlMethod = SqlMethod.INSERT_BATCH;
        String columnScript = "";
        String valuesScript = "";
        String values = "";
        if (!DB_FUNCTIONS.containsKey(tableInfo.getDbType()) && !WARN_SET.contains(tableInfo.getDbType())) {
            logger.warn("db type: " + tableInfo.getDbType().getDb() + " does not support batch insert");
            WARN_SET.add(tableInfo.getDbType());
        } else if (DB_FUNCTIONS.containsKey(tableInfo.getDbType())) {
            Map<SqlLocation, String> sqlMap = DB_FUNCTIONS.get(tableInfo.getDbType()).genSql(mapperClass, modelClass, tableInfo);
            columnScript = sqlMap.get((Object)SqlLocation.COLUMN);
            valuesScript = sqlMap.get((Object)SqlLocation.VALUE);
            values = sqlMap.get((Object)SqlLocation.VALUES);
        }
        String keyProperty = null;
        String keyColumn = null;
        if (StringUtils.isNotBlank(tableInfo.getKeyProperty()) && tableInfo.getIdType() == IdType.AUTO) {
            keyGenerator = Jdbc3KeyGenerator.INSTANCE;
            keyProperty = tableInfo.getKeyProperty();
            keyColumn = tableInfo.getKeyColumn();
        }
        String sql = String.format(sqlMethod.getSql(), tableInfo.getTableName(), columnScript, values, valuesScript);
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        return this.addInsertMappedStatement(mapperClass, modelClass, this.getMethod(sqlMethod), sqlSource, (KeyGenerator)keyGenerator, keyProperty, keyColumn);
    }

    public Map<SqlLocation, String> genCommonSql(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {
        HashMap<SqlLocation, String> resultSqlMap = new HashMap<SqlLocation, String>();
        resultSqlMap.put(SqlLocation.VALUES, " VALUES ");
        resultSqlMap.put(SqlLocation.COLUMN, SqlScriptUtils.convertTrim(tableInfo.getAllInsertSqlColumn(null), "(", ")", null, ","));
        resultSqlMap.put(SqlLocation.VALUE, SqlScriptUtils.convertForeach(SqlScriptUtils.convertTrim(tableInfo.getAllInsertSqlProperty("item."), "(", ")", null, ","), "coll", "index", "item", ","));
        return resultSqlMap;
    }

    public Map<SqlLocation, String> genOracleSql(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {
        HashMap<SqlLocation, String> resultSqlMap = new HashMap<SqlLocation, String>();
        resultSqlMap.put(SqlLocation.COLUMN, SqlScriptUtils.convertTrim(tableInfo.getAllInsertSqlColumn(null), "(", ")", null, ","));
        resultSqlMap.put(SqlLocation.VALUES, "  ");
        String selectColumns = tableInfo.getAllInsertSqlColumn(null);
        resultSqlMap.put(SqlLocation.COLUMN, SqlScriptUtils.convertTrim(selectColumns, "(", ")", null, ","));
        String insideSelect = " SELECT " + SqlScriptUtils.convertTrim(tableInfo.getAllInsertSqlColumn(null), null, null, null, ",") + " FROM " + "(";
        String[] columns = selectColumns.split(",");
        String sqlProperty = tableInfo.getAllInsertSqlProperty("item.");
        StringBuilder selectValueField = new StringBuilder();
        String[] sqlPropertys = sqlProperty.split(",");
        for (int i = 0; i < sqlPropertys.length; ++i) {
            if (!StringUtils.isNotBlank(sqlPropertys[i])) continue;
            selectValueField.append(SqlScriptUtils.convertChoose(this.parsePropertyOracleNotNull(sqlPropertys[i]), sqlPropertys[i], "null")).append(" AS ").append(columns[i]).append(",");
        }
        String selectFromdual = SqlScriptUtils.convertForeach(" SELECT " + SqlScriptUtils.convertTrim(selectValueField.toString(), null, null, null, ",") + " FROM " + " DUAL ", "coll", "index", "item", " UNION ALL ");
        resultSqlMap.put(SqlLocation.VALUE, insideSelect + selectFromdual + ")");
        return resultSqlMap;
    }

    private String parsePropertyOracleNotNull(String property) {
        return property.replaceAll("#\\{", "").replaceAll("}", "") + "!=null";
    }

    public InsertBatch init() {
        DB_FUNCTIONS.put(DbType.MYSQL, this::genCommonSql);
        DB_FUNCTIONS.put(DbType.POSTGRE_SQL, this::genCommonSql);
        DB_FUNCTIONS.put(DbType.SQL_SERVER, this::genCommonSql);
        DB_FUNCTIONS.put(DbType.ORACLE, this::genCommonSql);
        DB_FUNCTIONS.put(DbType.ORACLE_12C, this::genOracleSql);
        return this;
    }

    static enum SqlLocation {
        COLUMN,
        VALUES,
        VALUE;

    }

    @FunctionalInterface
    public static interface GenSql {
        public Map<SqlLocation, String> genSql(Class<?> var1, Class<?> var2, TableInfo var3);
    }
}

