/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.query.JoinQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.enums.BaseFuncEnum;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.ColumnCache;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractJoinWrapper<T, R, Children extends AbstractJoinWrapper<T, R, Children>>
extends AbstractWrapper<T, R, Children>
implements JoinQueryWrapper<T> {
    protected List<SelectColumn> selectColumns = new ArrayList<SelectColumn>();
    protected List<SharedString> funSqlSelect = new ArrayList<SharedString>();
    protected List<SelectColumn> ignoreColumns = new ArrayList<SelectColumn>();
    protected StringBuilder joinFroms = new StringBuilder();
    protected Map<Class<?>, String> aliasMap = new LinkedHashMap();
    protected SharedString sqlSelect = new SharedString();
    protected boolean isCount = false;
    protected boolean isAppendMainLogicDelete;

    public AbstractJoinWrapper(Class<?> mainClass) {
        String alias = this.parseAlias(mainClass);
        this.aliasMap.put(mainClass, alias);
        this.joinFroms.append(" ").append(alias).append(" ");
    }

    @Override
    protected void initNeed() {
        this.paramNameSeq = new AtomicInteger(0);
        this.paramNameValuePairs = new HashMap(16);
        this.expression = new MergeSegments();
        this.lastSql = SharedString.emptyString();
        this.sqlComment = SharedString.emptyString();
        this.sqlFirst = SharedString.emptyString();
    }

    public void setIsCount(boolean isCount) {
        this.isCount = isCount;
    }

    public String parseAlias(Class<?> clazz) {
        return this.aliasMap.computeIfAbsent(clazz, k -> {
            String className = k.getSimpleName();
            return className.substring(0, 1).toLowerCase() + className.substring(1);
        });
    }

    protected <LEFT, RIGHT> void pubJoin(Class<?> joinClass, LEFT leftProperty, RIGHT rightProperty, String joinType) {
        if (this.aliasMap.containsKey(joinClass)) {
            return;
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(joinClass);
        if (tableInfo == null) {
            throw ExceptionUtils.mpe("cat not get tableInfo from Class: \"%s\".", joinClass.getName());
        }
        String joinAlias = this.parseAlias(joinClass);
        this.aliasMap.put(joinClass, joinAlias);
        StringBuilder join = new StringBuilder(" " + joinType + " " + tableInfo.getTableName() + " " + joinAlias + " on ");
        if (rightProperty == null || leftProperty == null) {
            TableField tableField = null;
            Class<?> leftClass = null;
            boolean isBasicField = false;
            String leftAlias = null;
            Field leftField = null;
            block0: for (Class<?> clazz : this.aliasMap.keySet()) {
                if (leftField != null) break;
                List<Field> leftFields = TableInfoHelper.getAllFields(clazz);
                for (Field field : leftFields) {
                    TableField tempField;
                    if (!field.isAnnotationPresent(TableField.class) || !joinClass.equals((tempField = field.getAnnotation(TableField.class)).target()) && !joinClass.equals(field.getType()) || (tempField.modelFields().length == 0 || !StringUtils.isNotEmpty(tempField.modelFields()[0])) && (!field.getType().getName().startsWith("java.") || Collection.class.isAssignableFrom(field.getType()))) continue;
                    tableField = tempField;
                    leftClass = clazz;
                    leftField = field;
                    leftAlias = this.aliasMap.get(clazz);
                    if (!field.getType().getName().startsWith("java.")) continue block0;
                    isBasicField = true;
                    continue block0;
                }
            }
            if (tableField == null) {
                throw ExceptionUtils.mpe("cat not find relation from Class: \"%s\".", joinClass.getName());
            }
            String[] leftClassField = tableField.modelFields();
            String[] rightClassField = tableField.targetFields();
            if (leftClassField == null || leftClassField.length == 0 || StringUtils.isEmpty(leftClassField[0])) {
                leftClassField = new String[]{isBasicField ? leftField.getName() : TableInfoHelper.getTableInfo(leftClass).getKeyProperty()};
            }
            if (rightClassField == null || rightClassField.length == 0 || StringUtils.isEmpty(rightClassField[0])) {
                tableInfo = TableInfoHelper.getTableInfo(joinClass);
                rightClassField = new String[]{tableInfo.getKeyProperty()};
            }
            if (leftClassField.length != rightClassField.length) {
                throw ExceptionUtils.mpe("@TableField The left and right lengths are not equal : \"%s\".", joinClass.getName());
            }
            for (int i = 0; i < leftClassField.length; ++i) {
                if (i > 0) {
                    join.append(" and ");
                }
                join.append(leftAlias).append(".").append(AbstractJoinWrapper.getCache(leftClass, leftClassField[i]).getColumn()).append("=").append(joinAlias).append(".").append(AbstractJoinWrapper.getCache(joinClass, rightClassField[i]).getColumn());
            }
        } else {
            join.append(this.customBuildJoin(leftProperty, rightProperty));
        }
        this.joinFroms.append((CharSequence)join);
        this.initLogicDelete(joinClass, joinType);
    }

    protected <LEFT, RIGHT> String customBuildJoin(LEFT leftProperty, RIGHT rightProperty) {
        return "";
    }

    protected abstract void initLogicDelete(Class<?> var1, String var2);

    @Override
    public String getSqlSelect() {
        if (this.isCount) {
            return "*";
        }
        if (StringUtils.isBlank(this.sqlSelect.getStringValue())) {
            if (CollectionUtils.isNotEmpty(this.ignoreColumns)) {
                this.selectColumns.removeIf(c -> c.getFuncEnum() == null && this.ignoreColumns.stream().anyMatch(i -> i.getClazz() == c.getClazz() && Objects.equals(c.getColumnName(), i.getColumnName())));
            }
            HashSet notSetSelectClass = new HashSet(this.aliasMap.keySet());
            String s = this.selectColumns.stream().map(i -> {
                notSetSelectClass.remove(i.getClazz());
                String str = this.aliasMap.get(i.getClazz()) + "." + i.getColumnName();
                return (i.getFuncEnum() == null ? str : String.format(i.getFuncEnum().getSql(), str)) + (StringUtils.isBlank(i.getAlias()) ? "" : " AS " + i.getAlias());
            }).collect(Collectors.joining(","));
            if (notSetSelectClass.size() > 0) {
                if (StringUtils.isNotEmpty(s)) {
                    s = s + ",";
                }
                s = s + this.parseNotAssignTblColumn(notSetSelectClass);
            }
            this.sqlSelect.setStringValue(s);
            this.sqlSelect.setStringValue(StringUtils.parseSqlSelect(this.funSqlSelect, this.sqlSelect));
        }
        return this.sqlSelect.getStringValue();
    }

    public String parseNotAssignTblColumn(Collection<Class<?>> classes) {
        StringBuilder select = new StringBuilder();
        for (Class<?> aClass : classes) {
            TableInfo tableInfo = TableInfoHelper.getTableInfo(aClass);
            String alias = this.aliasMap.get(aClass);
            Set columns = tableInfo.getFieldList().stream().map(TableFieldInfo::getColumn).collect(Collectors.toSet());
            columns.add(tableInfo.getKeyColumn());
            if (select.length() > 0) {
                select.append(",");
            }
            select.append(columns.stream().map(column -> alias + "." + column + " AS " + alias + "_" + column).collect(Collectors.joining(",")));
        }
        return select.toString();
    }

    public static ColumnCache getCache(Class<?> modelClass, String property) {
        Map<String, ColumnCache> cacheMap = LambdaUtils.getColumnMap(modelClass);
        return cacheMap.get(property.toUpperCase());
    }

    public Children select(Class<T> entityClass, Predicate<TableFieldInfo> predicate) {
        TableInfo info = TableInfoHelper.getTableInfo(entityClass);
        Assert.notNull(info, "table can not be find", new Object[0]);
        info.getFieldList().stream().filter(predicate).collect(Collectors.toList()).forEach(i -> this.selectColumns.add(SelectColumn.of(entityClass, i.getColumn())));
        return (Children)((AbstractJoinWrapper)this.typedThis);
    }

    protected Object parseLogicNotDeleteValue(TableFieldInfo field) {
        Class<?> fieldType = field.getPropertyType();
        if (Integer.class.equals(fieldType)) {
            return Integer.parseInt(field.getLogicNotDeleteValue());
        }
        if (Long.class.equals(fieldType)) {
            return Long.parseLong(field.getLogicNotDeleteValue());
        }
        if (Boolean.class.equals(fieldType)) {
            return Boolean.parseBoolean(field.getLogicNotDeleteValue());
        }
        return field.getLogicNotDeleteValue();
    }

    @Override
    public boolean isJoin() {
        return true;
    }

    @Override
    public String getFrom() {
        return this.joinFroms.toString();
    }

    public static class SelectColumn {
        private Class<?> clazz;
        private String columnName;
        private String alias;
        private BaseFuncEnum funcEnum;

        private SelectColumn(Class<?> clazz, String columnName, String alias, BaseFuncEnum funcEnum) {
            this.clazz = clazz;
            this.columnName = columnName;
            this.alias = alias;
            if (this.alias == null) {
                String className = clazz.getSimpleName();
                this.alias = className.substring(0, 1).toLowerCase() + className.substring(1) + "_" + columnName;
            }
            this.funcEnum = funcEnum;
        }

        public static SelectColumn of(Class<?> clazz, String columnName) {
            return new SelectColumn(clazz, columnName, null, null);
        }

        public static SelectColumn of(Class<?> clazz, String columnName, String alias) {
            return new SelectColumn(clazz, columnName, alias, null);
        }

        public static SelectColumn of(Class<?> clazz, String columnName, String alias, BaseFuncEnum funcEnum) {
            return new SelectColumn(clazz, columnName, alias, funcEnum);
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getAlias() {
            return this.alias;
        }

        public BaseFuncEnum getFuncEnum() {
            return this.funcEnum;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public void setFuncEnum(BaseFuncEnum funcEnum) {
            this.funcEnum = funcEnum;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SelectColumn)) {
                return false;
            }
            SelectColumn other = (SelectColumn)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$clazz = this.getClazz();
            Class<?> other$clazz = other.getClazz();
            if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
                return false;
            }
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
                return false;
            }
            BaseFuncEnum this$funcEnum = this.getFuncEnum();
            BaseFuncEnum other$funcEnum = other.getFuncEnum();
            return !(this$funcEnum == null ? other$funcEnum != null : !this$funcEnum.equals(other$funcEnum));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SelectColumn;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $clazz = this.getClazz();
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            BaseFuncEnum $funcEnum = this.getFuncEnum();
            result = result * 59 + ($funcEnum == null ? 43 : $funcEnum.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractJoinWrapper.SelectColumn(clazz=" + this.getClazz() + ", columnName=" + this.getColumnName() + ", alias=" + this.getAlias() + ", funcEnum=" + this.getFuncEnum() + ")";
        }
    }
}

