/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.Result;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;

class MethodMapper {
    public final Method method;
    public final String queryString;
    public final ParamMapper[] paramMappers;
    private final ConsistencyLevel consistency;
    private final int fetchSize;
    private final boolean tracing;
    private Session session;
    private PreparedStatement statement;
    private boolean returnStatement;
    private Mapper<?> returnMapper;
    private boolean mapOne;
    private boolean async;

    MethodMapper(Method method, String queryString, ParamMapper[] paramMappers, ConsistencyLevel consistency, int fetchSize, boolean enableTracing) {
        this.method = method;
        this.queryString = queryString;
        this.paramMappers = paramMappers;
        this.consistency = consistency;
        this.fetchSize = fetchSize;
        this.tracing = enableTracing;
    }

    public void prepare(MappingManager manager, PreparedStatement ps) {
        this.session = manager.getSession();
        this.statement = ps;
        this.validateParameters();
        Class<?> returnType = this.method.getReturnType();
        if (Void.TYPE.isAssignableFrom(returnType) || ResultSet.class.isAssignableFrom(returnType)) {
            return;
        }
        if (Statement.class.isAssignableFrom(returnType)) {
            this.returnStatement = true;
            return;
        }
        if (ResultSetFuture.class.isAssignableFrom(returnType)) {
            this.async = true;
            return;
        }
        if (ListenableFuture.class.isAssignableFrom(returnType)) {
            this.async = true;
            Type k = ((ParameterizedType)this.method.getGenericReturnType()).getActualTypeArguments()[0];
            if (k instanceof Class && ResultSet.class.isAssignableFrom((Class)k)) {
                return;
            }
            this.mapType(manager, returnType, k);
        } else {
            this.mapType(manager, returnType, this.method.getGenericReturnType());
        }
    }

    private void validateParameters() {
        if (this.method.isVarArgs()) {
            throw new IllegalArgumentException(String.format("Invalid varargs method %s in @Accessor interface", this.method.getName()));
        }
        ColumnDefinitions variables = this.statement.getVariables();
        HashSet names = Sets.newHashSet();
        for (ColumnDefinitions.Definition variable : variables) {
            names.add(variable.getName());
        }
        if (this.method.getParameterTypes().length < names.size()) {
            throw new IllegalArgumentException(String.format("Not enough arguments for method %s, found %d but it should be at least the number of unique bind parameter names in the @Query (%d)", this.method.getName(), this.method.getParameterTypes().length, names.size()));
        }
        if (this.method.getParameterTypes().length > variables.size()) {
            throw new IllegalArgumentException(String.format("Too many arguments for method %s, found %d but it should be at most the number of bind parameters in the @Query (%d)", this.method.getName(), this.method.getParameterTypes().length, variables.size()));
        }
    }

    private void mapType(MappingManager manager, Class<?> fullReturnType, Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type raw = pt.getRawType();
            if (raw instanceof Class && Result.class.isAssignableFrom((Class)raw)) {
                type = pt.getActualTypeArguments()[0];
            } else {
                this.mapOne = true;
            }
        } else {
            this.mapOne = true;
        }
        if (!(type instanceof Class)) {
            throw new RuntimeException(String.format("Cannot map return of method %s to unsupported type %s", this.method, type));
        }
        try {
            this.returnMapper = manager.mapper((Class)type);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot map return to class " + fullReturnType, e);
        }
    }

    public Object invoke(Object[] args) {
        BoundStatement bs = this.statement.bind();
        ProtocolVersion protocolVersion = this.session.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion();
        for (int i = 0; i < args.length; ++i) {
            this.paramMappers[i].setValue(bs, args[i]);
        }
        if (this.consistency != null) {
            bs.setConsistencyLevel(this.consistency);
        }
        if (this.fetchSize > 0) {
            bs.setFetchSize(this.fetchSize);
        }
        if (this.tracing) {
            bs.enableTracing();
        }
        if (this.returnStatement) {
            return bs;
        }
        if (this.async) {
            ResultSetFuture future = this.session.executeAsync((Statement)bs);
            if (this.returnMapper == null) {
                return future;
            }
            return this.mapOne ? Futures.transform((ListenableFuture)future, this.returnMapper.mapOneFunctionWithoutAliases) : Futures.transform((ListenableFuture)future, this.returnMapper.mapAllFunctionWithoutAliases);
        }
        ResultSet rs = this.session.execute((Statement)bs);
        if (this.returnMapper == null) {
            return rs;
        }
        Result<?> result = this.returnMapper.map(rs);
        return this.mapOne ? result.one() : result;
    }

    static class ParamMapper {
        private final String paramName;
        private final int paramIdx;
        private final TypeToken<Object> paramType;
        private final TypeCodec<Object> codec;

        public ParamMapper(String paramName, int paramIdx, TypeToken<?> paramType, Class<? extends TypeCodec<?>> codecClass) {
            this.paramName = paramName;
            this.paramIdx = paramIdx;
            this.paramType = paramType;
            try {
                this.codec = codecClass == null ? null : codecClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Cannot create instance of codec %s for parameter %s", codecClass, paramName == null ? Integer.valueOf(paramIdx) : paramName), e);
            }
        }

        void setValue(BoundStatement boundStatement, Object arg) {
            if (this.paramName == null) {
                if (this.codec == null) {
                    boundStatement.set(this.paramIdx, arg, this.paramType);
                } else {
                    boundStatement.set(this.paramIdx, arg, this.codec);
                }
            } else if (this.codec == null) {
                boundStatement.set(this.paramName, arg, this.paramType);
            } else {
                boundStatement.set(this.paramName, arg, this.codec);
            }
        }
    }
}

