/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.core.datasource;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.config.ShardingProperties;
import com.dangdang.ddframe.rdb.sharding.config.ShardingPropertiesConstant;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorEngine;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractDataSourceAdapter;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.ShardingContext;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.connection.ShardingConnection;
import java.sql.SQLException;
import java.util.Properties;

public class ShardingDataSource
extends AbstractDataSourceAdapter
implements AutoCloseable {
    private final ShardingProperties shardingProperties;
    private final ExecutorEngine executorEngine;
    private final ShardingContext shardingContext;

    public ShardingDataSource(ShardingRule shardingRule) throws SQLException {
        this(shardingRule, new Properties());
    }

    public ShardingDataSource(ShardingRule shardingRule, Properties props) throws SQLException {
        super(shardingRule.getDataSourceRule().getDataSources());
        this.shardingProperties = new ShardingProperties(null == props ? new Properties() : props);
        int executorSize = (Integer)this.shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE);
        this.executorEngine = new ExecutorEngine(executorSize);
        boolean showSQL = (Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW);
        this.shardingContext = new ShardingContext(shardingRule, this.getDatabaseType(), this.executorEngine, showSQL);
    }

    @Override
    public ShardingConnection getConnection() throws SQLException {
        return new ShardingConnection(this.shardingContext);
    }

    @Override
    public void close() {
        this.executorEngine.close();
    }
}

