/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.client.service;

import com.ctrip.framework.apollo.openapi.client.exception.ApolloOpenApiException;
import com.ctrip.framework.apollo.openapi.client.service.AbstractOpenApiService;
import com.ctrip.framework.apollo.openapi.client.url.OpenApiPathBuilder;
import com.ctrip.framework.apollo.openapi.dto.OpenItemDTO;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class ItemOpenApiService
extends AbstractOpenApiService
implements com.ctrip.framework.apollo.openapi.api.ItemOpenApiService {
    public ItemOpenApiService(CloseableHttpClient client, String baseUrl, Gson gson) {
        super(client, baseUrl, gson);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OpenItemDTO getItem(String appId, String env, String clusterName, String namespaceName, String key) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        if (Strings.isNullOrEmpty((String)namespaceName)) {
            namespaceName = "application";
        }
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        this.checkNotEmpty(key, "Item key");
        OpenApiPathBuilder pathBuilder = OpenApiPathBuilder.newBuilder().envsPathVal(env).appsPathVal(appId).clustersPathVal(clusterName).namespacesPathVal(namespaceName).itemsPathVal(key);
        try (CloseableHttpResponse response = this.get(pathBuilder);){
            OpenItemDTO openItemDTO = (OpenItemDTO)this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), OpenItemDTO.class);
            return openItemDTO;
        }
        catch (Throwable ex) {
            if (ex instanceof ApolloOpenApiException && ((ApolloOpenApiException)ex).getStatus() == 404) {
                return null;
            }
            throw new RuntimeException(String.format("Get item: %s for appId: %s, cluster: %s, namespace: %s in env: %s failed", key, appId, clusterName, namespaceName, env), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OpenItemDTO createItem(String appId, String env, String clusterName, String namespaceName, OpenItemDTO itemDTO) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        if (Strings.isNullOrEmpty((String)namespaceName)) {
            namespaceName = "application";
        }
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        this.checkNotEmpty(itemDTO.getKey(), "Item key");
        this.checkNotEmpty(itemDTO.getDataChangeCreatedBy(), "Item created by");
        OpenApiPathBuilder pathBuilder = OpenApiPathBuilder.newBuilder().envsPathVal(env).appsPathVal(appId).clustersPathVal(clusterName).namespacesPathVal(namespaceName).customResource("items");
        try (CloseableHttpResponse response = this.post(pathBuilder, itemDTO);){
            OpenItemDTO openItemDTO = (OpenItemDTO)this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), OpenItemDTO.class);
            return openItemDTO;
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Create item: %s for appId: %s, cluster: %s, namespace: %s in env: %s failed", itemDTO.getKey(), appId, clusterName, namespaceName, env), ex);
        }
    }

    @Override
    public void updateItem(String appId, String env, String clusterName, String namespaceName, OpenItemDTO itemDTO) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        if (Strings.isNullOrEmpty((String)namespaceName)) {
            namespaceName = "application";
        }
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        this.checkNotEmpty(itemDTO.getKey(), "Item key");
        this.checkNotEmpty(itemDTO.getDataChangeLastModifiedBy(), "Item modified by");
        OpenApiPathBuilder pathBuilder = OpenApiPathBuilder.newBuilder().envsPathVal(env).appsPathVal(appId).clustersPathVal(clusterName).namespacesPathVal(namespaceName).itemsPathVal(itemDTO.getKey());
        try {
            CloseableHttpResponse ignored = this.put(pathBuilder, itemDTO);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Update item: %s for appId: %s, cluster: %s, namespace: %s in env: %s failed", itemDTO.getKey(), appId, clusterName, namespaceName, env), ex);
        }
    }

    @Override
    public void createOrUpdateItem(String appId, String env, String clusterName, String namespaceName, OpenItemDTO itemDTO) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        if (Strings.isNullOrEmpty((String)namespaceName)) {
            namespaceName = "application";
        }
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        this.checkNotEmpty(itemDTO.getKey(), "Item key");
        this.checkNotEmpty(itemDTO.getDataChangeCreatedBy(), "Item created by");
        if (Strings.isNullOrEmpty((String)itemDTO.getDataChangeLastModifiedBy())) {
            itemDTO.setDataChangeLastModifiedBy(itemDTO.getDataChangeCreatedBy());
        }
        OpenApiPathBuilder pathBuilder = OpenApiPathBuilder.newBuilder().envsPathVal(env).appsPathVal(appId).clustersPathVal(clusterName).namespacesPathVal(namespaceName).itemsPathVal(itemDTO.getKey()).addParam("createIfNotExists", "true");
        try {
            CloseableHttpResponse ignored = this.put(pathBuilder, itemDTO);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("CreateOrUpdate item: %s for appId: %s, cluster: %s, namespace: %s in env: %s failed", itemDTO.getKey(), appId, clusterName, namespaceName, env), ex);
        }
    }

    @Override
    public void removeItem(String appId, String env, String clusterName, String namespaceName, String key, String operator) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        if (Strings.isNullOrEmpty((String)namespaceName)) {
            namespaceName = "application";
        }
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        this.checkNotEmpty(key, "Item key");
        this.checkNotEmpty(operator, "Operator");
        OpenApiPathBuilder pathBuilder = OpenApiPathBuilder.newBuilder().envsPathVal(env).appsPathVal(appId).clustersPathVal(clusterName).namespacesPathVal(namespaceName).itemsPathVal(key).addParam("operator", operator);
        try {
            CloseableHttpResponse ignored = this.delete(pathBuilder);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Remove item: %s for appId: %s, cluster: %s, namespace: %s in env: %s failed", key, appId, clusterName, namespaceName, env), ex);
        }
    }
}

