/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.resolver;

import com.coreos.jetcd.resolver.SmartNameResolver;
import com.coreos.jetcd.resolver.URIResolverLoader;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SmartNameResolverFactory
extends NameResolver.Factory {
    private final String authority;
    private final Collection<URI> uris;
    private final URIResolverLoader loader;

    private SmartNameResolverFactory(String authority, Collection<URI> uris, URIResolverLoader loader) {
        Preconditions.checkNotNull((Object)loader, (Object)"URIResolverLoader should not be null");
        Preconditions.checkNotNull((Object)authority, (Object)"Authority should not be null");
        this.authority = authority;
        this.uris = uris;
        this.loader = loader;
    }

    @Nullable
    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        if ("etcd".equals(targetUri.getScheme())) {
            return new SmartNameResolver(this.authority, this.uris, this.loader);
        }
        return null;
    }

    public String getDefaultScheme() {
        return "etcd";
    }

    public static NameResolver.Factory forEndpoints(String authority, Collection<String> endpoints, URIResolverLoader loader) {
        List<URI> uris = endpoints.stream().map(endpoint -> {
            try {
                return new URI((String)endpoint);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }).collect(Collectors.toList());
        return new SmartNameResolverFactory(authority, uris, loader);
    }
}

