/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.auth;

import com.coreos.jetcd.auth.Permission;
import com.coreos.jetcd.data.AbstractResponse;
import com.coreos.jetcd.data.ByteSequence;
import java.util.List;
import java.util.stream.Collectors;

public class AuthRoleGetResponse
extends AbstractResponse<com.coreos.jetcd.api.AuthRoleGetResponse> {
    private List<Permission> permissions;

    public AuthRoleGetResponse(com.coreos.jetcd.api.AuthRoleGetResponse response) {
        super(response, response.getHeader());
    }

    private static Permission toPermission(com.coreos.jetcd.api.Permission perm) {
        Permission.Type type;
        ByteSequence key = ByteSequence.fromBytes(perm.getKey().toByteArray());
        ByteSequence rangeEnd = ByteSequence.fromBytes(perm.getRangeEnd().toByteArray());
        switch (perm.getPermType()) {
            case READ: {
                type = Permission.Type.READ;
                break;
            }
            case WRITE: {
                type = Permission.Type.WRITE;
                break;
            }
            case READWRITE: {
                type = Permission.Type.READWRITE;
                break;
            }
            default: {
                type = Permission.Type.UNRECOGNIZED;
            }
        }
        return new Permission(type, key, rangeEnd);
    }

    public synchronized List<Permission> getPermissions() {
        if (this.permissions == null) {
            this.permissions = ((com.coreos.jetcd.api.AuthRoleGetResponse)this.getResponse()).getPermList().stream().map(AuthRoleGetResponse::toPermission).collect(Collectors.toList());
        }
        return this.permissions;
    }
}

