/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.proxy;

import com.codeborne.selenide.proxy.FileDownloadFilter;
import com.codeborne.selenide.proxy.RequestSizeWatchdog;
import com.codeborne.selenide.proxy.ResponseSizeWatchdog;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import net.lightbody.bmp.BrowserMobProxy;
import net.lightbody.bmp.BrowserMobProxyServer;
import net.lightbody.bmp.client.ClientUtil;
import net.lightbody.bmp.filters.RequestFilter;
import net.lightbody.bmp.filters.RequestFilterAdapter;
import net.lightbody.bmp.filters.ResponseFilter;
import net.lightbody.bmp.filters.ResponseFilterAdapter;
import org.littleshoot.proxy.HttpFiltersSource;
import org.openqa.selenium.Proxy;

public class SelenideProxyServer {
    protected final Proxy outsideProxy;
    protected BrowserMobProxy proxy = new BrowserMobProxyServer(){
        int maxSize = 0x4000000;

        public void addRequestFilter(RequestFilter filter) {
            this.addFirstHttpFilterFactory((HttpFiltersSource)new RequestFilterAdapter.FilterSource(filter, this.maxSize));
        }

        public void addResponseFilter(ResponseFilter filter) {
            this.addLastHttpFilterFactory((HttpFiltersSource)new ResponseFilterAdapter.FilterSource(filter, this.maxSize));
        }
    };
    protected int port;
    protected Map<String, RequestFilter> requestFilters = new HashMap<String, RequestFilter>();
    protected Map<String, ResponseFilter> responseFilters = new HashMap<String, ResponseFilter>();

    public SelenideProxyServer(Proxy outsideProxy) {
        this.outsideProxy = outsideProxy;
    }

    public void start() {
        this.proxy.setTrustAllServers(true);
        if (this.outsideProxy != null) {
            this.proxy.setChainedProxy(SelenideProxyServer.getProxyAddress(this.outsideProxy));
        }
        this.addRequestFilter("requestSizeWatchdog", new RequestSizeWatchdog());
        this.addResponseFilter("responseSizeWatchdog", new ResponseSizeWatchdog());
        this.addResponseFilter("download", new FileDownloadFilter());
        this.proxy.start();
        this.port = this.proxy.getPort();
    }

    private void addRequestFilter(String name, RequestFilter requestFilter) {
        this.proxy.addRequestFilter(requestFilter);
        this.requestFilters.put(name, requestFilter);
    }

    private void addResponseFilter(String name, ResponseFilter responseFilter) {
        this.proxy.addResponseFilter(responseFilter);
        this.responseFilters.put(name, responseFilter);
    }

    static InetSocketAddress getProxyAddress(Proxy proxy) {
        String httpProxy = proxy.getHttpProxy();
        String host = httpProxy.replaceFirst("(.*):.*", "$1");
        String port = httpProxy.replaceFirst(".*:(.*)", "$1");
        return new InetSocketAddress(host, Integer.parseInt(port));
    }

    public Proxy createSeleniumProxy() {
        return ClientUtil.createSeleniumProxy((BrowserMobProxy)this.proxy);
    }

    public void shutdown() {
        this.proxy.abort();
    }

    public String toString() {
        return String.format("Selenide proxy server :%s", this.port);
    }

    public <T extends RequestFilter> T requestFilter(String name) {
        return (T)this.requestFilters.get(name);
    }

    public <T extends ResponseFilter> T responseFilter(String name) {
        return (T)this.responseFilters.get(name);
    }
}

