/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.util;

import bboss.org.apache.velocity.VelocityContext;
import bboss.org.apache.velocity.context.Context;
import com.frameworkset.common.poolman.ConfigSQLExecutor;
import com.frameworkset.util.SimpleStringUtil;
import com.frameworkset.util.VariableHandler;
import java.io.Writer;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.persitent.util.GloableSQLUtil;
import org.frameworkset.persitent.util.SQLInfo;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.db.TranSQLInfo;
import org.frameworkset.tran.plugin.db.output.DBOutputConfig;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.util.annotations.DateFormateMeta;

public abstract class TranUtil {
    public static final String lineSeparator = System.getProperty("line.separator");

    private static TranSQLInfo buildTranSQLInfo(String sqlName, boolean issql, String sqlFilepath, String dbname) {
        if (sqlName == null || sqlName.equals("")) {
            return null;
        }
        TranSQLInfo sqlInfo = new TranSQLInfo();
        SQLInfo sqlinfo = null;
        ConfigSQLExecutor configSQLExecutor = null;
        try {
            if (issql) {
                sqlinfo = GloableSQLUtil.getGlobalSQLUtil().getSQLInfo(sqlName);
            } else {
                configSQLExecutor = new ConfigSQLExecutor(sqlFilepath);
                sqlinfo = configSQLExecutor.getSqlInfo(dbname, sqlName);
            }
            if (sqlinfo == null) {
                return null;
            }
            sqlInfo.setOriginSQL(sqlinfo.getSql());
            String sql = TranUtil.parserSQL(sqlinfo);
            VariableHandler.SQLStruction sqlstruction = sqlinfo.getSqlutil().getSQLStruction(sqlinfo, sql);
            sql = sqlstruction.getSql();
            sqlInfo.setSql(sql);
            List vars = sqlstruction.getVariables();
            sqlInfo.setVars(vars);
            return sqlInfo;
        }
        catch (SQLException e) {
            throw new DataImportException("Init TargetSQLInfo failed", e);
        }
    }

    public static void initTargetSQLInfo(DBOutputConfig dbOutputConfig, String db) throws DataImportException {
        TranSQLInfo sqlInfo = null;
        Object sqlinfo = null;
        String sqlName = dbOutputConfig.getInsertSqlName();
        if (SimpleStringUtil.isEmpty((String)sqlName)) {
            sqlName = dbOutputConfig.getSqlName();
        }
        if (sqlName == null) {
            sqlName = dbOutputConfig.getInsertSql();
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, true, dbOutputConfig.getSqlFilepath(), db);
        } else {
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, false, dbOutputConfig.getSqlFilepath(), db);
        }
        if (sqlInfo != null) {
            dbOutputConfig.setTargetSqlInfo(sqlInfo);
            sqlInfo = null;
        }
        if ((sqlName = dbOutputConfig.getUpdateSqlName()) == null) {
            sqlName = dbOutputConfig.getUpdateSql();
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, true, dbOutputConfig.getSqlFilepath(), db);
        } else {
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, false, dbOutputConfig.getSqlFilepath(), db);
        }
        if (sqlInfo != null) {
            dbOutputConfig.setTargetUpdateSqlInfo(sqlInfo);
            sqlInfo = null;
        }
        if ((sqlName = dbOutputConfig.getDeleteSqlName()) == null) {
            sqlName = dbOutputConfig.getDeleteSql();
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, true, dbOutputConfig.getSqlFilepath(), db);
        } else {
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, false, dbOutputConfig.getSqlFilepath(), db);
        }
        if (sqlInfo != null) {
            dbOutputConfig.setTargetDeleteSqlInfo(sqlInfo);
            sqlInfo = null;
        }
    }

    public static void initTaskContextSQLInfo(TaskContext taskContext, ImportContext importContext) {
        if (taskContext != null && taskContext.getDbmportConfig() != null) {
            DBConfig dbConfig;
            String dbName = null;
            if (taskContext.getTargetDBConfig() != null && (dbConfig = taskContext.getTargetDBConfig()) != null && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbName())) {
                dbName = dbConfig.getDbName();
            }
            OutputConfig outputConfig = importContext.getOutputConfig();
            if (dbName == null && outputConfig != null && outputConfig instanceof DBOutputConfig) {
                dbName = ((DBOutputConfig)outputConfig).getTargetDBName(taskContext);
            }
            if (dbName != null) {
                TranUtil.initTargetSQLInfo(taskContext, dbName);
            }
        }
    }

    public static void initTargetSQLInfo(TaskContext dbContext, String db) throws DataImportException {
        if (dbContext == null) {
            return;
        }
        ImportContext importContext = dbContext.getImportContext();
        OutputConfig outputConfig = importContext.getOutputConfig();
        if (!(outputConfig instanceof DBOutputConfig)) {
            return;
        }
        TranSQLInfo sqlInfo = null;
        Object sqlinfo = null;
        String sqlName = dbContext.getInsertSqlName();
        String sqlFilePath = dbContext.getSqlFilepath();
        if (sqlFilePath == null) {
            sqlFilePath = ((DBOutputConfig)outputConfig).getSqlFilepath();
        }
        if (sqlName == null) {
            sqlName = dbContext.getInsertSql();
            if (sqlName != null) {
                sqlInfo = TranUtil.buildTranSQLInfo(sqlName, true, sqlFilePath, db);
            }
        } else {
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, false, sqlFilePath, db);
        }
        if (sqlInfo != null) {
            dbContext.setTargetSqlInfo(sqlInfo);
            sqlInfo = null;
        }
        if ((sqlName = dbContext.getUpdateSqlName()) == null) {
            sqlName = dbContext.getUpdateSql();
            if (sqlName != null) {
                sqlInfo = TranUtil.buildTranSQLInfo(sqlName, true, sqlFilePath, db);
            }
        } else {
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, false, sqlFilePath, db);
        }
        if (sqlInfo != null) {
            dbContext.setTargetUpdateSqlInfo(sqlInfo);
            sqlInfo = null;
        }
        if ((sqlName = dbContext.getDeleteSqlName()) == null) {
            sqlName = dbContext.getDeleteSql();
            if (sqlName != null) {
                sqlInfo = TranUtil.buildTranSQLInfo(sqlName, true, sqlFilePath, db);
            }
        } else {
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, false, sqlFilePath, db);
        }
        if (sqlInfo != null) {
            dbContext.setTargetDeleteSqlInfo(sqlInfo);
            sqlInfo = null;
        }
    }

    private static VelocityContext buildVelocityContext() {
        VelocityContext context_ = new VelocityContext();
        return context_;
    }

    public static String parserSQL(SQLInfo sqlinfo) {
        String sql = null;
        if (sqlinfo.istpl()) {
            sqlinfo.getSqltpl().process();
            if (sqlinfo.istpl()) {
                VelocityContext vcontext = TranUtil.buildVelocityContext();
                BBossStringWriter sw = new BBossStringWriter();
                sqlinfo.getSqltpl().merge((Context)vcontext, (Writer)sw);
                sql = sw.toString();
            } else {
                sql = sqlinfo.getSql();
            }
        } else {
            sql = sqlinfo.getSql();
        }
        return sql;
    }

    public static Date getDateTimeValue(String colName, Object value, ImportContext importContext) throws DataImportException {
        return TranUtil.getDateTimeValue(colName, value, importContext, null);
    }

    public static Date getDateTimeValue(String colName, Object value, ImportContext importContext, String dateformat) throws DataImportException {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof String) {
            DateFormateMeta dateFormateMeta;
            DateFormat dateFormat = null;
            if (dateformat != null && !dateformat.equals("")) {
                dateFormateMeta = DateFormateMeta.buildDateFormateMeta((String)dateformat);
                dateFormat = dateFormateMeta.toDateFormat();
            } else if (importContext.getDateFormat() != null) {
                dateFormateMeta = DateFormateMeta.buildDateFormateMeta((String)importContext.getDateFormat(), (String)importContext.getLocale(), (String)importContext.getTimeZone());
                dateFormat = dateFormateMeta.toDateFormat();
            } else {
                dateFormat = SerialUtil.getDateFormateMeta().toDateFormat();
            }
            try {
                return dateFormat.parse((String)value);
            }
            catch (ParseException e) {
                throw new DataImportException("Illegment colName[" + colName + "] date value:" + (String)value, e);
            }
        }
        throw new DataImportException("Illegment colName[" + colName + "] date value:" + (String)value);
    }
}

