/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.task;

import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.bulk.BulkActionConfig;
import org.frameworkset.elasticsearch.client.BuildTool;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.handler.ESVoidResponseHandler;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.plugin.es.output.ElasticsearchOutputConfig;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.BaseTaskCommand;
import org.frameworkset.tran.task.TaskCommand;
import org.frameworkset.tran.task.TaskFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCommandImpl
extends BaseTaskCommand<String, String> {
    private ElasticsearchOutputConfig elasticsearchOutputConfig;
    private ClientInterface[] clientInterfaces;
    private String datas;
    private int tryCount;
    private static Logger logger = LoggerFactory.getLogger(TaskCommand.class);

    public TaskCommandImpl(ImportCount importCount, ImportContext importContext, ElasticsearchOutputConfig elasticsearchOutputConfig, long dataSize, int taskNo, String jobNo, Object lastValue, Status currentStatus, boolean reachEOFClosed, TaskContext taskContext) {
        super(importCount, importContext, dataSize, taskNo, jobNo, lastValue, currentStatus, reachEOFClosed, taskContext);
        this.elasticsearchOutputConfig = elasticsearchOutputConfig;
    }

    public ClientInterface[] getClientInterfaces() {
        return this.clientInterfaces;
    }

    @Override
    public String getDatas() {
        return this.datas;
    }

    public void setClientInterfaces(ClientInterface[] clientInterfaces) {
        this.clientInterfaces = clientInterfaces;
    }

    @Override
    public void setDatas(String datas) {
        this.datas = datas;
    }

    @Override
    public String execute() {
        String data = null;
        if (this.importContext.getMaxRetry() > 0 && this.tryCount >= this.importContext.getMaxRetry()) {
            throw new TaskFailedException("task execute failed:reached max retry times " + this.importContext.getMaxRetry());
        }
        ++this.tryCount;
        String actionUrl = BuildTool.buildActionUrl((BulkActionConfig)this.elasticsearchOutputConfig.getClientOptions(), (String)"took,errors,items.*._index,items.*._type,items.*._id,items.*.status,items.*.error");
        if (this.elasticsearchOutputConfig.isDebugResponse()) {
            for (ClientInterface clientInterface : this.clientInterfaces) {
                data = clientInterface.executeHttp(actionUrl, this.datas, "post");
            }
            this.finishTask();
            if (logger.isInfoEnabled()) {
                logger.info(data);
            }
        } else {
            if (this.elasticsearchOutputConfig.isDiscardBulkResponse() && this.importContext.getExportResultHandler() == null) {
                for (ClientInterface clientInterface : this.clientInterfaces) {
                    ESVoidResponseHandler esVoidResponseHandler = new ESVoidResponseHandler();
                    clientInterface.executeHttp(actionUrl, this.datas, "post", (ResponseHandler)esVoidResponseHandler);
                    if (esVoidResponseHandler.getElasticSearchException() == null) continue;
                    throw new DataImportException((Throwable)esVoidResponseHandler.getElasticSearchException());
                }
                this.finishTask();
                return null;
            }
            for (ClientInterface clientInterface : this.clientInterfaces) {
                data = clientInterface.executeHttp(actionUrl, this.datas, "post");
            }
            this.finishTask();
        }
        return data;
    }

    @Override
    public int getTryCount() {
        return this.tryCount;
    }
}

