/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.task;

import com.frameworkset.orm.annotation.BatchContext;
import java.io.Writer;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.Record;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.WaitTasksCompleteCallBack;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.metrics.ParallImportCount;
import org.frameworkset.tran.metrics.SerialImportCount;
import org.frameworkset.tran.metrics.job.BuildMapDataContext;
import org.frameworkset.tran.record.CommonStringRecord;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.task.BaseTranJob;
import org.frameworkset.tran.task.ParrelTranCommand;
import org.frameworkset.tran.task.SerialTranCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringTranJob
extends BaseTranJob {
    private static Logger logger = LoggerFactory.getLogger(StringTranJob.class);

    @Override
    public String batchExecute(SerialTranCommand serialTranCommand, Status currentStatus, ImportContext importContext, TranResultSet tranResultSet, BaseDataTran baseDataTran) {
        int count = 0;
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        String ret = null;
        int taskNo = 0;
        Exception exception = null;
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        Object lastValue = null;
        long start = System.currentTimeMillis();
        long istart = 0L;
        long end = 0L;
        long totalCount = 0L;
        long ignoreTotalCount = 0L;
        SerialImportCount importCount = new SerialImportCount(baseDataTran);
        int batchsize = importContext.getStoreBatchSize();
        boolean reachEOFClosed = false;
        try {
            istart = start;
            BatchContext batchContext = new BatchContext();
            BuildMapDataContext buildMapDataContext = this.buildMapDataContext(importContext);
            while (true) {
                Boolean hasNext;
                if ((hasNext = tranResultSet.next()) == null) {
                    if (count <= 0) continue;
                    baseDataTran.beforeOutputData(writer);
                    String _dd = builder.toString();
                    builder.setLength(0);
                    int _count = count;
                    count = 0;
                    taskNo = serialTranCommand.hanBatchActionTask(importCount, _count, taskNo, lastValue, _dd, reachEOFClosed, null);
                    if (!baseDataTran.isPrintTaskLog()) continue;
                    end = System.currentTimeMillis();
                    logger.info("Batch import Force flush datas Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + _count + " records.");
                    istart = end;
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                lastValue = lastValue == null ? importContext.max(currentValue, baseDataTran.getLastValue()) : importContext.max(lastValue, baseDataTran.getLastValue());
                Context context = importContext.buildContext(baseDataTran.getTaskContext(), tranResultSet, batchContext);
                if (!reachEOFClosed) {
                    reachEOFClosed = context.reachEOFClosed();
                }
                if (context.removed()) {
                    if (!reachEOFClosed) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                    continue;
                }
                context.refactorData();
                context.afterRefactor();
                if (context.isDrop()) {
                    ((ImportCount)importCount).increamentIgnoreTotalCount();
                    continue;
                }
                CommonRecord commonRecord = this.buildCommonRecord(context, baseDataTran);
                super.metricsMap(commonRecord, buildMapDataContext, importContext);
                serialTranCommand.buildStringRecord(context, (Writer)writer);
                if (++count < batchsize && !serialTranCommand.splitCheck(++totalCount)) continue;
                baseDataTran.beforeOutputData(writer);
                writer.flush();
                String datas = builder.toString();
                builder.setLength(0);
                writer.close();
                writer = new BBossStringWriter(builder);
                int _count = count;
                count = 0;
                taskNo = serialTranCommand.hanBatchActionTask(importCount, _count, taskNo, lastValue, datas, reachEOFClosed, null);
                if (!baseDataTran.isPrintTaskLog()) continue;
                end = System.currentTimeMillis();
                logger.info("Batch import Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + batchsize + " records.");
                istart = end;
            }
            String datas = null;
            if (count > 0) {
                baseDataTran.beforeOutputData(writer);
                datas = builder.toString();
                builder.setLength(0);
            }
            int oldTaskNo = taskNo;
            if ((taskNo = serialTranCommand.endSerialActionTask(importCount, count, taskNo, lastValue, datas, reachEOFClosed, null)) != oldTaskNo && baseDataTran.isPrintTaskLog()) {
                end = System.currentTimeMillis();
                logger.info("Batch import Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + count + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
            }
            if (baseDataTran.isPrintTaskLog()) {
                end = System.currentTimeMillis();
                logger.info("Batch import Execute Tasks:" + taskNo + ",All Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
            }
        }
        catch (DataImportException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new DataImportException(e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition(exception, importContext)) {
                if (!importContext.getDataTranPlugin().isMultiTran()) {
                    baseDataTran.stop();
                } else {
                    baseDataTran.stopTranOnly();
                }
            }
            try {
                writer.close();
            }
            catch (Exception exception2) {}
            baseDataTran.endJob(reachEOFClosed, importCount, exception);
        }
        return ret;
    }

    private CommonRecord buildCommonRecord(Context context, BaseDataTran baseDataTran) {
        Record dataRecord;
        CommonRecord record = baseDataTran.buildRecord(context);
        if (record.getDatas() == null && (dataRecord = context.getCurrentRecord()) instanceof CommonStringRecord) {
            record.setOringeData(dataRecord.getData());
        }
        context.setCommonRecord(record);
        return record;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String parallelBatchExecute(ParrelTranCommand parrelTranCommand, Status currentStatus, ImportContext importContext, TranResultSet tranResultSet, BaseDataTran baseDataTran) {
        int count = 0;
        long totalSize = 0L;
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        String ret = null;
        ExecutorService service = importContext.buildThreadPool();
        ArrayList<Future> tasks = new ArrayList<Future>();
        int taskNo = 0;
        ParallImportCount totalCount = new ParallImportCount(baseDataTran);
        Exception exception = null;
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        Object lastValue = null;
        TranErrorWrapper tranErrorWrapper = new TranErrorWrapper(importContext);
        int batchsize = importContext.getStoreBatchSize();
        boolean reachEOFClosed = false;
        try {
            Exception e;
            BatchContext batchContext = new BatchContext();
            BuildMapDataContext buildMapDataContext = this.buildMapDataContext(importContext);
            while (true) {
                if (!tranErrorWrapper.assertCondition()) {
                    tranResultSet.stop();
                    e = tranErrorWrapper.throwError();
                    if (e == null) break;
                    throw e;
                }
                Boolean hasNext = tranResultSet.next();
                if (hasNext == null) {
                    if (count <= 0) continue;
                    baseDataTran.beforeOutputData(writer);
                    String datas = builder.toString();
                    builder.setLength(0);
                    int _count = count;
                    count = 0;
                    taskNo = parrelTranCommand.hanBatchActionTask(totalCount, _count, taskNo, lastValue, datas, reachEOFClosed, null, service, tasks, tranErrorWrapper);
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                lastValue = lastValue == null ? importContext.max(currentValue, baseDataTran.getLastValue()) : importContext.max(lastValue, baseDataTran.getLastValue());
                Context context = importContext.buildContext(baseDataTran.getTaskContext(), tranResultSet, batchContext);
                if (!reachEOFClosed) {
                    reachEOFClosed = context.reachEOFClosed();
                }
                if (context.removed()) {
                    if (reachEOFClosed) continue;
                    ((ImportCount)totalCount).increamentIgnoreTotalCount();
                    continue;
                }
                context.refactorData();
                context.afterRefactor();
                if (context.isDrop()) {
                    ((ImportCount)totalCount).increamentIgnoreTotalCount();
                    continue;
                }
                CommonRecord commonRecord = this.buildCommonRecord(context, baseDataTran);
                super.metricsMap(commonRecord, buildMapDataContext, importContext);
                parrelTranCommand.buildStringRecord(context, (Writer)writer);
                if (++count < batchsize && !parrelTranCommand.splitCheck(++totalSize)) continue;
                baseDataTran.beforeOutputData(writer);
                String datas = builder.toString();
                builder.setLength(0);
                int _count = count;
                count = 0;
                taskNo = parrelTranCommand.hanBatchActionTask(totalCount, _count, taskNo, lastValue, datas, reachEOFClosed, null, service, tasks, tranErrorWrapper);
            }
            if (count > 0) {
                if (!tranErrorWrapper.assertCondition() && (e = tranErrorWrapper.throwError()) != null) {
                    throw e;
                }
                baseDataTran.beforeOutputData(writer);
                String datas = builder.toString();
                builder.setLength(0);
                taskNo = parrelTranCommand.hanBatchActionTask(totalCount, count, taskNo, lastValue, datas, reachEOFClosed, null, service, tasks, tranErrorWrapper);
            }
            if (baseDataTran.isPrintTaskLog()) {
                logger.info("Pararrel batch submit tasks:" + taskNo);
            }
        }
        catch (DataImportException e) {
            try {
                exception = e;
                throw e;
                catch (Exception e2) {
                    exception = e2;
                    throw new DataImportException(e2);
                }
            }
            catch (Throwable throwable) {
                baseDataTran.waitTasksComplete(tasks, service, exception, lastValue, totalCount, tranErrorWrapper, new WaitTasksCompleteCallBack(parrelTranCommand){
                    final /* synthetic */ ParrelTranCommand val$parrelTranCommand;
                    {
                        this.val$parrelTranCommand = parrelTranCommand;
                    }

                    @Override
                    public void call() {
                        this.val$parrelTranCommand.parrelCompleteAction();
                    }
                }, reachEOFClosed);
                try {
                    writer.close();
                    throw throwable;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        baseDataTran.waitTasksComplete(tasks, service, exception, lastValue, totalCount, tranErrorWrapper, new /* invalid duplicate definition of identical inner class */, reachEOFClosed);
        try {
            writer.close();
            return ret;
        }
        catch (Exception batchContext) {
            return ret;
        }
    }

    @Override
    public String serialExecute(SerialTranCommand serialTranCommand, Status currentStatus, ImportContext importContext, TranResultSet tranResultSet, BaseDataTran baseDataTran) {
        if (importContext.serialAllData()) {
            return this.serialExecuteAllRecoreds(serialTranCommand, currentStatus, importContext, tranResultSet, baseDataTran);
        }
        return this.serialExecuteOneRecord(serialTranCommand, currentStatus, importContext, tranResultSet, baseDataTran);
    }

    private String serialExecuteOneRecord(SerialTranCommand serialTranCommand, Status currentStatus, ImportContext importContext, TranResultSet tranResultSet, BaseDataTran baseDataTran) {
        Object lastValue = null;
        Exception exception = null;
        long start = System.currentTimeMillis();
        long lastSend = 0L;
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        SerialImportCount importCount = new SerialImportCount(baseDataTran);
        long totalCount = 0L;
        boolean reachEOFClosed = false;
        try {
            Object temp = null;
            long logInterval = 60000L;
            boolean printed = false;
            BatchContext batchContext = new BatchContext();
            BuildMapDataContext buildMapDataContext = this.buildMapDataContext(importContext);
            while (true) {
                Boolean hasNext;
                if ((hasNext = tranResultSet.next()) == null) {
                    if (!baseDataTran.isPrintTaskLog() || printed) continue;
                    if (lastSend > 0L) {
                        long end = System.currentTimeMillis();
                        long interval = end - lastSend;
                        if (interval < logInterval) continue;
                        logger.info("Auto Log Send datas Take time:" + (end - start) + "ms" + ",Send total " + totalCount + " records,IgnoreTotalCount " + ((ImportCount)importCount).getIgnoreTotalCount() + " records,FailedTotalCount " + ((ImportCount)importCount).getFailedCount() + " records.");
                        lastSend = 0L;
                        printed = true;
                        continue;
                    }
                    lastSend = System.currentTimeMillis();
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                lastSend = 0L;
                printed = false;
                try {
                    long end;
                    lastValue = lastValue == null ? importContext.max(currentValue, baseDataTran.getLastValue()) : importContext.max(lastValue, baseDataTran.getLastValue());
                    Context context = importContext.buildContext(baseDataTran.getTaskContext(), tranResultSet, batchContext);
                    if (!reachEOFClosed) {
                        reachEOFClosed = context.reachEOFClosed();
                    }
                    if (context.removed()) {
                        if (!reachEOFClosed) {
                            ((ImportCount)importCount).increamentIgnoreTotalCount();
                            continue;
                        }
                        importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                        continue;
                    }
                    context.refactorData();
                    context.afterRefactor();
                    if (context.isDrop()) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    StringBuilder builder = new StringBuilder();
                    BBossStringWriter writer = new BBossStringWriter(builder);
                    CommonRecord commonRecord = this.buildCommonRecord(context, baseDataTran);
                    super.metricsMap(commonRecord, buildMapDataContext, importContext);
                    serialTranCommand.buildStringRecord(context, (Writer)writer);
                    baseDataTran.beforeOutputData(writer);
                    serialTranCommand.hanBatchActionTask(importCount, 1L, -1, lastValue, builder.toString(), reachEOFClosed, commonRecord);
                    builder.setLength(0);
                    if (++totalCount == Long.MAX_VALUE) {
                        if (baseDataTran.isPrintTaskLog()) {
                            end = System.currentTimeMillis();
                            logger.info("Send datas  Take time:" + (end - start) + "ms" + ",Send total" + totalCount + " records,IgnoreTotalCount " + ((ImportCount)importCount).getIgnoreTotalCount() + " records,FailedTotalCount " + ((ImportCount)importCount).getFailedCount() + " records. totalCount has reach Long.MAX_VALUE and reset");
                        }
                        totalCount = 0L;
                        continue;
                    }
                    if (!baseDataTran.isPrintTaskLog() || importContext.getLogsendTaskMetric() <= 0L || totalCount % importContext.getLogsendTaskMetric() != 0L) continue;
                    end = System.currentTimeMillis();
                    logger.info("Send datas Take time:" + (end - start) + "ms" + ",Send total " + totalCount + " records,IgnoreTotalCount " + ((ImportCount)importCount).getIgnoreTotalCount() + " records,FailedTotalCount " + ((ImportCount)importCount).getFailedCount() + " records.");
                }
                catch (Exception e) {
                    throw new DataImportException(e);
                }
            }
            serialTranCommand.endSerialActionTask(importCount, -1L, -1, lastValue, null, reachEOFClosed, null);
            if (baseDataTran.isPrintTaskLog()) {
                long end = System.currentTimeMillis();
                logger.info("Send datas Take time:" + (end - start) + "ms" + ",Send total " + totalCount + " records,IgnoreTotalCount " + ((ImportCount)importCount).getIgnoreTotalCount() + " records,FailedTotalCount " + ((ImportCount)importCount).getFailedCount() + " records.");
            }
        }
        catch (DataImportException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new DataImportException(e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition(exception, importContext)) {
                if (!importContext.getDataTranPlugin().isMultiTran()) {
                    baseDataTran.stop();
                } else {
                    baseDataTran.stopTranOnly();
                }
            }
            if (importContext.isCurrentStoped()) {
                baseDataTran.stopTranOnly();
            }
            baseDataTran.endJob(reachEOFClosed, importCount, exception);
        }
        return null;
    }

    private String serialExecuteAllRecoreds(SerialTranCommand serialTranCommand, Status currentStatus, ImportContext importContext, TranResultSet tranResultSet, BaseDataTran baseDataTran) {
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        Object lastValue = null;
        Exception exception = null;
        long start = System.currentTimeMillis();
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        SerialImportCount importCount = new SerialImportCount(baseDataTran);
        int taskNo = 0;
        long totalCount = 0L;
        int count = 0;
        long ignoreTotalCount = 0L;
        boolean reachEOFClosed = false;
        try {
            BatchContext batchContext = new BatchContext();
            BuildMapDataContext buildMapDataContext = this.buildMapDataContext(importContext);
            while (true) {
                Boolean hasNext;
                if ((hasNext = tranResultSet.next()) == null) {
                    String ret = null;
                    if (builder.length() > 0) {
                        baseDataTran.beforeOutputData(writer);
                        String _dd = builder.toString();
                        builder.setLength(0);
                        taskNo = serialTranCommand.hanBatchActionTask(importCount, totalCount, taskNo, lastValue, _dd, reachEOFClosed, null);
                    } else {
                        ret = "{\"took\":0,\"errors\":false}";
                    }
                    if (!baseDataTran.isPrintTaskLog()) continue;
                    long end = System.currentTimeMillis();
                    logger.info("Force flush datas Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                try {
                    lastValue = lastValue == null ? importContext.max(currentValue, baseDataTran.getLastValue()) : importContext.max(lastValue, baseDataTran.getLastValue());
                    Context context = importContext.buildContext(baseDataTran.getTaskContext(), tranResultSet, batchContext);
                    if (!reachEOFClosed) {
                        reachEOFClosed = context.reachEOFClosed();
                    }
                    if (context.removed()) {
                        if (!reachEOFClosed) {
                            ((ImportCount)importCount).increamentIgnoreTotalCount();
                            continue;
                        }
                        importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                        continue;
                    }
                    context.refactorData();
                    context.afterRefactor();
                    if (context.isDrop()) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    CommonRecord commonRecord = this.buildCommonRecord(context, baseDataTran);
                    super.metricsMap(commonRecord, buildMapDataContext, importContext);
                    serialTranCommand.buildStringRecord(context, (Writer)writer);
                    ++count;
                    if (!serialTranCommand.splitCheck(++totalCount)) continue;
                    baseDataTran.beforeOutputData(writer);
                    String _dd = builder.toString();
                    builder.setLength(0);
                    writer.close();
                    writer = new BBossStringWriter(builder);
                    int _count = count;
                    count = 0;
                    taskNo = serialTranCommand.hanBatchActionTask(importCount, _count, taskNo, lastValue, _dd, reachEOFClosed, null);
                }
                catch (Exception e) {
                    throw new DataImportException(e);
                }
            }
            String datas = null;
            if (builder.length() > 0) {
                baseDataTran.beforeOutputData(writer);
                datas = builder.toString();
                builder.setLength(0);
            }
            taskNo = serialTranCommand.endSerialActionTask(importCount, totalCount, taskNo, lastValue, datas, reachEOFClosed, null);
            if (baseDataTran.isPrintTaskLog()) {
                long end = System.currentTimeMillis();
                logger.info("Serial import Take time:" + (end - start) + "ms" + ",Total Import  " + totalCount + " records,Total Ignore Count " + ((ImportCount)importCount).getIgnoreTotalCount() + " records,Total Failed Count " + ((ImportCount)importCount).getFailedCount() + " records.");
            }
        }
        catch (DataImportException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new DataImportException(e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition(exception, importContext)) {
                if (!importContext.getDataTranPlugin().isMultiTran()) {
                    baseDataTran.stop();
                } else {
                    baseDataTran.stopTranOnly();
                }
            }
            if (importContext.isCurrentStoped()) {
                baseDataTran.stopTranOnly();
            }
            baseDataTran.endJob(reachEOFClosed, importCount, exception);
        }
        return null;
    }
}

