/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.task;

import java.util.List;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.entity.MapData;
import org.frameworkset.tran.metrics.job.BuildMapDataContext;
import org.frameworkset.tran.plugin.metrics.output.ETLMetrics;
import org.frameworkset.tran.plugin.metrics.output.MetricsData;
import org.frameworkset.tran.task.TranJob;

public abstract class BaseTranJob
implements TranJob {
    protected void metricsMap(CommonRecord commonRecord, BuildMapDataContext buildMapDataContext, ImportContext importContext) {
        if (buildMapDataContext == null) {
            return;
        }
        BaseTranJob.map(commonRecord, buildMapDataContext, importContext.getMetrics(), importContext.isUseDefaultMapData());
    }

    public BuildMapDataContext buildMapDataContext(ImportContext importContext) {
        List<ETLMetrics> etlMetrics = importContext.getMetrics();
        BuildMapDataContext buildMapDataContext = null;
        if (etlMetrics != null) {
            buildMapDataContext = new BuildMapDataContext();
            String dataTimeField = importContext.getDataTimeField();
            buildMapDataContext.setDataTimeField(dataTimeField);
        }
        return buildMapDataContext;
    }

    public static void map(CommonRecord commonRecord, BuildMapDataContext buildMapDataContext, List<ETLMetrics> etlMetrics, boolean isUseDefaultMapData) {
        MetricsData metricsData = new MetricsData();
        metricsData.setBuildMapDataContext(buildMapDataContext);
        metricsData.setCommonRecord(commonRecord);
        MapData defaultMapData = null;
        if (isUseDefaultMapData) {
            defaultMapData = new MapData();
            metricsData.setData(defaultMapData, null);
        }
        for (ETLMetrics metrics : etlMetrics) {
            if (metrics.getDataTimeField() != null || metrics.getBuildMapData() != null || defaultMapData == null) {
                metrics.map(metrics.buildMapData(metricsData));
                continue;
            }
            metrics.map(defaultMapData);
        }
    }
}

