/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.task;

import java.util.Date;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.context.JobContext;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.metrics.TaskMetrics;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.TaskCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTaskCommand<DATA, RESULT>
implements TaskCommand<DATA, RESULT> {
    private static Logger logger = LoggerFactory.getLogger(BaseTaskCommand.class);
    protected ImportCount importCount;
    protected ImportContext importContext;
    protected TaskMetrics taskMetrics;
    protected TaskContext taskContext;
    protected Object lastValue;
    protected long dataSize;
    protected long totalSize;
    protected boolean reachEOFClosed;
    protected Status currentStatus;

    @Override
    public void init() {
        TaskMetrics taskMetrics = this.getTaskMetrics();
        taskMetrics.setJobStartTime(this.taskContext.getJobStartTime());
        taskMetrics.setTaskStartTime(new Date());
        if (this.taskContext != null) {
            this.taskContext.beginTask(taskMetrics);
        }
    }

    @Override
    public JobContext getJobContext() {
        if (this.importContext != null) {
            return this.importContext.getJobContext();
        }
        return null;
    }

    @Override
    public Object getLastValue() {
        return this.lastValue;
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    @Override
    public TaskMetrics getTaskMetrics() {
        return this.taskMetrics;
    }

    @Override
    public int getTaskNo() {
        return this.taskMetrics.getTaskNo();
    }

    @Override
    public String getJobNo() {
        return this.taskMetrics.getJobNo();
    }

    @Override
    public ImportContext getImportContext() {
        return this.importContext;
    }

    @Override
    public void finishTask() {
        this.importContext.flushLastValue(this.lastValue, this.currentStatus);
    }

    @Override
    public long getElapsed() {
        if (this.taskMetrics != null) {
            return this.taskMetrics.getElapsed();
        }
        return -1L;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public BaseTaskCommand(ImportCount importCount, ImportContext importContext, long dataSize, int taskNo, String jobNo, Object lastValue, Status currentStatus, boolean reachEOFClosed, TaskContext taskContext) {
        this.importCount = importCount;
        this.importContext = importContext;
        this.dataSize = dataSize;
        this.totalSize = importCount.getTotalCount();
        this.taskMetrics = new TaskMetrics();
        this.taskMetrics.setTaskNo(taskNo);
        this.taskMetrics.setJobNo(jobNo);
        this.taskMetrics.setJobId(importContext.getJobId());
        this.taskMetrics.setJobName(importContext.getJobName());
        this.lastValue = lastValue;
        this.currentStatus = currentStatus;
        this.reachEOFClosed = reachEOFClosed;
        this.taskContext = taskContext;
    }

    @Override
    public ImportCount getImportCount() {
        return this.importCount;
    }

    @Override
    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    @Override
    public void finished() {
        try {
            if (this.taskContext != null && this.taskMetrics != null) {
                this.taskContext.finishTaskMetrics(this.taskMetrics);
            }
        }
        catch (Exception e) {
            logger.error("Task finished failed:", (Throwable)e);
        }
    }
}

