/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.status;

import com.frameworkset.common.poolman.SQLExecutor;
import com.frameworkset.common.poolman.util.DBConf;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.status.InitLastValueClumnName;
import org.frameworkset.tran.status.LoadCurrentStatus;
import org.frameworkset.tran.status.StatusFlushThread;
import org.frameworkset.tran.status.StatusManager;
import org.frameworkset.util.TimeUtil;
import org.frameworkset.util.shutdown.ShutdownUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStatusManager
implements StatusManager {
    private DataTranPlugin dataTranPlugin;
    private boolean increamentImport = true;
    protected ImportContext importContext;
    protected volatile Status currentStatus;
    protected volatile Status firstStatus;
    protected String updateSQL;
    protected String updateByJobIdSQL;
    protected String updateStatusSQL;
    protected String updateByJobIdStatusSQL;
    protected String insertSQL;
    protected String insertHistorySQL;
    protected String createStatusTableSQL;
    protected String createHistoryStatusTableSQL;
    protected String selectSQL;
    protected String selectByJobIdSQL;
    protected String checkFieldSQL;
    protected String checkHisFieldSQL;
    protected String deleteSQL;
    protected String deleteByJobIdSQL;
    protected String selectAllSQL;
    protected String selectAllByJobIdSQL;
    protected String existSQL;
    protected String existHisSQL;
    protected Date initLastDate = null;
    protected String statusDbname;
    protected boolean useOuterStatusDb = false;
    protected String statusTableName;
    protected String historyStatusTableName;
    protected String statusStorePath;
    protected String lastValueClumnName;
    private static Logger logger = LoggerFactory.getLogger(BaseStatusManager.class);
    protected int lastValueType;
    private StatusFlushThread flushThread;
    private boolean stoped;
    private ReadWriteLock putStatusLock = new ReentrantReadWriteLock();
    private Lock read = this.putStatusLock.readLock();
    private Lock write = this.putStatusLock.writeLock();

    public BaseStatusManager(DataTranPlugin dataTranPlugin) {
        this.dataTranPlugin = dataTranPlugin;
        this.importContext = dataTranPlugin.getImportContext();
    }

    public DataTranPlugin getDataTranPlugin() {
        return this.dataTranPlugin;
    }

    public void init() {
        this.flushThread = new StatusFlushThread(this, this.dataTranPlugin.getImportContext().getAsynFlushStatusInterval());
        this.flushThread.start();
        ShutdownUtil.addShutdownHook((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (BaseStatusManager.this.isStoped()) {
                    return;
                }
                BaseStatusManager baseStatusManager = BaseStatusManager.this;
                synchronized (baseStatusManager) {
                    if (BaseStatusManager.this.isStoped()) {
                        return;
                    }
                    BaseStatusManager.this.flushStatus();
                }
            }
        });
    }

    protected abstract void _putStatus(Status var1);

    @Override
    public void putStatus(Status currentStatus) throws Exception {
        this.read.lock();
        try {
            this._putStatus(currentStatus);
        }
        finally {
            this.read.unlock();
        }
    }

    protected abstract void _flushStatus() throws Exception;

    @Override
    public void flushStatus() {
        this.write.lock();
        try {
            this._flushStatus();
        }
        catch (Exception throwables) {
            logger.error("flushStatus failed:statusDbname[" + this.statusDbname + "],updateSQL[" + this.updateSQL + "]", (Throwable)throwables);
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.stoped) {
            return;
        }
        this.stoped = true;
        if (this.flushThread != null) {
            this.flushThread.interrupt();
        }
    }

    @Override
    public synchronized boolean isStoped() {
        return this.stoped;
    }

    protected Object convertLastValue(Object lastValue) {
        if (lastValue == null) {
            return null;
        }
        if (lastValue instanceof Date) {
            lastValue = new Long(((Date)lastValue).getTime());
        }
        return lastValue;
    }

    public static boolean needUpdate(Integer lastValueType, Object oldValue, Object newValue) {
        boolean e;
        if (newValue == null) {
            return false;
        }
        if (oldValue == null) {
            return true;
        }
        if (lastValueType == 1) {
            Date newValueDate = (Date)newValue;
            Date oldValueDate = (Date)oldValue;
            return newValueDate.after(oldValueDate);
        }
        if (oldValue instanceof Integer && newValue instanceof Integer) {
            int e2 = ((Integer)oldValue).compareTo((Integer)newValue);
            return e2 < 0;
        }
        if (oldValue instanceof Long || newValue instanceof Long) {
            boolean e3;
            boolean bl = e3 = ((Number)oldValue).longValue() <= ((Number)newValue).longValue();
            return e3;
        }
        if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal) {
            int e4 = ((BigDecimal)oldValue).compareTo((BigDecimal)newValue);
            return e4 < 0;
        }
        if (oldValue instanceof BigDecimal && newValue instanceof Integer) {
            boolean e5;
            boolean bl = e5 = ((BigDecimal)oldValue).longValue() > (long)((Integer)newValue).intValue();
            return !e5;
        }
        if (oldValue instanceof Integer && newValue instanceof BigDecimal) {
            boolean e6;
            boolean bl = e6 = ((BigDecimal)newValue).longValue() > (long)((Integer)oldValue).intValue();
            return e6;
        }
        if (oldValue instanceof Double || newValue instanceof Double) {
            int e7 = Double.compare(((Number)oldValue).doubleValue(), ((Number)newValue).doubleValue());
            return e7 < 0;
        }
        if (oldValue instanceof Float || newValue instanceof Float) {
            int e8 = Float.compare(((Number)oldValue).floatValue(), ((Number)newValue).floatValue());
            return e8 < 0;
        }
        if (oldValue instanceof BigDecimal || newValue instanceof BigDecimal) {
            int e9 = Double.compare(((Number)oldValue).doubleValue(), ((Number)newValue).doubleValue());
            return e9 < 0;
        }
        boolean bl = e = ((Number)oldValue).intValue() <= ((Number)newValue).intValue();
        return e;
    }

    public static Object max(Integer lastValueType, Object oldValue, Object newValue) {
        boolean e;
        if (newValue == null) {
            return oldValue;
        }
        if (oldValue == null) {
            return newValue;
        }
        if (lastValueType == 1) {
            Date newValueDate = (Date)newValue;
            Date oldValueDate = (Date)oldValue;
            if (newValueDate.after(oldValueDate)) {
                return newValue;
            }
            return oldValue;
        }
        if (oldValue instanceof Integer && newValue instanceof Integer) {
            int e2 = ((Integer)oldValue).compareTo((Integer)newValue);
            if (e2 < 0) {
                return newValue;
            }
            return oldValue;
        }
        if (oldValue instanceof Long || newValue instanceof Long) {
            boolean e3;
            boolean bl = e3 = ((Number)oldValue).longValue() <= ((Number)newValue).longValue();
            if (e3) {
                return newValue;
            }
            return oldValue;
        }
        if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal) {
            int e4 = ((BigDecimal)oldValue).compareTo((BigDecimal)newValue);
            if (e4 < 0) {
                return newValue;
            }
            return oldValue;
        }
        if (oldValue instanceof BigDecimal && newValue instanceof Integer) {
            boolean e5;
            boolean bl = e5 = ((BigDecimal)oldValue).longValue() > (long)((Integer)newValue).intValue();
            if (!e5) {
                return newValue;
            }
            return oldValue;
        }
        if (oldValue instanceof Integer && newValue instanceof BigDecimal) {
            boolean e6;
            boolean bl = e6 = ((BigDecimal)newValue).longValue() > (long)((Integer)oldValue).intValue();
            if (!e6) {
                return oldValue;
            }
            return newValue;
        }
        if (oldValue instanceof Double || newValue instanceof Double) {
            int e7 = Double.compare(((Number)oldValue).doubleValue(), ((Number)newValue).doubleValue());
            if (e7 < 0) {
                return newValue;
            }
            return oldValue;
        }
        if (oldValue instanceof Float || newValue instanceof Float) {
            int e8 = Float.compare(((Number)oldValue).floatValue(), ((Number)newValue).floatValue());
            if (e8 < 0) {
                return newValue;
            }
            return oldValue;
        }
        if (oldValue instanceof BigDecimal || newValue instanceof BigDecimal) {
            int e9 = Double.compare(((Number)oldValue).doubleValue(), ((Number)newValue).doubleValue());
            if (e9 < 0) {
                return newValue;
            }
            return oldValue;
        }
        boolean bl = e = ((Number)oldValue).intValue() <= ((Number)newValue).intValue();
        if (e) {
            return newValue;
        }
        return oldValue;
    }

    private void initStatusSQL(String statusDbname) {
        this.createStatusTableSQL = DBConfig.getCreateStatusTableSQL(SQLUtil.getPool((String)statusDbname).getDBType());
        this.createHistoryStatusTableSQL = DBConfig.getCreateHistoryStatusTableSQL(SQLUtil.getPool((String)statusDbname).getDBType());
        this.createStatusTableSQL = this.createStatusTableSQL.replace("$statusTableName", this.statusTableName);
        this.createHistoryStatusTableSQL = this.createHistoryStatusTableSQL.replace("$historyStatusTableName", this.historyStatusTableName);
    }

    private void addField(String field, String tableName, String defaultValue, String length, String type) {
        block3: {
            String addFiledSQL = defaultValue != null ? "ALTER TABLE " + tableName + " ADD " + field + " " + type + "(" + length + ") DEFAULT " + defaultValue : "ALTER TABLE " + tableName + " ADD " + field + " " + type + "(" + length + ") ";
            try {
                SQLExecutor.updateWithDBName((String)this.statusDbname, (String)addFiledSQL, (Object[])new Object[0]);
                if (logger.isInfoEnabled()) {
                    logger.info("add field to table success\uff1a" + addFiledSQL + ".");
                }
            }
            catch (Exception e1) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn("add field to table failed\uff1a" + addFiledSQL + ".", (Throwable)e1);
            }
        }
    }

    private void checkStatusFieldExist() {
        String defaultValue = DBConfig.getStatusTableDefaultValue(SQLUtil.getPool((String)this.statusDbname).getDBType());
        String type = DBConfig.getStatusTableType(SQLUtil.getPool((String)this.statusDbname).getDBType());
        try {
            SQLExecutor.queryObjectWithDBName(Status.class, (String)this.statusDbname, (String)this.checkFieldSQL, (Object[])new Object[0]);
        }
        catch (SQLException e) {
            logger.warn("filePath,status and fileId not exit in table {" + this.statusTableName + "}", (Throwable)e);
            this.addField("filePath", this.statusTableName, defaultValue, "500", type);
            this.addField("relativeParentDir", this.statusTableName, defaultValue, "500", type);
            this.addField("fileId", this.statusTableName, defaultValue, "500", type);
            this.addField("status", this.statusTableName, null, "1", DBConfig.getStatusTableTypeNumber(SQLUtil.getPool((String)this.statusDbname).getDBType()));
            this.addField("jobId", this.statusTableName, defaultValue, "500", type);
            this.addField("jobType", this.statusTableName, defaultValue, "500", type);
        }
    }

    @Override
    public void initLastValueType() {
        this.lastValueType = this.importContext.getLastValueType() != null ? this.importContext.getLastValueType() : 0;
        this.importContext.setLastValueType(this.lastValueType);
    }

    protected void initDatasource() {
        if (this.isIncreamentImport()) {
            if (this.importContext.getStatusDbConfig() == null) {
                this.statusDbname = "_status_datasource";
                String dbJNDIName = "_status_datasource_jndi";
                this.initSQLiteStatusDB(this.statusDbname, dbJNDIName);
            } else {
                DBConfig statusDBConfig = this.importContext.getStatusDbConfig();
                this.statusDbname = statusDBConfig.getDbName();
                if (statusDBConfig.getDbDriver() != null && !statusDBConfig.getDbDriver().trim().equals("")) {
                    if (this.statusDbname == null || this.statusDbname.trim().equals("")) {
                        this.statusDbname = "_status_datasource";
                    }
                    String dbJNDIName = this.statusDbname + "_jndi";
                    try {
                        DBConf tempConf = new DBConf();
                        tempConf.setPoolname(this.statusDbname);
                        tempConf.setDriver(statusDBConfig.getDbDriver());
                        tempConf.setJdbcurl(statusDBConfig.getDbUrl());
                        tempConf.setUsername(statusDBConfig.getDbUser());
                        tempConf.setPassword(statusDBConfig.getDbPassword());
                        tempConf.setReadOnly((String)null);
                        tempConf.setTxIsolationLevel((String)null);
                        tempConf.setValidationQuery(statusDBConfig.getValidateSQL());
                        tempConf.setJndiName(dbJNDIName);
                        tempConf.setInitialConnections(10);
                        tempConf.setMinimumSize(10);
                        tempConf.setMaximumSize(20);
                        tempConf.setUsepool(true);
                        tempConf.setExternal(false);
                        tempConf.setExternaljndiName((String)null);
                        tempConf.setShowsql(false);
                        tempConf.setEncryptdbinfo(false);
                        tempConf.setQueryfetchsize(null);
                        tempConf.setDbInfoEncryptClass(statusDBConfig.getDbInfoEncryptClass());
                        boolean ret = SQLUtil.startPoolWithDBConf((DBConf)tempConf);
                        if (!ret) {
                            logger.warn("Ignore start started Status_datasource[" + this.statusDbname + "].");
                            this.useOuterStatusDb = true;
                            this.initStatusSQL(this.statusDbname);
                        }
                    }
                    catch (Exception e) {
                        throw new DataImportException(e);
                    }
                    this.initStatusSQL(statusDBConfig);
                } else if (this.statusStorePath != null && !this.statusStorePath.equals("")) {
                    if (this.statusDbname == null || this.statusDbname.trim().equals("")) {
                        this.statusDbname = "_status_datasource";
                    }
                    String dbJNDIName = this.statusDbname + "_jndi";
                    this.initSQLiteStatusDB(this.statusDbname, dbJNDIName);
                } else {
                    this.useOuterStatusDb = true;
                    this.initStatusSQL(statusDBConfig);
                }
            }
            this.dataTranPlugin.getSetLastValueType().set();
            this.existSQL = "select 1 from " + this.statusTableName;
            this.existHisSQL = "select 1 from " + this.historyStatusTableName;
            this.selectSQL = "select id,lasttime,lastvalue,lastvaluetype,filePath,relativeParentDir,fileId,status,jobId,jobType from " + this.statusTableName + " where id=? and jobType=?";
            this.selectByJobIdSQL = "select id,lasttime,lastvalue,lastvaluetype,filePath,relativeParentDir,fileId,status,jobId,jobType from " + this.statusTableName + " where id=? and " + " jobId=? and jobType=?";
            this.checkFieldSQL = "select filePath,fileId,relativeParentDir,status,jobId,jobType from " + this.statusTableName;
            this.checkHisFieldSQL = "select filePath,fileId,relativeParentDir,status,statusId,jobId,jobType from " + this.historyStatusTableName;
            this.selectAllSQL = "select id,lasttime,lastvalue,lastvaluetype,filePath,relativeParentDir,fileId,status,jobId,jobType from " + this.statusTableName + " where jobType=?";
            this.selectAllByJobIdSQL = "select id,lasttime,lastvalue,lastvaluetype,filePath,relativeParentDir,fileId,status,jobId,jobType from " + this.statusTableName + " where jobId = ? and jobType=?";
            this.updateSQL = "update " + this.statusTableName + " set lasttime = ?,lastvalue = ? ,lastvaluetype= ? , filePath = ?,relativeParentDir = ?,fileId = ? ,status = ? where id=? and jobType=?";
            this.updateByJobIdSQL = "update " + this.statusTableName + " set lasttime = ?,lastvalue = ? ,lastvaluetype= ? , filePath = ?,relativeParentDir = ?,fileId = ? ,status = ? where id=? and " + " jobId=? and jobType=?";
            this.updateStatusSQL = "update " + this.statusTableName + " set status = ?, lasttime= ?" + " where id=? and jobType=?";
            this.updateByJobIdStatusSQL = "update " + this.statusTableName + " set status = ?, lasttime= ?" + " where id=? and " + " jobId=? and jobType=?";
            this.insertSQL = "insert into " + this.statusTableName + " (id,lasttime,lastvalue,lastvaluetype,filePath,relativeParentDir,fileId,status,jobId,jobType) values(?,?,?,?,?,?,?,?,?,?)";
            this.deleteSQL = "delete from " + this.statusTableName + " where id=? and jobType=?";
            this.deleteByJobIdSQL = "delete from " + this.statusTableName + " where id=? and " + " jobId=? and jobType=?";
            this.insertHistorySQL = "insert into " + this.statusTableName + " (id,lasttime,lastvalue,lastvaluetype,filePath,relativeParentDir,fileId,status,jobId,jobType) values(?,?,?,?,?,?,?,?,?,?)";
        }
    }

    private void createTable(String tableName, String sql) {
        try {
            SQLExecutor.updateWithDBName((String)this.statusDbname, (String)sql, (Object[])new Object[0]);
            if (logger.isInfoEnabled()) {
                logger.info("table " + tableName + " create success\uff1a" + sql + ".");
            }
        }
        catch (Exception e1) {
            if (logger.isInfoEnabled()) {
                logger.info("table " + tableName + " create failed\uff1a" + sql + ".", (Throwable)e1);
            }
            throw new DataImportException(e1);
        }
    }

    @Override
    public void initTableAndStatus(InitLastValueClumnName initLastValueClumnName) {
        initLastValueClumnName.initLastValueClumnName();
        this.initStatusStore();
        this.initDatasource();
        if (this.isIncreamentImport() && this.importContext.getStatusTableId() == null) {
            this.dataTranPlugin.initStatusTableId();
        }
        if (this.isIncreamentImport()) {
            SimpleDateFormat dateFormat;
            try {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.initLastDate = dateFormat.parse("1970-01-01 00:00:00");
                SQLExecutor.queryObjectWithDBName(Integer.TYPE, (String)this.statusDbname, (String)this.existSQL, (Object[])new Object[0]);
                this.checkStatusFieldExist();
            }
            catch (Exception e) {
                if (logger.isInfoEnabled()) {
                    logger.info("{} table not exist\uff0c{}\uff1a{}.", new Object[]{this.statusTableName, this.statusTableName, this.createStatusTableSQL});
                }
                this.createTable(this.statusTableName, this.createStatusTableSQL);
            }
            try {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.initLastDate = dateFormat.parse("1970-01-01 00:00:00");
                SQLExecutor.queryObjectWithDBName(Integer.TYPE, (String)this.statusDbname, (String)this.existHisSQL, (Object[])new Object[0]);
                this.checkHisStatusFieldExist();
            }
            catch (Exception e) {
                if (logger.isInfoEnabled()) {
                    logger.info("{} table not exist\uff0c{}\uff1a{}.", new Object[]{this.historyStatusTableName, this.statusTableName, this.createHistoryStatusTableSQL});
                }
                this.createTable(this.historyStatusTableName, this.createHistoryStatusTableSQL);
            }
            this.init();
            this.dataTranPlugin.getLoadCurrentStatus().load();
        } else {
            try {
                Status currentStatus = new Status();
                currentStatus.setId(this.importContext.getStatusTableId());
                currentStatus.setTime(new Date().getTime());
                currentStatus.setJobId(this.importContext.getJobId());
                this.firstStatus = (Status)currentStatus.clone();
                this.currentStatus = currentStatus;
            }
            catch (Exception e) {
                throw new DataImportException(e);
            }
        }
    }

    protected void initStatusStore() {
        if (this.isIncreamentImport()) {
            this.statusTableName = this.importContext.getLastValueStoreTableName();
            if (this.statusTableName == null) {
                this.statusTableName = "increament_tab";
            }
            if (this.importContext.getLastValueStorePath() == null || this.importContext.getLastValueStorePath().equals("")) {
                DBConfig statusDBConfig = this.importContext.getStatusDbConfig();
                if (statusDBConfig == null) {
                    this.statusStorePath = "StatusStoreDB";
                }
            } else {
                this.statusStorePath = this.importContext.getLastValueStorePath();
            }
            this.historyStatusTableName = this.statusTableName + "_his";
        }
    }

    private void initSQLiteStatusDB(String statusDbname, String dbJNDIName) {
        try {
            this.createStatusTableSQL = "create table " + this.statusTableName + " (ID varchar(100)," + "lasttime number(20)," + "lastvalue number(20)," + "lastvaluetype number(1)," + "status number(1) ," + "filePath varchar(500) ," + "relativeParentDir varchar(500) ," + "fileId varchar(500) ," + "jobId varchar(500) ," + "jobType varchar(500) ," + "PRIMARY KEY (ID))";
            this.createHistoryStatusTableSQL = "create table " + this.historyStatusTableName + " (ID varchar(100)," + "lasttime number(20)," + "lastvalue number(20)," + "lastvaluetype number(1)," + "status number(1) ," + "filePath varchar(500) ," + "relativeParentDir varchar(500) ," + "fileId varchar(500) ," + "jobId varchar(500) ," + "jobType varchar(500) ," + "statusId number(10)) ";
            File dbpath = new File(this.statusStorePath);
            logger.info("initDatasource dbpath:" + dbpath.getCanonicalPath());
            DBConf tempConf = new DBConf();
            tempConf.setPoolname(statusDbname);
            tempConf.setDriver("org.sqlite.JDBC");
            tempConf.setJdbcurl("jdbc:sqlite://" + dbpath.getCanonicalPath());
            tempConf.setUsername("root");
            tempConf.setPassword("root");
            tempConf.setReadOnly((String)null);
            tempConf.setTxIsolationLevel((String)null);
            tempConf.setValidationQuery("select 1");
            tempConf.setJndiName(dbJNDIName);
            tempConf.setInitialConnections(1);
            tempConf.setMinimumSize(1);
            tempConf.setMaximumSize(1);
            tempConf.setUsepool(true);
            tempConf.setExternal(false);
            tempConf.setExternaljndiName((String)null);
            tempConf.setShowsql(false);
            tempConf.setEncryptdbinfo(false);
            tempConf.setQueryfetchsize(null);
            boolean ret = SQLUtil.startPoolWithDBConf((DBConf)tempConf);
            if (!ret) {
                logger.warn("Ignore start started Status_datasource[" + statusDbname + "].");
                this.useOuterStatusDb = true;
                this.initStatusSQL(statusDbname);
            } else {
                logger.warn("Start Status_datasource[" + statusDbname + "] complete.");
            }
        }
        catch (Exception e) {
            throw new DataImportException(e);
        }
    }

    private void initStatusSQL(DBConfig statusDBConfig) {
        this.createStatusTableSQL = statusDBConfig.getStatusTableDML();
        if (this.createStatusTableSQL == null) {
            this.createStatusTableSQL = DBConfig.getCreateStatusTableSQL(SQLUtil.getPool((String)this.statusDbname).getDBType());
        }
        this.createHistoryStatusTableSQL = DBConfig.getCreateHistoryStatusTableSQL(SQLUtil.getPool((String)this.statusDbname).getDBType());
        this.createStatusTableSQL = this.createStatusTableSQL.replace("$statusTableName", this.statusTableName);
        this.createHistoryStatusTableSQL = this.createHistoryStatusTableSQL.replace("$historyStatusTableName", this.historyStatusTableName);
    }

    private void checkHisStatusFieldExist() {
        String defaultValue = DBConfig.getStatusTableDefaultValue(SQLUtil.getPool((String)this.statusDbname).getDBType());
        String type = DBConfig.getStatusTableType(SQLUtil.getPool((String)this.statusDbname).getDBType());
        try {
            SQLExecutor.queryObjectWithDBName(Status.class, (String)this.statusDbname, (String)this.checkHisFieldSQL, (Object[])new Object[0]);
        }
        catch (SQLException e) {
            logger.warn("filePath,status,statusId and fileId not exit in table {" + this.historyStatusTableName + "}", (Throwable)e);
            this.addField("filePath", this.historyStatusTableName, defaultValue, "500", type);
            this.addField("relativeParentDir", this.historyStatusTableName, defaultValue, "500", type);
            this.addField("fileId", this.historyStatusTableName, defaultValue, "500", type);
            this.addField("jobId", this.historyStatusTableName, defaultValue, "500", type);
            this.addField("jobType", this.historyStatusTableName, defaultValue, "500", type);
            this.addField("status", this.historyStatusTableName, null, "1", DBConfig.getStatusTableTypeNumber(SQLUtil.getPool((String)this.statusDbname).getDBType()));
            this.addField("statusId", this.historyStatusTableName, null, "10", DBConfig.getStatusTableTypeBigNumber(SQLUtil.getPool((String)this.statusDbname).getDBType()));
        }
    }

    @Override
    public void initLastValueClumnName() {
        if (this.lastValueClumnName != null) {
            return;
        }
        if (this.importContext.getLastValueColumn() != null) {
            this.lastValueClumnName = this.importContext.getLastValueColumn();
        } else if (this.dataTranPlugin.getLastValueVarName() != null) {
            this.lastValueClumnName = this.dataTranPlugin.getLastValueVarName();
        }
        if (this.lastValueClumnName == null) {
            this.setIncreamentImport(false);
        }
    }

    @Override
    public void handleOldedTasks(List<Status> olded) {
        for (Status status : olded) {
            this.handleOldedTask(status);
        }
    }

    @Override
    public void handleOldedTask(Status olded) {
        try {
            olded.setTime(System.currentTimeMillis());
            olded.setStatus(1);
            if (olded.getJobId() == null) {
                SQLExecutor.updateWithDBName((String)this.statusDbname, (String)this.updateStatusSQL, (Object[])new Object[]{olded.getStatus(), olded.getTime(), olded.getId()});
            } else {
                SQLExecutor.updateWithDBName((String)this.statusDbname, (String)this.updateByJobIdStatusSQL, (Object[])new Object[]{olded.getStatus(), olded.getTime(), olded.getId(), olded.getJobId()});
            }
        }
        catch (Exception e) {
            logger.error("handleCompletedTasks failed:" + SimpleStringUtil.object2json((Object)olded), (Throwable)e);
        }
    }

    @Override
    public void addStatus(Status currentStatus) throws DataImportException {
        Object lastValue = currentStatus.getLastValue();
        if (logger.isInfoEnabled()) {
            logger.info("AddStatus: \u589e\u91cf\u5b57\u6bb5\u503c LastValue is Date Type:{},real data type is {},real last value is {}", new Object[]{this.importContext.isLastValueDateType(), lastValue.getClass().getName(), lastValue});
        }
        if (this.importContext.isLastValueDateType()) {
            if (lastValue instanceof Date) {
                lastValue = ((Date)lastValue).getTime();
            } else {
                throw new DataImportException("AddStatus: \u589e\u91cf\u5b57\u6bb5\u4e3a\u65e5\u671f\u7c7b\u578b\uff0cBut the LastValue is not a Date value:" + lastValue + ",value type is " + lastValue.getClass().getName());
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("AddStatus: \u589e\u91cf\u5b57\u6bb5\u503c LastValue is Date Type:{},real data type is {},and real last value to sqlite is {}", new Object[]{this.importContext.isLastValueDateType(), lastValue.getClass().getName(), lastValue});
        }
        try {
            SQLExecutor.insertWithDBName((String)this.statusDbname, (String)this.insertSQL, (Object[])new Object[]{currentStatus.getId(), currentStatus.getTime(), lastValue, this.lastValueType, currentStatus.getFilePath(), currentStatus.getRelativeParentDir(), currentStatus.getFileId(), currentStatus.getStatus(), currentStatus.getJobId(), currentStatus.getJobType()});
        }
        catch (SQLException throwables) {
            throw new DataImportException("Add Status failed:" + currentStatus.toString(), throwables);
        }
    }

    @Override
    public void updateStatus(Status currentStatus) throws Exception {
        Object lastValue = currentStatus.getLastValue();
        if (logger.isDebugEnabled()) {
            logger.debug("UpdateStatus\uff1a\u589e\u91cf\u5b57\u6bb5\u503c LastValue is Date Type:{},real data type is {},real last value is {}", new Object[]{this.importContext.isLastValueDateType(), lastValue.getClass().getName(), lastValue});
        }
        if (this.importContext.isLastValueDateType()) {
            if (lastValue instanceof Date) {
                lastValue = ((Date)lastValue).getTime();
            } else {
                throw new DataImportException("UpdateStatus\uff1a\u589e\u91cf\u5b57\u6bb5\u4e3a\u65e5\u671f\u7c7b\u578b\uff0cBut the LastValue is not a Date value:" + lastValue + ",value type is " + lastValue.getClass().getName());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("UpdateStatus\uff1a\u589e\u91cf\u5b57\u6bb5\u503c LastValue is Date Type:{},real data type is {},and real last value to sqlite is {}", new Object[]{this.importContext.isLastValueDateType(), lastValue.getClass().getName(), lastValue});
        }
        if (!this.isStoped()) {
            this.putStatus(currentStatus);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initLastValueStatus(boolean update) throws Exception {
        Status currentStatus;
        block11: {
            block12: {
                block13: {
                    Object configLastValue;
                    block15: {
                        block14: {
                            currentStatus = new Status();
                            currentStatus.setId(this.importContext.getStatusTableId());
                            currentStatus.setTime(new Date().getTime());
                            if (this.lastValueType != 1) break block12;
                            configLastValue = this.importContext.getConfigLastValue();
                            if (configLastValue == null) break block13;
                            if (!(configLastValue instanceof Date)) break block14;
                            currentStatus.setLastValue(configLastValue);
                            break block11;
                        }
                        if (!(configLastValue instanceof Long)) break block15;
                        currentStatus.setLastValue(new Date((Long)configLastValue));
                        break block11;
                    }
                    if (configLastValue instanceof BigDecimal) {
                        currentStatus.setLastValue(new Date(((BigDecimal)configLastValue).longValue()));
                        break block11;
                    } else if (configLastValue instanceof Integer) {
                        currentStatus.setLastValue(new Date(((Integer)configLastValue).intValue()));
                        break block11;
                    } else {
                        if (logger.isInfoEnabled()) {
                            logger.info("TIMESTAMP TYPE Last Value Illegal:{}", configLastValue);
                        }
                        throw new DataImportException("TIMESTAMP TYPE Last Value Illegal:" + configLastValue);
                    }
                }
                currentStatus.setLastValue(this.initLastDate);
                break block11;
            }
            if (this.importContext.getConfigLastValue() != null) {
                currentStatus.setLastValue(this.importContext.getConfigLastValue());
            } else {
                currentStatus.setLastValue(0L);
            }
        }
        if (this.importContext.getJobId() != null) {
            currentStatus.setJobId(this.importContext.getJobId());
        }
        currentStatus.setJobType(this.importContext.getJobType());
        currentStatus.setLastValueType(this.lastValueType);
        if (!update) {
            this.addStatus(currentStatus);
        } else {
            this.updateStatus(currentStatus);
        }
        this.currentStatus = currentStatus;
        this.firstStatus = (Status)currentStatus.clone();
        if (logger.isInfoEnabled()) {
            logger.info("Init LastValue Status: {}", (Object)currentStatus.toString());
        }
    }

    @Override
    public void handleLostedTasks(List<Status> losteds, boolean needSyn) {
        try {
            for (Status losted : losteds) {
                this.putStatus(losted);
            }
        }
        catch (Exception e) {
            logger.error("handleCompletedTasks failed:" + SimpleStringUtil.object2json(losteds), (Throwable)e);
        }
    }

    @Override
    public void handleCompletedTasks(List<Status> completed, boolean needSyn, long registLiveTime) {
        try {
            long now = System.currentTimeMillis();
            long deletedTime = now - registLiveTime;
            for (Status status : completed) {
                long lastTime;
                File file = new File(status.getFilePath());
                if (file.exists() || (lastTime = status.getTime()) > deletedTime) continue;
                SQLExecutor.insertWithDBName((String)this.statusDbname, (String)this.insertHistorySQL, (Object[])new Object[]{SimpleStringUtil.getUUID(), status.getTime(), status.getLastValue(), status.getLastValueType(), status.getFilePath(), status.getRelativeParentDir(), status.getFileId(), status.getStatus(), status.getJobId(), status.getJobType()});
                if (status.getJobId() == null) {
                    SQLExecutor.deleteWithDBName((String)this.statusDbname, (String)this.deleteSQL, (Object[])new Object[]{status.getId(), status.getJobType()});
                    continue;
                }
                SQLExecutor.deleteWithDBName((String)this.statusDbname, (String)this.deleteByJobIdSQL, (Object[])new Object[]{status.getId(), status.getJobId(), status.getJobType()});
            }
        }
        catch (Exception e) {
            logger.error("handleCompletedTasks failed:" + SimpleStringUtil.object2json(completed), (Throwable)e);
        }
    }

    @Override
    public List<Status> getPluginStatuses() {
        try {
            if (this.importContext.getJobId() == null) {
                List statuses = SQLExecutor.queryListWithDBName(Status.class, (String)this.statusDbname, (String)this.selectAllSQL, (Object[])new Object[]{this.importContext.getJobType()});
                return statuses;
            }
            List statuses = SQLExecutor.queryListWithDBName(Status.class, (String)this.statusDbname, (String)this.selectAllByJobIdSQL, (Object[])new Object[]{this.importContext.getJobId(), this.importContext.getJobType()});
            return statuses;
        }
        catch (SQLException throwables) {
            throw new DataImportException(throwables);
        }
    }

    @Override
    public LoadCurrentStatus getLoadCurrentStatus() {
        return new LoadCurrentStatus(){

            @Override
            public void load() {
                BaseStatusManager.this.loadCurrentStatus();
            }
        };
    }

    @Override
    public Status getStatus(String jobId, String jobType, String statusId) {
        try {
            Status status = jobId == null ? (Status)SQLExecutor.queryObjectWithDBName(Status.class, (String)this.statusDbname, (String)this.selectSQL, (Object[])new Object[]{statusId, jobType}) : (Status)SQLExecutor.queryObjectWithDBName(Status.class, (String)this.statusDbname, (String)this.selectByJobIdSQL, (Object[])new Object[]{statusId, jobId, jobType});
            return status;
        }
        catch (Exception e) {
            throw new DataImportException(e);
        }
    }

    protected void loadCurrentStatus() {
        try {
            this.currentStatus = this.getStatus(this.importContext.getJobId(), this.importContext.getJobType(), this.importContext.getStatusTableId());
            if (this.currentStatus == null) {
                this.initLastValueStatus(false);
            } else if (this.importContext.isFromFirst()) {
                this.initLastValueStatus(true);
            } else if (this.currentStatus.getLastValueType() != this.lastValueType) {
                if (logger.isWarnEnabled()) {
                    logger.warn("The config lastValueType is {} but from currentStatus lastValueType is {},and use the config lastValueType to releace currentStatus lastValueType.", (Object)this.lastValueType, (Object)this.currentStatus.getLastValueType());
                }
                this.initLastValueStatus(true);
            } else {
                if (this.currentStatus.getLastValueType() == 1) {
                    Object lastValue = this.currentStatus.getLastValue();
                    if (lastValue instanceof Long) {
                        this.currentStatus.setLastValue(new Date((Long)lastValue));
                    } else if (lastValue instanceof BigDecimal) {
                        this.currentStatus.setLastValue(new Date(((BigDecimal)lastValue).longValue()));
                    } else if (lastValue instanceof Integer) {
                        this.currentStatus.setLastValue(new Date(((Integer)lastValue).longValue()));
                    } else {
                        if (logger.isWarnEnabled()) {
                            logger.warn("initTableAndStatus\uff1a\u589e\u91cf\u5b57\u6bb5\u7c7b\u578b\u4e3a\u65e5\u671f\u7c7b\u578b, But the LastValue from status table is not a long value:{},value type is {}", lastValue, (Object)lastValue.getClass().getName());
                        }
                        throw new DataImportException("InitTableAndStatus\uff1a\u589e\u91cf\u5b57\u6bb5\u7c7b\u578b\u4e3a\u65e5\u671f\u7c7b\u578b, But the LastValue from status table is not a long value:" + lastValue + ",value type is " + lastValue.getClass().getName());
                    }
                }
                this.firstStatus = (Status)this.currentStatus.clone();
            }
        }
        catch (DataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataImportException(e);
        }
    }

    @Override
    public Status getCurrentStatus() {
        return this.currentStatus;
    }

    @Override
    public void setIncreamentImport(boolean increamentImport) {
        this.increamentImport = increamentImport;
    }

    @Override
    public boolean isIncreamentImport() {
        return this.increamentImport;
    }

    @Override
    public String getLastValueClumnName() {
        return this.lastValueClumnName;
    }

    @Override
    public Object[] putLastParamValue(Map params) {
        Object[] ret = new Object[2];
        Object lastValue = this.currentStatus.getLastValue();
        if (this.lastValueType == 0) {
            params.put(this.dataTranPlugin.getLastValueVarName(), lastValue);
        } else {
            Date ldate = null;
            ldate = lastValue instanceof Date ? (Date)lastValue : (lastValue instanceof Long ? new Date((Long)lastValue) : (lastValue instanceof BigDecimal ? new Date(((BigDecimal)lastValue).longValue()) : (lastValue instanceof Integer ? new Date(((Integer)lastValue).longValue()) : (lastValue instanceof Short ? new Date(((Short)lastValue).longValue()) : new Date(((Number)lastValue).longValue())))));
            params.put(this.dataTranPlugin.getLastValueVarName(), this.formatLastDateValue(ldate));
            if (this.importContext.increamentEndOffset() != null) {
                Date lastOffsetValue = TimeUtil.addDateSeconds((Date)new Date(), (int)(0 - this.importContext.increamentEndOffset()));
                ret[1] = lastOffsetValue;
                params.put(this.dataTranPlugin.getLastValueVarName() + "__endTime", this.formatLastDateValue(lastOffsetValue));
            }
        }
        if (this.isPrintTaskLog()) {
            logger.info("Current values: " + params);
        }
        ret[0] = lastValue;
        return ret;
    }

    protected boolean isPrintTaskLog() {
        return this.importContext.isPrintTaskLog() && logger.isInfoEnabled();
    }

    protected Object formatLastDateValue(Date date) {
        return date;
    }

    @Override
    public void stopStatusDatasource() {
        try {
            if (this.statusDbname != null && !this.statusDbname.equals("") && !this.useOuterStatusDb) {
                SQLUtil.stopPool((String)this.statusDbname);
            }
        }
        catch (Exception e) {
            logger.error("Stop status db pool[" + this.statusDbname + "] failed:", (Throwable)e);
        }
    }

    @Override
    public Map getParamValue(Map params) {
        Object lastValue = this.currentStatus.getLastValue();
        if (this.lastValueType == 0) {
            params.put(this.dataTranPlugin.getLastValueVarName(), lastValue);
        } else {
            if (lastValue instanceof Date) {
                params.put(this.dataTranPlugin.getLastValueVarName(), lastValue);
            } else if (lastValue instanceof Long) {
                params.put(this.dataTranPlugin.getLastValueVarName(), new Date((Long)lastValue));
            } else if (lastValue instanceof BigDecimal) {
                params.put(this.dataTranPlugin.getLastValueVarName(), new Date(((BigDecimal)lastValue).longValue()));
            } else if (lastValue instanceof Integer) {
                params.put(this.dataTranPlugin.getLastValueVarName(), new Date(((Integer)lastValue).longValue()));
            } else if (lastValue instanceof Short) {
                params.put(this.dataTranPlugin.getLastValueVarName(), new Date(((Short)lastValue).longValue()));
            } else {
                params.put(this.dataTranPlugin.getLastValueVarName(), new Date(((Number)lastValue).longValue()));
            }
            if (this.importContext.increamentEndOffset() != null) {
                Date lastOffsetValue = TimeUtil.addDateSeconds((Date)new Date(), (int)(0 - this.importContext.increamentEndOffset()));
                params.put(this.dataTranPlugin.getLastValueVarName() + "__endTime", lastOffsetValue);
            }
        }
        if (this.isPrintTaskLog()) {
            logger.info("Current values: " + params);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushLastValue(Object lastValue, Status currentStatus, boolean reachEOFClosed) {
        if (lastValue != null) {
            Status status = currentStatus;
            synchronized (status) {
                Object oldLastValue = currentStatus.getLastValue();
                if (!reachEOFClosed && !this.importContext.needUpdate(oldLastValue, lastValue)) {
                    return;
                }
                long time = System.currentTimeMillis();
                currentStatus.setTime(time);
                currentStatus.setLastValue(lastValue);
                if (reachEOFClosed) {
                    currentStatus.setStatus(1);
                }
                if (this.isIncreamentImport()) {
                    Status status2 = currentStatus.copy();
                    this.storeStatus(status2);
                }
            }
        }
    }

    @Override
    public void flushLastValue(Object lastValue, Status currentStatus) {
        this.flushLastValue(lastValue, currentStatus, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceflushLastValue(Status currentStatus) {
        Status status = currentStatus;
        synchronized (status) {
            currentStatus.setStatus(1);
            currentStatus.setTime(System.currentTimeMillis());
            this.storeStatus(currentStatus);
        }
    }

    public void storeStatus(Status currentStatus) {
        try {
            this.updateStatus(currentStatus);
        }
        catch (DataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataImportException(e);
        }
    }

    @Override
    public int getLastValueType() {
        return this.lastValueType;
    }
}

