/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.schedule;

import com.frameworkset.util.UUID;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.context.JobContext;
import org.frameworkset.tran.metrics.JobTaskMetrics;
import org.frameworkset.tran.metrics.TaskMetrics;
import org.frameworkset.tran.plugin.db.TranSQLInfo;
import org.frameworkset.tran.plugin.db.output.DBOutputConfig;
import org.frameworkset.tran.schedule.JobExecuteMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskContext {
    private static Logger logger = LoggerFactory.getLogger(TaskContext.class);
    private Map<String, Object> taskDatas;
    private JobTaskMetrics jobTaskMetrics;
    private DBOutputConfig dbmportConfig;
    private TranSQLInfo targetSqlInfo;
    private TranSQLInfo targetUpdateSqlInfo;
    private TranSQLInfo targetDeleteSqlInfo;
    private ImportContext importContext;

    public DBOutputConfig getDbmportConfig() {
        return this.dbmportConfig;
    }

    public void setDbmportConfig(DBOutputConfig dbmportConfig) {
        this.dbmportConfig = dbmportConfig;
    }

    public TaskContext() {
    }

    public void initContext() {
        this.taskDatas = new HashMap<String, Object>();
        this.jobTaskMetrics = this.importContext.createJobTaskMetrics();
        this.jobTaskMetrics.setJobNo(UUID.randomUUID().toString());
        this.jobTaskMetrics.setJobStartTime(new Date());
        this.jobTaskMetrics.setJobId(this.importContext.getJobId());
        this.jobTaskMetrics.setJobName(this.importContext.getJobName());
    }

    public TaskContext(ImportContext importContext) {
        this.importContext = importContext;
        this.initContext();
    }

    public void await() {
        this.jobTaskMetrics.await();
    }

    public void await(long waitTime) {
        this.jobTaskMetrics.await(waitTime);
    }

    public TaskContext addTaskData(String name, Object value) {
        this.taskDatas.put(name, value);
        return this;
    }

    public synchronized void taskExecuteMetric(JobExecuteMetric jobExecuteMetric) {
        try {
            jobExecuteMetric.executeMetric(this.jobTaskMetrics);
        }
        catch (Exception e) {
            logger.debug("taskExecuteMetric failed:", (Throwable)e);
        }
        catch (Throwable throwable) {
            logger.debug("taskExecuteMetric failed:", throwable);
        }
    }

    public synchronized Object readJobExecutorData(String name) {
        try {
            return this.jobTaskMetrics.readJobExecutorData(name);
        }
        catch (Exception e) {
            logger.debug("readJobExecutorData failed:", (Throwable)e);
        }
        catch (Throwable throwable) {
            logger.debug("readJobExecutorData failed:", throwable);
        }
        return null;
    }

    public synchronized TaskContext addTaskDatas(Map<String, Object> taskDatas) {
        this.taskDatas.putAll(taskDatas);
        return this;
    }

    public synchronized Object getTaskData(String name) {
        return this.taskDatas.get(name);
    }

    public JobContext getJobContext() {
        if (this.importContext != null) {
            return this.importContext.getJobContext();
        }
        return null;
    }

    public ImportContext getImportContext() {
        return this.importContext;
    }

    public synchronized void release() {
        this.taskDatas.clear();
        this.taskDatas = null;
    }

    public String getSql() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getSql();
        }
        return null;
    }

    public String getSqlFilepath() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getSqlFilepath();
        }
        return null;
    }

    public String getSqlName() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getSqlName();
        }
        return null;
    }

    public String getInsertSqlName() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getInsertSqlName();
        }
        return null;
    }

    public String getInsertSql() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getInsertSql();
        }
        return null;
    }

    public String getDeleteSqlName() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getDeleteSqlName();
        }
        return null;
    }

    public String getDeleteSql() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getDeleteSql();
        }
        return null;
    }

    public String getUpdateSqlName() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getUpdateSqlName();
        }
        return null;
    }

    public String getUpdateSql() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getUpdateSql();
        }
        return null;
    }

    public TranSQLInfo getTargetSqlInfo() {
        return this.targetSqlInfo;
    }

    public void setTargetSqlInfo(TranSQLInfo targetSqlInfo) {
        this.targetSqlInfo = targetSqlInfo;
    }

    public TranSQLInfo getTargetUpdateSqlInfo() {
        return this.targetUpdateSqlInfo;
    }

    public void setTargetUpdateSqlInfo(TranSQLInfo sqlInfo) {
        this.targetUpdateSqlInfo = sqlInfo;
    }

    public TranSQLInfo getTargetDeleteSqlInfo() {
        return this.targetDeleteSqlInfo;
    }

    public void setTargetDeleteSqlInfo(TranSQLInfo sqlInfo) {
        this.targetDeleteSqlInfo = sqlInfo;
    }

    public DBConfig getTargetDBConfig() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getTargetDBConfig();
        }
        return null;
    }

    public synchronized void beginTask(TaskMetrics taskMetrics) {
        this.jobTaskMetrics.increamentTasks();
    }

    public synchronized void finishTaskMetrics(TaskMetrics taskMetrics) {
        this.jobTaskMetrics.increamentFailedRecords(taskMetrics.getFailedRecords());
        this.jobTaskMetrics.increamentIgnoreRecords(taskMetrics.getIgnoreRecords());
        this.jobTaskMetrics.increamentRecords(taskMetrics.getRecords());
        this.jobTaskMetrics.increamentSuccessRecords(taskMetrics.getSuccessRecords());
        this.jobTaskMetrics.putLastValue(this.importContext.getLastValueType(), taskMetrics.getLastValue());
    }

    public synchronized void setJobEndTime(Date jobEndTime) {
        this.jobTaskMetrics.setJobEndTime(jobEndTime);
    }

    public synchronized JobTaskMetrics getJobTaskMetrics() {
        return this.jobTaskMetrics;
    }

    public synchronized Date getJobStartTime() {
        return this.jobTaskMetrics.getJobStartTime();
    }

    public synchronized String getJobNo() {
        return this.jobTaskMetrics.getJobNo();
    }

    protected TaskContext createTaskContext() {
        return new TaskContext();
    }

    public synchronized TaskContext copy() {
        TaskContext taskContext = this.createTaskContext();
        taskContext.importContext = this.importContext;
        taskContext.dbmportConfig = this.dbmportConfig;
        taskContext.targetSqlInfo = this.targetSqlInfo;
        taskContext.targetUpdateSqlInfo = this.targetUpdateSqlInfo;
        taskContext.targetDeleteSqlInfo = this.targetDeleteSqlInfo;
        taskContext.taskDatas = this.taskDatas;
        taskContext.jobTaskMetrics = this.jobTaskMetrics;
        return taskContext;
    }

    public synchronized int increamentErrorTasks() {
        return this.getJobTaskMetrics().increamentErrorTasks();
    }

    public synchronized int increamentExceptionTasks() {
        return this.getJobTaskMetrics().increamentExceptionTasks();
    }
}

