/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.http.output;

import com.frameworkset.util.SimpleStringUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.frameworkset.elasticsearch.template.BaseTemplateContainerImpl;
import org.frameworkset.elasticsearch.template.BaseTemplateMeta;
import org.frameworkset.elasticsearch.template.DSLParserException;
import org.frameworkset.elasticsearch.template.TemplateMeta;
import org.frameworkset.spi.remote.http.HttpRequestProxy;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.JobCountDownLatch;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.BasePlugin;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.plugin.http.HttpConfigClientProxy;
import org.frameworkset.tran.plugin.http.HttpProxyHelper;
import org.frameworkset.tran.plugin.http.output.HttpOutPutDataTran;
import org.frameworkset.tran.plugin.http.output.HttpOutputConfig;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.util.ResourceStartResult;

public class HttpOutputDataTranPlugin
extends BasePlugin
implements OutputPlugin {
    protected HttpOutputConfig httpOutputConfig;
    private ResourceStartResult resourceStartResult;
    private HttpConfigClientProxy httpConfigClientProxy;

    public HttpOutputDataTranPlugin(ImportContext importContext) {
        super(importContext);
        this.httpOutputConfig = (HttpOutputConfig)importContext.getOutputConfig();
    }

    public HttpOutputConfig getHttpOutputConfig() {
        return this.httpOutputConfig;
    }

    public HttpConfigClientProxy getHttpConfigClientProxy() {
        return this.httpConfigClientProxy;
    }

    @Override
    public void afterInit() {
        if (!this.httpOutputConfig.isDirectSendData()) {
            this.httpConfigClientProxy = SimpleStringUtil.isNotEmpty((String)this.httpOutputConfig.getDataDsl()) ? HttpProxyHelper.getHttpConfigClientProxy(new BaseTemplateContainerImpl(this.httpOutputConfig.getDslNamespace()){

                protected Map<String, TemplateMeta> loadTemplateMetas(String namespace) {
                    try {
                        BaseTemplateMeta baseTemplateMeta = new BaseTemplateMeta();
                        baseTemplateMeta.setName(HttpOutputDataTranPlugin.this.httpOutputConfig.getDataDslName());
                        baseTemplateMeta.setNamespace(namespace);
                        baseTemplateMeta.setDslTemplate(HttpOutputDataTranPlugin.this.httpOutputConfig.getDataDsl());
                        baseTemplateMeta.setMultiparser(Boolean.valueOf(true));
                        LinkedHashMap<String, TemplateMeta> templateMetaMap = new LinkedHashMap<String, TemplateMeta>();
                        templateMetaMap.put(baseTemplateMeta.getName(), (TemplateMeta)baseTemplateMeta);
                        return templateMetaMap;
                    }
                    catch (Exception e) {
                        throw new DSLParserException((Throwable)e);
                    }
                }

                protected long getLastModifyTime(String namespace) {
                    return -1L;
                }
            }) : HttpProxyHelper.getHttpConfigClientProxy(this.httpOutputConfig.getDslFile());
        }
    }

    @Override
    public void beforeInit() {
    }

    @Override
    public void init() {
        if (this.httpOutputConfig != null && this.httpOutputConfig.getHttpConfigs() != null) {
            this.resourceStartResult = HttpRequestProxy.startHttpPools(this.httpOutputConfig.getHttpConfigs());
        }
    }

    @Override
    public void destroy(boolean waitTranStop) {
        if (this.resourceStartResult != null) {
            HttpRequestProxy.stopHttpClients((ResourceStartResult)this.resourceStartResult);
        }
    }

    @Override
    public BaseDataTran createBaseDataTran(TaskContext taskContext, TranResultSet tranResultSet, JobCountDownLatch countDownLatch, Status currentStatus) {
        HttpOutPutDataTran db2ESDataTran = new HttpOutPutDataTran(taskContext, tranResultSet, this.importContext, countDownLatch, currentStatus);
        db2ESDataTran.initTran();
        return db2ESDataTran;
    }
}

