/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.http.input;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DefaultTranMetaData;
import org.frameworkset.tran.LastValue;
import org.frameworkset.tran.Record;
import org.frameworkset.tran.TranMeta;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.http.HttpResult;
import org.frameworkset.tran.plugin.http.input.HttpInputConfig;
import org.frameworkset.tran.plugin.http.input.HttpInputDataTranPlugin;
import org.frameworkset.tran.plugin.http.input.HttpRecord;
import org.frameworkset.tran.schedule.TaskContext;

public class HttpTranResultset
extends LastValue
implements TranResultSet {
    private HttpResult<Map> httpResult;
    private Map current;
    private Iterator<Map> iterator;
    private boolean stoped;
    private HttpInputConfig httpInputConfig;
    private HttpInputDataTranPlugin.QueryAction queryAction;

    public HttpTranResultset(HttpInputDataTranPlugin.QueryAction queryAction, ImportContext importContext) {
        this.importContext = importContext;
        this.httpInputConfig = (HttpInputConfig)importContext.getInputConfig();
        this.queryAction = queryAction;
    }

    public void init() {
        HttpResult<Map> httpResult = this.queryAction.execute();
        this.httpResult = httpResult;
        List<Map> datas = httpResult.getDatas();
        if (datas != null && datas.size() > 0) {
            this.iterator = datas.iterator();
        }
    }

    @Override
    public TaskContext getRecordTaskContext() {
        return this.record.getTaskContext();
    }

    @Override
    public Object getValue(int i, String colName, int sqlType) throws DataImportException {
        return this.getValue(colName);
    }

    @Override
    public Object getValue(String colName) throws DataImportException {
        return this.record.getValue(colName);
    }

    @Override
    public Object getValue(String colName, int sqlType) throws DataImportException {
        return this.getValue(colName);
    }

    @Override
    public Date getDateTimeValue(String colName) throws DataImportException {
        return this.record.getDateTimeValue(colName);
    }

    @Override
    public Boolean next() throws DataImportException {
        if (this.stoped || this.iterator == null || this.importContext.getInputPlugin().isStopCollectData()) {
            return false;
        }
        boolean hasNext = this.iterator.hasNext();
        if (hasNext) {
            this.current = this.iterator.next();
            this.record = new HttpRecord(this.httpResult, this.current, this.getTaskContext());
        } else if (this.queryAction.hasMore()) {
            if (this.stoped) {
                return false;
            }
            this.httpResult = this.queryAction.execute();
            List<Map> datas = this.httpResult.getDatas();
            if (datas != null && datas.size() > 0) {
                this.iterator = datas.iterator();
                this.current = this.iterator.next();
                this.record = new HttpRecord(this.httpResult, this.current, this.getTaskContext());
                hasNext = true;
            }
        }
        return hasNext;
    }

    @Override
    public TranMeta getMetaData() {
        return new DefaultTranMetaData(this.current.keySet());
    }

    @Override
    public Object getKeys() {
        return this.record.getKeys();
    }

    @Override
    public Object getRecord() {
        return this.current;
    }

    @Override
    public Record getCurrentRecord() {
        return this.record;
    }

    @Override
    public void stop() {
        this.stoped = true;
    }

    @Override
    public void stopTranOnly() {
        this.stoped = true;
    }

    @Override
    public Object getMetaValue(String fieldName) {
        return this.getValue(fieldName);
    }

    @Override
    public boolean removed() {
        return false;
    }

    @Override
    public boolean reachEOFClosed() {
        return false;
    }
}

