/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.es.output;

import com.frameworkset.common.poolman.handle.ValueExchange;
import com.frameworkset.orm.annotation.ESIndexWrapper;
import com.frameworkset.util.SimpleStringUtil;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.client.BuildTool;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.serial.CharEscapeUtil;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.elasticsearch.template.ConfigDSLUtil;
import org.frameworkset.tran.BaseCommonRecordDataTran;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.config.ClientOptions;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.plugin.db.output.JDBCGetVariableValue;
import org.frameworkset.tran.plugin.es.output.ElasticsearchOutputConfig;
import org.frameworkset.tran.record.RecordColumnInfo;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.BaseParrelTranCommand;
import org.frameworkset.tran.task.BaseSerialTranCommand;
import org.frameworkset.tran.task.StringTranJob;
import org.frameworkset.tran.task.TaskCall;
import org.frameworkset.tran.task.TaskCommandImpl;

public class BaseElasticsearchDataTran
extends BaseCommonRecordDataTran {
    private ClientInterface[] clientInterfaces;
    private boolean versionUpper7;
    private String elasticsearch;
    protected ElasticsearchOutputConfig elasticsearchOutputConfig;

    protected CommonRecord buildStringRecord(Context context, Writer writer) throws Exception {
        this.evalBuilk(writer, context, this.versionUpper7);
        return null;
    }

    private void initClientInterfaces(String elasticsearchs) {
        if (elasticsearchs != null) {
            String[] _elasticsearchs = elasticsearchs.split(",");
            this.clientInterfaces = new ClientInterface[_elasticsearchs.length];
            for (int i = 0; i < _elasticsearchs.length; ++i) {
                this.clientInterfaces[i] = ElasticSearchHelper.getRestClientUtil((String)_elasticsearchs[i]);
            }
        } else {
            this.clientInterfaces = new ClientInterface[1];
            this.clientInterfaces[0] = ElasticSearchHelper.getRestClientUtil((String)"default");
        }
        if (this.clientInterfaces != null && this.clientInterfaces.length > 0) {
            this.versionUpper7 = this.clientInterfaces[0].isVersionUpper7();
        }
    }

    public BaseElasticsearchDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, currentStatus);
        this.elasticsearchOutputConfig = (ElasticsearchOutputConfig)importContext.getOutputConfig();
        String elasticsearch = this.elasticsearchOutputConfig.getTargetElasticsearch();
        if (elasticsearch == null) {
            elasticsearch = "default";
        }
        this.elasticsearch = elasticsearch;
    }

    @Override
    protected void initTranJob() {
        this.tranJob = new StringTranJob();
    }

    @Override
    protected void initTranTaskCommand() {
        this.parrelTranCommand = new BaseParrelTranCommand(){

            @Override
            public int hanBatchActionTask(ImportCount totalCount, long dataSize, int taskNo, Object lastValue, Object datas, boolean reachEOFClosed, CommonRecord record, ExecutorService service, List<Future> tasks, TranErrorWrapper tranErrorWrapper) {
                if (datas != null) {
                    TaskCommandImpl taskCommand = new TaskCommandImpl(totalCount, BaseElasticsearchDataTran.this.importContext, BaseElasticsearchDataTran.this.elasticsearchOutputConfig, dataSize, ++taskNo, BaseElasticsearchDataTran.this.taskContext.getJobNo(), lastValue, BaseElasticsearchDataTran.this.currentStatus, reachEOFClosed, BaseElasticsearchDataTran.this.taskContext);
                    taskCommand.setClientInterfaces(BaseElasticsearchDataTran.this.clientInterfaces);
                    taskCommand.setDatas((String)datas);
                    tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                }
                return taskNo;
            }

            @Override
            public CommonRecord buildStringRecord(Context context, Writer writer) throws Exception {
                return BaseElasticsearchDataTran.this.buildStringRecord(context, writer);
            }
        };
        this.serialTranCommand = new BaseSerialTranCommand(){

            @Override
            public int hanBatchActionTask(ImportCount totalCount, long dataSize, int taskNo, Object lastValue, Object datas, boolean reachEOFClosed, CommonRecord record) {
                return BaseElasticsearchDataTran.this.processDataSerial(totalCount, dataSize, taskNo, lastValue, datas, reachEOFClosed, record);
            }

            @Override
            public int endSerialActionTask(ImportCount totalCount, long dataSize, int taskNo, Object lastValue, Object datas, boolean reachEOFClosed, CommonRecord record) {
                return BaseElasticsearchDataTran.this.processDataSerial(totalCount, dataSize, taskNo, lastValue, datas, reachEOFClosed, record);
            }

            @Override
            public CommonRecord buildStringRecord(Context context, Writer writer) throws Exception {
                return BaseElasticsearchDataTran.this.buildStringRecord(context, writer);
            }
        };
    }

    @Override
    public void init() {
        super.init();
        this.initClientInterfaces(this.elasticsearch);
        if (this.elasticsearchOutputConfig.getEsIndexWrapper() == null) {
            throw new DataImportException("Global Elasticsearch index must be setted, please check your import job builder config.");
        }
        this.taskInfo = "import data to elasticsearch[" + this.elasticsearch + "] " + " IndexName[" + this.elasticsearchOutputConfig.getEsIndexWrapper().getIndex() + "] IndexType[" + this.elasticsearchOutputConfig.getEsIndexWrapper().getType() + "] start.";
    }

    public BaseElasticsearchDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, String esCluster, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, currentStatus);
        this.elasticsearchOutputConfig = (ElasticsearchOutputConfig)importContext.getOutputConfig();
        this.elasticsearch = esCluster;
    }

    protected int processDataSerial(ImportCount totalCount, long dataSize, int taskNo, Object lastValue, Object datas, boolean reachEOFClosed, CommonRecord record) {
        if (datas != null) {
            TaskCommandImpl taskCommand = new TaskCommandImpl(totalCount, this.importContext, this.elasticsearchOutputConfig, dataSize, ++taskNo, this.taskContext.getJobNo(), lastValue, this.currentStatus, reachEOFClosed, this.taskContext);
            taskCommand.setClientInterfaces(this.clientInterfaces);
            taskCommand.setDatas((String)datas);
            TaskCall.call(taskCommand);
        }
        return taskNo;
    }

    public static void buildMeta(Context context, Writer writer, boolean upper7) throws Exception {
        String pipeline;
        Object versionType;
        Object version;
        Object id = context.getEsId();
        Object parentId = context.getParentId();
        Object routing = context.getRouting();
        ClientOptions clientOptions = context.getClientOptions();
        Object esRetryOnConflict = clientOptions != null ? clientOptions.getEsRetryOnConflict() : null;
        ESIndexWrapper esIndexWrapper = context.getESIndexWrapper();
        JDBCGetVariableValue jdbcGetVariableValue = new JDBCGetVariableValue(context);
        writer.write("{ \"");
        writer.write(context.getOperation());
        writer.write("\" : { \"_index\" : \"");
        if (esIndexWrapper == null) {
            throw new DataImportException(" ESIndex not seted.");
        }
        BuildTool.buildIndiceName((ESIndexWrapper)esIndexWrapper, (Writer)writer, (ESIndexWrapper.GetVariableValue)jdbcGetVariableValue);
        writer.write("\"");
        if (!upper7) {
            writer.write(", \"_type\" : \"");
            if (esIndexWrapper == null) {
                throw new DataImportException(" ESIndex type not seted.");
            }
            String indexType = BuildTool.buildIndiceType((ESIndexWrapper)esIndexWrapper, (ESIndexWrapper.GetVariableValue)jdbcGetVariableValue);
            if (indexType == null || indexType.equals("")) {
                throw new DataImportException(" ESIndex type not seted.");
            }
            writer.write(indexType);
            writer.write("\"");
        }
        if (id != null) {
            writer.write(", \"_id\" : ");
            BuildTool.buildId((Object)id, (Writer)writer, (boolean)true);
        }
        if (parentId != null) {
            writer.write(", \"parent\" : ");
            BuildTool.buildId((Object)parentId, (Writer)writer, (boolean)true);
        }
        if (routing != null) {
            if (!upper7) {
                writer.write(", \"_routing\" : ");
            } else {
                writer.write(", \"routing\" : ");
            }
            BuildTool.buildRouting((Object)routing, (Writer)writer, (boolean)true);
        }
        if (esRetryOnConflict != null) {
            if (!upper7) {
                writer.write(",\"_retry_on_conflict\":");
            } else {
                writer.write(",\"retry_on_conflict\":");
            }
            writer.write(String.valueOf(esRetryOnConflict));
        }
        if ((version = context.getVersion()) != null) {
            if (!upper7) {
                writer.write(",\"_version\":");
            } else {
                writer.write(",\"version\":");
            }
            writer.write(String.valueOf(version));
        }
        Object object = versionType = clientOptions != null ? clientOptions.getVersionType() : null;
        if (versionType != null) {
            if (!upper7) {
                writer.write(",\"_version_type\":");
            } else {
                writer.write(",\"version_type\":");
            }
            writer.write(String.valueOf(versionType));
            writer.write("\"");
        }
        if (upper7) {
            Long if_primary_term;
            Long if_seq_no;
            Long l = if_seq_no = clientOptions != null ? clientOptions.getIfSeqNo() : null;
            if (if_seq_no != null) {
                writer.write(",\"if_seq_no\":");
                writer.write(String.valueOf(if_seq_no));
            }
            Long l2 = if_primary_term = clientOptions != null ? clientOptions.getIfPrimaryTerm() : null;
            if (if_primary_term != null) {
                writer.write(",\"if_primary_term\":");
                writer.write(String.valueOf(if_primary_term));
            }
        }
        String string = pipeline = clientOptions != null ? clientOptions.getPipeline() : null;
        if (pipeline != null) {
            writer.write(",\"pipeline\":\"");
            writer.write(pipeline);
            writer.write("\"");
        }
        if (context.isInsert()) {
            String op_type;
            String string2 = op_type = clientOptions != null ? clientOptions.getOpType() : null;
            if (op_type != null) {
                writer.write(",\"op_type\":\"");
                writer.write(op_type);
                writer.write("\"");
            }
        }
        writer.write(" } }\n");
    }

    public void evalBuilk(Writer writer, Context context, boolean upper7) throws Exception {
        if (context.isInsert()) {
            BaseElasticsearchDataTran.buildMeta(context, writer, upper7);
            this.serialResult(writer, context);
            writer.write("\n");
        } else if (context.isUpdate()) {
            List<String> sourceUpdateIncludes;
            List<String> sourceUpdateExcludes;
            Boolean esReturnSource;
            Object detect_noop;
            Object esDocAsUpsert;
            BaseElasticsearchDataTran.buildMeta(context, writer, upper7);
            writer.write("{\"doc\":");
            this.serialResult(writer, context);
            ClientOptions clientOptions = context.getClientOptions();
            Object object = esDocAsUpsert = clientOptions != null ? clientOptions.getDocasupsert() : null;
            if (esDocAsUpsert != null) {
                writer.write(",\"doc_as_upsert\":");
                writer.write(String.valueOf(esDocAsUpsert));
            }
            Object object2 = detect_noop = clientOptions != null ? clientOptions.getDetectNoop() : null;
            if (detect_noop != null) {
                writer.write(",\"detect_noop\":");
                writer.write(detect_noop.toString());
            }
            Boolean bl = esReturnSource = clientOptions != null ? clientOptions.getReturnSource() : null;
            if (esReturnSource != null) {
                writer.write(",\"_source\":");
                writer.write(String.valueOf(esReturnSource));
            }
            List<String> list = sourceUpdateExcludes = clientOptions != null ? clientOptions.getSourceUpdateExcludes() : null;
            if (sourceUpdateExcludes != null && !upper7) {
                writer.write(",\"_source_excludes\":");
                SerialUtil.object2json(sourceUpdateExcludes, (Writer)writer);
            }
            List<String> list2 = sourceUpdateIncludes = clientOptions != null ? clientOptions.getSourceUpdateIncludes() : null;
            if (sourceUpdateIncludes != null && !upper7) {
                writer.write(",\"_source_includes\":");
                SerialUtil.object2json(sourceUpdateIncludes, (Writer)writer);
            }
            writer.write("}\n");
        } else if (context.isDelete()) {
            BaseElasticsearchDataTran.evalDeleteBuilk(writer, context, upper7);
        } else {
            BaseElasticsearchDataTran.buildMeta(context, writer, upper7);
            this.serialResult(writer, context);
            writer.write("\n");
        }
    }

    public static void evalDeleteBuilk(Writer writer, Context context, boolean isUpper7) throws Exception {
        BaseElasticsearchDataTran.buildMeta(context, writer, isUpper7);
    }

    private void serialResult(Writer writer, Context context) throws Exception {
        writer.write("{");
        boolean hasSeted = false;
        CommonRecord dataRecord = context.getCommonRecord();
        Map<String, Object> datas = dataRecord.getDatas();
        for (Map.Entry<String, Object> entry : datas.entrySet()) {
            String colName = entry.getKey();
            if (colName.equals("_id")) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Field [_id] is a metadata field and cannot be added inside a document. Use the index API request parameters.");
                continue;
            }
            Object value = entry.getValue();
            if (value == null && this.importContext.isIgnoreNullValueField()) continue;
            if (hasSeted) {
                writer.write(",");
            } else {
                hasSeted = true;
            }
            writer.write("\"");
            writer.write(colName);
            writer.write("\":");
            if (value != null) {
                CharEscapeUtil charEscapeUtil;
                String dataStr;
                RecordColumnInfo recordColumnInfo = dataRecord.getRecordColumnInfo(colName);
                if (value instanceof String) {
                    writer.write("\"");
                    CharEscapeUtil charEscapeUtil2 = new CharEscapeUtil(writer);
                    charEscapeUtil2.writeString((String)value, true);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Date) {
                    DateFormat dateFormat = recordColumnInfo.getDateFormat();
                    String dataStr2 = ConfigDSLUtil.getDate((Date)((Date)value), (DateFormat)dateFormat);
                    writer.write("\"");
                    writer.write(dataStr2);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Clob) {
                    dataStr = ValueExchange.getStringFromClob((Clob)((Clob)value));
                    writer.write("\"");
                    charEscapeUtil = new CharEscapeUtil(writer);
                    charEscapeUtil.writeString(dataStr, true);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Blob) {
                    dataStr = ValueExchange.getStringFromBlob((Blob)((Blob)value));
                    writer.write("\"");
                    charEscapeUtil = new CharEscapeUtil(writer);
                    charEscapeUtil.writeString(dataStr, true);
                    writer.write("\"");
                    continue;
                }
                SimpleStringUtil.object2json((Object)value, (Writer)writer);
                continue;
            }
            writer.write("null");
        }
        writer.write("}");
    }
}

