/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.es;

import com.frameworkset.util.SimpleStringUtil;
import java.util.Map;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.boot.ElasticSearchBoot;
import org.frameworkset.elasticsearch.boot.ElasticsearchBootResult;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.BasePlugin;
import org.frameworkset.tran.plugin.es.ESConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseESPlugin
extends BasePlugin {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ESConfig esConfig;
    protected String applicationPropertiesFile;
    private ElasticsearchBootResult elasticsearchBootResult;

    public BaseESPlugin(ImportContext importContext) {
        super(importContext);
    }

    protected void initES() {
        ElasticsearchBootResult _elasticsearchBootResult;
        if (this.esConfig != null && (_elasticsearchBootResult = ElasticSearchBoot.boot(this.esConfig.getConfigs())) != null) {
            if (this.elasticsearchBootResult == null) {
                this.elasticsearchBootResult = _elasticsearchBootResult;
            } else {
                this.elasticsearchBootResult.addResourceStartResults(_elasticsearchBootResult.getResourceStartResult());
            }
        }
        if (SimpleStringUtil.isNotEmpty((String)this.applicationPropertiesFile) && (_elasticsearchBootResult = ElasticSearchBoot.boot((String)this.applicationPropertiesFile)) != null) {
            if (this.elasticsearchBootResult == null) {
                this.elasticsearchBootResult = _elasticsearchBootResult;
            } else {
                this.elasticsearchBootResult.addResourceStartResults(_elasticsearchBootResult.getResourceStartResult());
            }
        }
    }

    protected void stopES() {
        Map initedElasticsearchs;
        if (this.elasticsearchBootResult != null && this.elasticsearchBootResult.getResourceStartResult() != null && (initedElasticsearchs = this.elasticsearchBootResult.getResourceStartResult()) != null && initedElasticsearchs.size() > 0) {
            ElasticSearchHelper.stopElasticsearchs((Map)initedElasticsearchs);
        }
    }

    public void destroy(boolean waitTranStop) {
        this.stopES();
    }
}

