/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.db.output;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.util.SimpleStringUtil;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.config.ImportBuilder;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.plugin.db.BaseDBConfig;
import org.frameworkset.tran.plugin.db.TranSQLInfo;
import org.frameworkset.tran.plugin.db.input.StatementHandler;
import org.frameworkset.tran.plugin.db.output.DBOutputDataTranPlugin;
import org.frameworkset.tran.schedule.TaskContext;

public class DBOutputConfig
extends BaseDBConfig
implements OutputConfig {
    private DBConfig targetDBConfig;
    protected String sql;
    private String sqlFilepath;
    protected String sqlName;
    protected String insertSql;
    protected String insertSqlName;
    protected String updateSqlName;
    protected String updateSql;
    protected String deleteSqlName;
    protected String deleteSql;
    protected boolean optimize;
    protected BatchHandler batchHandler;
    protected StatementHandler statementHandler;
    private TranSQLInfo targetSqlInfo;
    private TranSQLInfo targetUpdateSqlInfo;
    private TranSQLInfo targetDeleteSqlInfo;
    private String targetDbname;

    public DBOutputConfig setDbName(String dbName) {
        this._setDbName(dbName);
        this.targetDbname = dbName;
        return this;
    }

    public String getTargetDbname() {
        return this.targetDbname;
    }

    public DBOutputConfig setStatementHandler(StatementHandler statementHandler) {
        this.statementHandler = statementHandler;
        return this;
    }

    public StatementHandler getStatementHandler() {
        return this.statementHandler;
    }

    public DBOutputConfig setInsertSqlName(String insertSqlName) {
        this.insertSqlName = insertSqlName;
        return this;
    }

    public String getInsertSqlName() {
        return this.insertSqlName;
    }

    public String getInsertSql() {
        return this.insertSql;
    }

    public DBOutputConfig setInsertSql(String insertSql) {
        this.insertSql = insertSql;
        return this;
    }

    public DBConfig getTargetDBConfig() {
        return this.targetDBConfig;
    }

    public DBConfig getTargetDBConfig(TaskContext taskContext) {
        if (taskContext != null && taskContext.getTargetDBConfig() != null) {
            return taskContext.getTargetDBConfig();
        }
        return this.getTargetDBConfig();
    }

    public DBOutputConfig setTargetDBConfig(DBConfig targetDBConfig) {
        this.targetDBConfig = targetDBConfig;
        return this;
    }

    public String getSql() {
        return this.sql;
    }

    public DBOutputConfig setSql(String sql) {
        this.sql = sql;
        return this;
    }

    public String getSqlFilepath() {
        return this.sqlFilepath;
    }

    public DBOutputConfig setSqlFilepath(String sqlFilepath) {
        this.sqlFilepath = sqlFilepath;
        return this;
    }

    public DBOutputConfig setShowSql(boolean showsql) {
        this._setShowSql(showsql);
        return this;
    }

    public String getSqlName() {
        return this.sqlName;
    }

    public DBOutputConfig setSqlName(String sqlName) {
        this.sqlName = sqlName;
        return this;
    }

    public String getDeleteSql() {
        return this.deleteSql;
    }

    public DBOutputConfig setDeleteSql(String deleteSql) {
        this.deleteSql = deleteSql;
        return this;
    }

    public String getDeleteSqlName() {
        return this.deleteSqlName;
    }

    public DBOutputConfig setDeleteSqlName(String deleteSqlName) {
        this.deleteSqlName = deleteSqlName;
        return this;
    }

    public String getUpdateSql() {
        return this.updateSql;
    }

    public DBOutputConfig setUpdateSql(String updateSql) {
        this.updateSql = updateSql;
        return this;
    }

    public String getUpdateSqlName() {
        return this.updateSqlName;
    }

    public DBOutputConfig setUpdateSqlName(String updateSqlName) {
        this.updateSqlName = updateSqlName;
        return this;
    }

    public DBOutputConfig setOptimize(boolean optimize) {
        this.optimize = optimize;
        return this;
    }

    public boolean optimize() {
        return this.optimize;
    }

    public DBOutputConfig setBatchHandler(BatchHandler batchHandler) {
        this.batchHandler = batchHandler;
        return this;
    }

    public BatchHandler getBatchHandler() {
        return this.batchHandler;
    }

    @Override
    public void build(ImportBuilder importBuilder) {
        if (this.targetDBConfig == null) {
            if (this.dbConfig == null) {
                this.dbConfig = importBuilder.getDefaultDBConfig();
                if (this.dbConfig != null) {
                    this.targetDBConfig = this.dbConfig;
                }
            } else {
                this.targetDBConfig = this.dbConfig;
            }
        }
        if (this.targetDBConfig == null) {
            throw new DataImportException("Target DB Config not config to dboutputconfig.");
        }
        if (SimpleStringUtil.isEmpty((String)this.targetDbname)) {
            this.targetDbname = this.targetDBConfig.getDbName();
        }
    }

    public String getTargetDBName(TaskContext taskContext) {
        DBConfig dbConfig = this.getTargetDBConfig(taskContext);
        if (dbConfig != null && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbName())) {
            return dbConfig.getDbName();
        }
        String dbName = this.getTargetDbname();
        return dbName;
    }

    public TranSQLInfo getTargetSqlInfo(TaskContext taskContext) {
        if (taskContext != null && taskContext.getTargetSqlInfo() != null) {
            return taskContext.getTargetSqlInfo();
        }
        return this.targetSqlInfo;
    }

    public DBOutputConfig setTargetSqlInfo(TranSQLInfo targetSqlInfo) {
        this.targetSqlInfo = targetSqlInfo;
        return this;
    }

    public TranSQLInfo getTargetUpdateSqlInfo(TaskContext taskContext) {
        if (taskContext != null && taskContext.getTargetUpdateSqlInfo() != null) {
            return taskContext.getTargetUpdateSqlInfo();
        }
        return this.targetUpdateSqlInfo;
    }

    public DBOutputConfig setTargetUpdateSqlInfo(TranSQLInfo sqlInfo) {
        this.targetUpdateSqlInfo = sqlInfo;
        return this;
    }

    public TranSQLInfo getTargetDeleteSqlInfo(TaskContext taskContext) {
        if (taskContext != null && taskContext.getTargetDeleteSqlInfo() != null) {
            return taskContext.getTargetDeleteSqlInfo();
        }
        return this.targetDeleteSqlInfo;
    }

    public DBOutputConfig setTargetDeleteSqlInfo(TranSQLInfo sqlInfo) {
        this.targetDeleteSqlInfo = sqlInfo;
        return this;
    }

    @Override
    public OutputPlugin getOutputPlugin(ImportContext importContext) {
        return new DBOutputDataTranPlugin(importContext);
    }

    public DBOutputConfig setColumnLableUpperCase(boolean columnLableUpperCase) {
        this._setColumnLableUpperCase(columnLableUpperCase);
        return this;
    }

    public DBOutputConfig setDbInitSize(int dbInitSize) {
        this._setDbInitSize(dbInitSize);
        return this;
    }

    public DBOutputConfig setDbMaxSize(int dbMaxSize) {
        this._setDbMaxSize(dbMaxSize);
        return this;
    }

    public DBOutputConfig setDbMinIdleSize(int dbMinIdleSize) {
        this._setDbMinIdleSize(dbMinIdleSize);
        return this;
    }

    public DBOutputConfig setDbDriver(String dbDriver) {
        this._setDbDriver(dbDriver);
        return this;
    }

    public DBOutputConfig setEnableDBTransaction(boolean enableDBTransaction) {
        this._setEnableDBTransaction(enableDBTransaction);
        return this;
    }

    public DBOutputConfig setDbUrl(String dbUrl) {
        this._setDbUrl(dbUrl);
        return this;
    }

    public DBOutputConfig setDbAdaptor(String dbAdaptor) {
        this._setDbAdaptor(dbAdaptor);
        return this;
    }

    public DBOutputConfig setDbtype(String dbtype) {
        this._setDbtype(dbtype);
        return this;
    }

    public DBOutputConfig setDbUser(String dbUser) {
        this._setDbUser(dbUser);
        return this;
    }

    public DBOutputConfig setDbPassword(String dbPassword) {
        this._setDbPassword(dbPassword);
        return this;
    }

    public DBOutputConfig setValidateSQL(String validateSQL) {
        this._setValidateSQL(validateSQL);
        return this;
    }

    public DBOutputConfig setUsePool(boolean usePool) {
        this._setUsePool(usePool);
        return this;
    }

    public DBOutputConfig setDbInfoEncryptClass(String dbInfoEncryptClass) {
        this._setDbInfoEncryptClass(dbInfoEncryptClass);
        return this;
    }

    public DBOutputConfig setJdbcFetchSize(Integer jdbcFetchSize) {
        this._setJdbcFetchSize(jdbcFetchSize);
        return this;
    }

    public DBOutputConfig setRemoveAbandoned(boolean removeAbandoned) {
        this._setRemoveAbandoned(removeAbandoned);
        return this;
    }

    public DBOutputConfig setConnectionTimeout(int connectionTimeout) {
        this._setConnectionTimeout(connectionTimeout);
        return this;
    }

    public DBOutputConfig setMaxWait(int maxWait) {
        this._setMaxWait(maxWait);
        return this;
    }

    public DBOutputConfig setMaxIdleTime(int maxIdleTime) {
        this._setMaxIdleTime(maxIdleTime);
        return this;
    }
}

