/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.db.output;

import com.frameworkset.common.poolman.Param;
import com.frameworkset.util.VariableHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.persitent.util.PersistentSQLVariable;
import org.frameworkset.tran.BaseCommonRecordDataTran;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.plugin.db.TranSQLInfo;
import org.frameworkset.tran.plugin.db.input.DBRecord;
import org.frameworkset.tran.plugin.db.output.Base2DBTaskCommandImpl;
import org.frameworkset.tran.plugin.db.output.DBOutputConfig;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.BaseParrelTranCommand;
import org.frameworkset.tran.task.BaseSerialTranCommand;
import org.frameworkset.tran.task.CommonRecordTranJob;
import org.frameworkset.tran.task.TaskCall;

public class DBOutPutDataTran
extends BaseCommonRecordDataTran {
    protected DBOutputConfig dbOutputConfig;

    @Override
    public void init() {
        super.init();
        this.dbOutputConfig = (DBOutputConfig)this.importContext.getOutputConfig();
        StringBuilder builder = new StringBuilder();
        DBConfig dbConfig = this.dbOutputConfig.getTargetDBConfig(this.taskContext);
        if (dbConfig == null) {
            dbConfig = this.dbOutputConfig.getTargetDBConfig();
        }
        if (dbConfig != null) {
            builder.append("Import data to db[").append(dbConfig.getDbName()).append("]");
        } else {
            String targetDBName = this.dbOutputConfig.getTargetDBName(this.taskContext);
            if (targetDBName == null) {
                targetDBName = this.dbOutputConfig.getTargetDbname();
            }
            builder.append("Import data to db[").append(targetDBName).append("]");
        }
        if (this.dbOutputConfig.getTargetSqlInfo(this.taskContext) != null) {
            builder.append(" insert sql[").append(this.dbOutputConfig.getTargetSqlInfo(this.taskContext).getOriginSQL()).append("]");
        }
        if (this.dbOutputConfig.getTargetUpdateSqlInfo(this.taskContext) != null) {
            builder.append("\r\nupdate sql[").append(this.dbOutputConfig.getTargetUpdateSqlInfo(this.taskContext).getOriginSQL()).append("]");
        }
        if (this.dbOutputConfig.getTargetDeleteSqlInfo(this.taskContext) != null) {
            builder.append("\r\ndelete sql[").append(this.dbOutputConfig.getTargetDeleteSqlInfo(this.taskContext).getOriginSQL()).append("]");
        }
        this.taskInfo = builder.toString();
    }

    public DBOutPutDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, currentStatus);
    }

    @Override
    public CommonRecord buildRecord(Context context) {
        DBRecord dbRecord = new DBRecord();
        List<VariableHandler.Variable> vars = null;
        Object temp = null;
        Param param = null;
        TranSQLInfo insertSqlinfo = this.dbOutputConfig.getTargetSqlInfo(context.getTaskContext());
        TranSQLInfo updateSqlinfo = this.dbOutputConfig.getTargetUpdateSqlInfo(context.getTaskContext());
        TranSQLInfo deleteSqlinfo = this.dbOutputConfig.getTargetDeleteSqlInfo(context.getTaskContext());
        if (context.isInsert()) {
            dbRecord.setAction(0);
            vars = insertSqlinfo.getVars();
        } else if (context.isUpdate()) {
            dbRecord.setAction(1);
            vars = updateSqlinfo.getVars();
        } else {
            dbRecord.setAction(2);
            vars = deleteSqlinfo.getVars();
        }
        super.buildRecord(dbRecord, context);
        String varName = null;
        ArrayList<Param> record = new ArrayList<Param>();
        for (int i = 0; i < vars.size(); ++i) {
            PersistentSQLVariable var = (PersistentSQLVariable)vars.get(i);
            varName = var.getVariableName();
            temp = dbRecord.getData(varName);
            if (temp == null && this.logger.isDebugEnabled()) {
                this.logger.debug("\u672a\u6307\u5b9a\u7ed1\u5b9a\u53d8\u91cf\u7684\u503c\uff1a{}", (Object)varName);
            }
            param = new Param();
            param.setVariable((VariableHandler.Variable)var);
            param.setIndex(var.getPosition() + 1);
            param.setData(temp);
            param.setName(varName);
            param.setMethod(var.getMethod());
            record.add(param);
        }
        dbRecord.setParams(record);
        return dbRecord;
    }

    @Override
    protected void initTranTaskCommand() {
        this.parrelTranCommand = new BaseParrelTranCommand(){

            @Override
            public int hanBatchActionTask(ImportCount totalCount, long dataSize, int taskNo, Object lastValue, Object datas, boolean reachEOFClosed, CommonRecord record, ExecutorService service, List<Future> tasks, TranErrorWrapper tranErrorWrapper) {
                List records = DBOutPutDataTran.this.convertDatas(datas);
                if (records != null && records.size() > 0) {
                    Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(totalCount, DBOutPutDataTran.this.importContext, records, ++taskNo, DBOutPutDataTran.this.taskContext.getJobNo(), DBOutPutDataTran.this.taskInfo, false, lastValue, DBOutPutDataTran.this.currentStatus, reachEOFClosed, DBOutPutDataTran.this.taskContext);
                    tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                }
                return taskNo;
            }
        };
        this.serialTranCommand = new BaseSerialTranCommand(){

            private int action(ImportCount totalCount, long dataSize, int taskNo, Object lastValue, Object datas, boolean reachEOFClosed) {
                List records = DBOutPutDataTran.this.convertDatas(datas);
                if (records != null && records.size() > 0) {
                    Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(totalCount, DBOutPutDataTran.this.importContext, records, ++taskNo, DBOutPutDataTran.this.taskContext.getJobNo(), DBOutPutDataTran.this.taskInfo, false, lastValue, DBOutPutDataTran.this.currentStatus, reachEOFClosed, DBOutPutDataTran.this.taskContext);
                    TaskCall.call(taskCommand);
                }
                return taskNo;
            }

            @Override
            public int hanBatchActionTask(ImportCount totalCount, long dataSize, int taskNo, Object lastValue, Object datas, boolean reachEOFClosed, CommonRecord record) {
                return this.action(totalCount, dataSize, taskNo, lastValue, datas, reachEOFClosed);
            }

            @Override
            public int endSerialActionTask(ImportCount totalCount, long dataSize, int taskNo, Object lastValue, Object datas, boolean reachEOFClosed, CommonRecord record) {
                taskNo = this.action(totalCount, dataSize, taskNo, lastValue, datas, reachEOFClosed);
                return taskNo;
            }
        };
    }

    @Override
    protected void initTranJob() {
        this.tranJob = new CommonRecordTranJob();
    }
}

