/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.custom.output;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.tran.BaseCommonRecordDataTran;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.JobCountDownLatch;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.plugin.custom.output.CustomTaskCommandImpl;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.BaseParrelTranCommand;
import org.frameworkset.tran.task.BaseSerialTranCommand;
import org.frameworkset.tran.task.CommonRecordTranJob;
import org.frameworkset.tran.task.TaskCall;
import org.slf4j.Logger;

public class CustomOutPutDataTran
extends BaseCommonRecordDataTran {
    protected JobCountDownLatch countDownLatch;
    protected String taskInfo;

    @Override
    public void logTaskStart(Logger logger) {
        logger.info(this.taskInfo + " start.");
    }

    @Override
    public String tran() throws DataImportException {
        try {
            String ret;
            String string = ret = super.tran();
            return string;
        }
        catch (DataImportException dataImportException) {
            if (this.countDownLatch != null) {
                this.countDownLatch.attachException(dataImportException);
            }
            throw dataImportException;
        }
        catch (Exception dataImportException) {
            if (this.countDownLatch != null) {
                this.countDownLatch.attachException(dataImportException);
            }
            throw new DataImportException(dataImportException);
        }
        catch (Throwable dataImportException) {
            if (this.countDownLatch != null) {
                this.countDownLatch.attachException(dataImportException);
            }
            throw new DataImportException(dataImportException);
        }
        finally {
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }
    }

    @Override
    public void init() {
        super.init();
        this.taskInfo = "Import data to custom output.";
    }

    public CustomOutPutDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, currentStatus);
    }

    public CustomOutPutDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, JobCountDownLatch countDownLatch, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, currentStatus);
        this.countDownLatch = countDownLatch;
    }

    @Override
    protected void initTranTaskCommand() {
        this.parrelTranCommand = new BaseParrelTranCommand(){

            @Override
            public int hanBatchActionTask(ImportCount totalCount, long dataSize, int taskNo, Object lastValue, Object datas, boolean reachEOFClosed, CommonRecord record, ExecutorService service, List<Future> tasks, TranErrorWrapper tranErrorWrapper) {
                List records = CustomOutPutDataTran.this.convertDatas(datas);
                if (records != null && records.size() > 0) {
                    CustomTaskCommandImpl taskCommand = new CustomTaskCommandImpl(totalCount, CustomOutPutDataTran.this.importContext, dataSize, ++taskNo, CustomOutPutDataTran.this.taskContext.getJobNo(), lastValue, CustomOutPutDataTran.this.currentStatus, reachEOFClosed, CustomOutPutDataTran.this.taskContext);
                    taskCommand.setDatas(records);
                    tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                }
                return taskNo;
            }
        };
        this.serialTranCommand = new BaseSerialTranCommand(){

            private int action(ImportCount totalCount, long dataSize, int taskNo, Object lastValue, Object datas, boolean reachEOFClosed) {
                List records = CustomOutPutDataTran.this.convertDatas(datas);
                if (records != null && records.size() > 0) {
                    CustomTaskCommandImpl taskCommand = new CustomTaskCommandImpl(totalCount, CustomOutPutDataTran.this.importContext, dataSize, ++taskNo, CustomOutPutDataTran.this.taskContext.getJobNo(), lastValue, CustomOutPutDataTran.this.currentStatus, reachEOFClosed, CustomOutPutDataTran.this.taskContext);
                    taskCommand.setDatas(records);
                    TaskCall.call(taskCommand);
                }
                return taskNo;
            }

            @Override
            public int hanBatchActionTask(ImportCount totalCount, long dataSize, int taskNo, Object lastValue, Object datas, boolean reachEOFClosed, CommonRecord record) {
                return this.action(totalCount, dataSize, taskNo, lastValue, datas, reachEOFClosed);
            }

            @Override
            public int endSerialActionTask(ImportCount totalCount, long dataSize, int taskNo, Object lastValue, Object datas, boolean reachEOFClosed, CommonRecord record) {
                taskNo = this.action(totalCount, dataSize, taskNo, lastValue, datas, reachEOFClosed);
                return taskNo;
            }
        };
    }

    @Override
    protected void initTranJob() {
        this.tranJob = new CommonRecordTranJob();
    }
}

