/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics;

import java.util.List;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.metrics.output.ETLMetrics;
import org.frameworkset.tran.schedule.CallInterceptor;
import org.frameworkset.tran.schedule.TaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ETLMetricsCallInterceptor
implements CallInterceptor {
    private static Logger logger = LoggerFactory.getLogger(ETLMetricsCallInterceptor.class);
    private List<ETLMetrics> etlMetrics;
    private ImportContext importContext;

    public ETLMetricsCallInterceptor(List<ETLMetrics> etlMetrics, ImportContext importContext) {
        this.etlMetrics = etlMetrics;
        this.importContext = importContext;
    }

    @Override
    public void preCall(TaskContext taskContext) {
    }

    @Override
    public void afterCall(TaskContext taskContext) {
        if (this.etlMetrics == null || this.etlMetrics.size() == 0) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Flush Metrics On Schedule Task Completed begin:CleanKeysWhenflushMetricsOnScheduleTaskCompleted[{}],WaitCompleteWhenflushMetricsOnScheduleTaskCompleted[{}]", (Object)this.importContext.isCleanKeysWhenflushMetricsOnScheduleTaskCompleted(), (Object)this.importContext.isWaitCompleteWhenflushMetricsOnScheduleTaskCompleted());
        }
        for (ETLMetrics metrics : this.etlMetrics) {
            metrics.forceFlush(this.importContext.isCleanKeysWhenflushMetricsOnScheduleTaskCompleted(), this.importContext.isWaitCompleteWhenflushMetricsOnScheduleTaskCompleted());
        }
        if (logger.isInfoEnabled()) {
            logger.info("Flush Metrics On Schedule Task Completed finished.", (Object)this.importContext.isCleanKeysWhenflushMetricsOnScheduleTaskCompleted(), (Object)this.importContext.isWaitCompleteWhenflushMetricsOnScheduleTaskCompleted());
        }
    }

    @Override
    public void throwException(TaskContext taskContext, Throwable e) {
    }
}

