/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.context;

import com.frameworkset.orm.annotation.BatchContext;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataRefactor;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.EndAction;
import org.frameworkset.tran.ExportCount;
import org.frameworkset.tran.ImportEndAction;
import org.frameworkset.tran.ImportStartAction;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.config.DynamicParam;
import org.frameworkset.tran.config.ImportBuilder;
import org.frameworkset.tran.config.InputConfig;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.context.JobContext;
import org.frameworkset.tran.metrics.ETLMetricsCallInterceptor;
import org.frameworkset.tran.metrics.JobTaskMetrics;
import org.frameworkset.tran.plugin.InputPlugin;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.plugin.metrics.output.ETLMetrics;
import org.frameworkset.tran.plugin.metrics.output.MetricsOutputConfig;
import org.frameworkset.tran.record.SplitHandler;
import org.frameworkset.tran.schedule.CallInterceptor;
import org.frameworkset.tran.schedule.ScheduleConfig;
import org.frameworkset.tran.schedule.ScheduleService;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.status.BaseStatusManager;
import org.frameworkset.util.ResourceEnd;
import org.frameworkset.util.ResourceStart;
import org.frameworkset.util.concurrent.ThreadPoolFactory;

public class BaseImportContext
implements ImportContext {
    protected BaseImportConfig baseImportConfig;
    protected InputConfig inputConfig;
    protected OutputConfig outputConfig;
    protected JobContext jobContext;
    protected EndAction endAction;
    private DataTranPlugin dataTranPlugin;
    private boolean currentStoped = false;
    private ExecutorService blockedExecutor;
    private Object blockedExecutorLock = new Object();

    @Override
    public JobContext getJobContext() {
        return this.jobContext;
    }

    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    @Override
    public JobTaskMetrics createJobTaskMetrics() {
        return this.getOutputPlugin().createJobTaskMetrics();
    }

    @Override
    public ImportStartAction getImportStartAction() {
        return this.baseImportConfig.getImportStartAction();
    }

    @Override
    public DBConfig getDefaultDBConfig() {
        return this.baseImportConfig.getDefaultDBConfig();
    }

    @Override
    public List<DBConfig> getOhterDBConfigs() {
        return this.baseImportConfig.getConfigs();
    }

    @Override
    public DataTranPlugin buildDataTranPlugin() {
        return this.inputConfig.buildDataTranPlugin(this);
    }

    @Override
    public boolean isIncreamentImport() {
        return this.dataTranPlugin.isIncreamentImport();
    }

    public void setBaseImportConfig(BaseImportConfig baseImportConfig) {
        this.baseImportConfig = baseImportConfig;
    }

    public void setInputConfig(InputConfig inputConfig) {
        this.inputConfig = inputConfig;
    }

    public void setOutputConfig(OutputConfig outputConfig) {
        this.outputConfig = outputConfig;
    }

    public void afterBuild(ImportBuilder importBuilder) {
        this.inputConfig.afterBuild(importBuilder, this);
        this.outputConfig.afterBuild(importBuilder, this);
        if (this.baseImportConfig.isFlushMetricsOnScheduleTaskCompleted()) {
            if (this.getMetrics() != null && this.getMetrics().size() > 0) {
                importBuilder.addCallInterceptor(new ETLMetricsCallInterceptor(this.getMetrics(), this), true);
            } else if (this.outputConfig instanceof MetricsOutputConfig) {
                importBuilder.addCallInterceptor(new ETLMetricsCallInterceptor(((MetricsOutputConfig)this.outputConfig).getMetrics(), this), true);
            }
            this.baseImportConfig.setCallInterceptors(importBuilder.taskCallInterceptors());
        }
    }

    @Override
    public ImportContext addResourceStart(ResourceStart resourceStart) {
        if (resourceStart != null) {
            this.dataTranPlugin.initResources(resourceStart);
        }
        return this;
    }

    @Override
    public void destroyResources(ResourceEnd resourceEnd) {
        if (resourceEnd != null) {
            this.dataTranPlugin.destroyResources(resourceEnd);
        }
    }

    @Override
    public InputConfig getInputConfig() {
        return this.inputConfig;
    }

    @Override
    public OutputConfig getOutputConfig() {
        return this.outputConfig;
    }

    @Override
    public InputPlugin getInputPlugin() {
        if (this.dataTranPlugin != null && this.dataTranPlugin.getInputPlugin() != null) {
            return this.dataTranPlugin.getInputPlugin();
        }
        return this.inputConfig.getInputPlugin(this);
    }

    @Override
    public OutputPlugin getOutputPlugin() {
        if (this.dataTranPlugin != null && this.dataTranPlugin.getOutputPlugin() != null) {
            return this.dataTranPlugin.getOutputPlugin();
        }
        return this.outputConfig.getOutputPlugin(this);
    }

    @Override
    public boolean isLastValueColumnSetted() {
        return this.baseImportConfig.isLastValueColumnSetted();
    }

    @Override
    public Map getJobOutputParams() {
        return this.baseImportConfig.getJobOutputParams();
    }

    @Override
    public Map getJobInputParams() {
        return this.baseImportConfig.getJobInputParams();
    }

    @Override
    public Map<String, DynamicParam> getJobDynamicInputParams() {
        return this.baseImportConfig.getJobDynamicInputParams();
    }

    @Override
    public Map<String, DynamicParam> getJobDynamicOutputParams() {
        return this.baseImportConfig.getJobDynamicOutputParams();
    }

    @Override
    public void setDataTranPlugin(DataTranPlugin dataTranPlugin) {
        this.dataTranPlugin = dataTranPlugin;
    }

    @Override
    public String[] getExportColumns() {
        return this.baseImportConfig.getExportColumns();
    }

    @Override
    public boolean useFilePointer() {
        return this.dataTranPlugin.useFilePointer();
    }

    public BaseImportContext() {
    }

    @Override
    public long getLogsendTaskMetric() {
        return this.baseImportConfig.getLogsendTaskMetric();
    }

    @Override
    public boolean serialAllData() {
        return this.baseImportConfig.isSerialAllData();
    }

    @Override
    public Integer increamentEndOffset() {
        return this.baseImportConfig.getIncreamentEndOffset();
    }

    @Override
    public boolean isAsynFlushStatus() {
        return this.baseImportConfig.isAsynFlushStatus();
    }

    @Override
    public long getAsynFlushStatusInterval() {
        return this.baseImportConfig.getAsynFlushStatusInterval();
    }

    @Override
    public SplitHandler getSplitHandler() {
        return this.baseImportConfig.getSplitHandler();
    }

    @Override
    public String getSplitFieldName() {
        return this.baseImportConfig.getSplitFieldName();
    }

    @Override
    public Context buildContext(TaskContext taskContext, TranResultSet tranResultSet, BatchContext batchContext) {
        return this.dataTranPlugin.buildContext(taskContext, tranResultSet, batchContext);
    }

    @Override
    public Long getTimeRangeLastValue() {
        return this.dataTranPlugin.getTimeRangeLastValue();
    }

    @Override
    public long getFlushInterval() {
        return this.baseImportConfig.getFlushInterval();
    }

    @Override
    public boolean isIgnoreNullValueField() {
        return this.baseImportConfig.isIgnoreNullValueField();
    }

    @Override
    public boolean isSortLastValue() {
        return this.baseImportConfig.isSortLastValue();
    }

    @Override
    public long getAsynResultPollTimeOut() {
        return this.baseImportConfig.getAsynResultPollTimeOut();
    }

    @Override
    public Integer getFetchSize() {
        return this.baseImportConfig.getFetchSize();
    }

    public void init() {
    }

    @Override
    public int getTranDataBufferQueue() {
        return this.baseImportConfig.getTranDataBufferQueue();
    }

    public BaseImportContext(BaseImportConfig baseImportConfig) {
        this.baseImportConfig = baseImportConfig;
    }

    @Override
    public ExportCount getExportCount() {
        return this.dataTranPlugin.getExportCount();
    }

    @Override
    public void setStatusTableId(int hashCode) {
        this.baseImportConfig.setStatusTableId(this.buildStatusId(hashCode));
    }

    @Override
    public String buildStatusId(int hashCode) {
        String jobId = this.getJobId();
        String jobType = this.getJobType();
        if (jobId != null) {
            return jobType + "-" + jobId + "-" + hashCode;
        }
        return jobType + "-" + hashCode;
    }

    @Override
    public DataRefactor getDataRefactor() {
        return this.baseImportConfig.getDataRefactor();
    }

    @Override
    public String getApplicationPropertiesFile() {
        return this.baseImportConfig.getApplicationPropertiesFile();
    }

    public List<DBConfig> getConfigs() {
        return this.baseImportConfig.getConfigs();
    }

    @Override
    public boolean isPrintTaskLog() {
        return this.baseImportConfig.isPrintTaskLog();
    }

    @Override
    public void setDataRefactor(DataRefactor dataRefactor) {
        this.baseImportConfig.setDataRefactor(dataRefactor);
    }

    @Override
    public void destroy(boolean waitTranStop, boolean fromScheduleEnd) {
        this.dataTranPlugin.destroy(waitTranStop, fromScheduleEnd);
    }

    @Override
    public void registEndAction(EndAction endAction) {
        this.endAction = endAction;
    }

    @Override
    public EndAction getEndAction() {
        return this.endAction;
    }

    @Override
    public void cleanResource() {
        try {
            if (this.blockedExecutor != null) {
                this.blockedExecutor.shutdown();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentStoped = true;
    }

    @Override
    public boolean isContinueOnError() {
        return this.baseImportConfig.isContinueOnError();
    }

    @Override
    public boolean assertCondition() {
        return this.dataTranPlugin.assertCondition();
    }

    @Override
    public List<CallInterceptor> getCallInterceptors() {
        return this.baseImportConfig.getCallInterceptors();
    }

    @Override
    public boolean isCurrentStoped() {
        return this.currentStoped;
    }

    @Override
    public ScheduleConfig getScheduleConfig() {
        return this.baseImportConfig.getScheduleConfig();
    }

    @Override
    public Boolean getFixedRate() {
        return this.baseImportConfig.getScheduleConfig().getFixedRate();
    }

    @Override
    public ScheduleService getScheduleService() {
        return this.dataTranPlugin.getScheduleService();
    }

    @Override
    public BaseImportConfig getImportConfig() {
        return this.baseImportConfig;
    }

    @Override
    public int getMaxRetry() {
        return this.baseImportConfig.getMaxRetry();
    }

    @Override
    public boolean isAsyn() {
        return this.baseImportConfig.isAsyn();
    }

    @Override
    public WrapedExportResultHandler getExportResultHandler() {
        return this.baseImportConfig.getExportResultHandler();
    }

    @Override
    public void flushLastValue(Object lastValue, Status currentStatus) {
        this.flushLastValue(lastValue, currentStatus, false);
    }

    @Override
    public void flushLastValue(Object lastValue, Status currentStatus, boolean reachEOFClosed) {
        Long timeLastValue = this.getTimeRangeLastValue();
        if (timeLastValue != null) {
            lastValue = this.max(lastValue, new Date(timeLastValue));
        }
        this.dataTranPlugin.flushLastValue(lastValue, currentStatus, reachEOFClosed);
    }

    @Override
    public boolean isLastValueDateType() {
        return this.baseImportConfig.isLastValueDateType();
    }

    @Override
    public Integer getLastValueType() {
        return this.baseImportConfig.getLastValueType();
    }

    @Override
    public DBConfig getStatusDbConfig() {
        return this.baseImportConfig.getStatusDbConfig();
    }

    @Override
    public boolean isExternalTimer() {
        return this.baseImportConfig.isExternalTimer();
    }

    @Override
    public String getLastValueColumn() {
        return this.baseImportConfig.getLastValueColumn();
    }

    @Override
    public String getLastValueColumnName() {
        return this.dataTranPlugin.getLastValueClumnName();
    }

    @Override
    public boolean isImportIncreamentConfigSetted() {
        return this.baseImportConfig.isImportIncreamentConfigSetted();
    }

    @Override
    public Object getConfigLastValue() {
        return this.baseImportConfig.getConfigLastValue();
    }

    @Override
    public String getLastValueStoreTableName() {
        return this.baseImportConfig.getLastValueStoreTableName();
    }

    @Override
    public String getLastValueStorePath() {
        return this.baseImportConfig.getLastValueStorePath();
    }

    @Override
    public DataTranPlugin getDataTranPlugin() {
        return this.dataTranPlugin;
    }

    @Override
    public boolean needUpdate(Object oldValue, Object newValue) {
        return BaseStatusManager.needUpdate(this.getLastValueType(), oldValue, newValue);
    }

    @Override
    public Object max(Object oldValue, Object newValue) {
        return BaseStatusManager.max(this.getLastValueType(), oldValue, newValue);
    }

    public void setLastValueDateformat(String lastValueDateformat) {
        this.baseImportConfig.setLastValueDateformat(lastValueDateformat);
    }

    @Override
    public String getLastValueDateformat() {
        return this.baseImportConfig.getLastValueDateformat();
    }

    @Override
    public void setLastValueType(int lastValueType) {
        this.baseImportConfig.setLastValueType(lastValueType);
    }

    @Override
    public int getThreadCount() {
        return this.baseImportConfig.getThreadCount();
    }

    @Override
    public boolean isParallel() {
        return this.baseImportConfig.isParallel();
    }

    @Override
    public int getQueue() {
        return this.baseImportConfig.getQueue();
    }

    @Override
    public void resume() {
        this.currentStoped = false;
    }

    @Override
    public String getDateFormat() {
        return this.baseImportConfig.getDateFormat();
    }

    @Override
    public String getLocale() {
        return this.baseImportConfig.getLocale();
    }

    @Override
    public String getTimeZone() {
        return this.baseImportConfig.getTimeZone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService buildThreadPool() {
        if (this.blockedExecutor != null) {
            return this.blockedExecutor;
        }
        Object object = this.blockedExecutorLock;
        synchronized (object) {
            if (this.blockedExecutor == null) {
                this.blockedExecutor = ThreadPoolFactory.buildThreadPool((String)"DataTranThread", (String)"DataTranThread", (int)this.getThreadCount(), (int)this.getQueue(), (long)-1L, (int)1000);
            }
        }
        return this.blockedExecutor;
    }

    @Override
    public Integer getStoreBatchSize() {
        if (this.baseImportConfig.getScheduleBatchSize() == null) {
            return this.baseImportConfig.getBatchSize();
        }
        return this.baseImportConfig.getScheduleBatchSize();
    }

    @Override
    public String getStatusTableId() {
        return this.baseImportConfig.getStatusTableId();
    }

    @Override
    public boolean isFromFirst() {
        return this.baseImportConfig.isFromFirst();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.baseImportConfig.setBatchSize(batchSize);
    }

    @Override
    public boolean isSchedulePaused(boolean autoPause) {
        return this.dataTranPlugin.isSchedulePaussed(autoPause);
    }

    @Override
    public ImportEndAction getImportEndAction() {
        return this.baseImportConfig.getImportEndAction();
    }

    @Override
    public String getJobName() {
        return this.baseImportConfig.getJobName();
    }

    @Override
    public Date getScheduleDate() {
        return this.baseImportConfig.getScheduleDate();
    }

    @Override
    public Date getScheduleEndDate() {
        return this.baseImportConfig.getScheduleEndDate();
    }

    @Override
    public Long getDeyLay() {
        return this.baseImportConfig.getDeyLay();
    }

    @Override
    public String getJobId() {
        return this.baseImportConfig.getJobId();
    }

    @Override
    public String getJobType() {
        return this.dataTranPlugin.getJobType();
    }

    @Override
    public String getDataTimeField() {
        return this.baseImportConfig.getDataTimeField();
    }

    @Override
    public List<ETLMetrics> getMetrics() {
        return this.baseImportConfig.getMetrics();
    }

    @Override
    public boolean isUseDefaultMapData() {
        return this.baseImportConfig.isUseDefaultMapData();
    }

    @Override
    public boolean isFlushMetricsOnScheduleTaskCompleted() {
        return this.baseImportConfig.isFlushMetricsOnScheduleTaskCompleted();
    }

    @Override
    public boolean isCleanKeysWhenflushMetricsOnScheduleTaskCompleted() {
        return this.baseImportConfig.isCleanKeysWhenflushMetricsOnScheduleTaskCompleted();
    }

    @Override
    public boolean isWaitCompleteWhenflushMetricsOnScheduleTaskCompleted() {
        return this.baseImportConfig.isWaitCompleteWhenflushMetricsOnScheduleTaskCompleted();
    }
}

