/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.spi.DefaultApplicationContext;
import org.frameworkset.spi.assemble.GetProperties;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DataRefactor;
import org.frameworkset.tran.DataStream;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.EndAction;
import org.frameworkset.tran.ExportResultHandler;
import org.frameworkset.tran.FieldMeta;
import org.frameworkset.tran.ImportEndAction;
import org.frameworkset.tran.ImportStartAction;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.config.DynamicParam;
import org.frameworkset.tran.config.InputConfig;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.context.BaseImportContext;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.context.InitJobContextCall;
import org.frameworkset.tran.context.JobContext;
import org.frameworkset.tran.metrics.job.Metrics;
import org.frameworkset.tran.plugin.metrics.output.ETLMetrics;
import org.frameworkset.tran.plugin.metrics.output.MetricsOutputConfig;
import org.frameworkset.tran.record.SplitHandler;
import org.frameworkset.tran.schedule.AutopauseScheduleAssert;
import org.frameworkset.tran.schedule.CallInterceptor;
import org.frameworkset.tran.schedule.ImportIncreamentConfig;
import org.frameworkset.tran.schedule.ScheduleAssert;
import org.frameworkset.tran.schedule.ScheduleConfig;
import org.frameworkset.tran.schedule.WrappedScheduleAssert;
import org.frameworkset.tran.schedule.timer.TimerScheduleConfig;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportBuilder {
    protected InputConfig inputConfig;
    protected OutputConfig outputConfig;
    protected ImportStartAction importStartAction;
    protected ImportEndAction importEndAction;
    private Map jobInputParams;
    private Map jobOutputParams;
    private Map<String, DynamicParam> jobDynamicInputParams;
    private Map<String, DynamicParam> jobDynamicOutputParams;
    protected static Logger logger = LoggerFactory.getLogger(ImportBuilder.class);
    private DBConfig statusDbConfig;
    private String statusDbname;
    private String statusTableDML;
    private Integer fetchSize = 5000;
    private String jobName;
    private String jobId;
    private List<ETLMetrics> metrics;
    private String dataTimeField;
    private boolean useDefaultMapData = true;
    private boolean flushMetricsOnScheduleTaskCompleted;
    private boolean cleanKeysWhenflushMetricsOnScheduleTaskCompleted;
    private boolean waitCompleteWhenflushMetricsOnScheduleTaskCompleted = true;
    private String splitFieldName;
    private transient SplitHandler splitHandler;
    private long flushInterval = 8000L;
    private boolean ignoreNullValueField;
    private Map<String, Object> geoipConfig;
    private boolean sortLastValue = true;
    private boolean useBatchContextIndexName = false;
    private Date scheduleDate;
    private Date scheduleEndDate;
    private Long deyLay;
    private ScheduleConfig scheduleConfig;
    protected ImportIncreamentConfig importIncreamentConfig;
    private boolean externalTimer;
    private boolean printTaskLog = false;
    private transient List<CallInterceptor> callInterceptors;
    private transient List<String> callInterceptorClasses;
    private String applicationPropertiesFile;
    private List<DBConfig> configs;
    private int batchSize = 1000;
    private boolean parallel;
    private int threadCount = 200;
    private int queue = 1000;
    private boolean asyn;
    private boolean continueOnError;
    private Integer increamentEndOffset;
    private boolean asynFlushStatus = true;
    private long asynFlushStatusInterval = 10000L;
    private boolean serialAllData;
    protected long logsendTaskMetric = 10000L;
    private long asynResultPollTimeOut = 1000L;
    private Boolean useLowcase;
    private Integer scheduleBatchSize;
    private Boolean useJavaName;
    protected transient ExportResultHandler exportResultHandler;
    private String exportResultHandlerClass;
    private Map<String, Object> customDBConfigs = new HashMap<String, Object>();
    public static final String DEFAULT_CONFIG_FILE = "application.properties";
    private String geoipDatabase;
    private String geoipAsnDatabase;
    private Object geoipIspConverter;
    private String geoip2regionDatabase;
    private Integer geoipCachesize;
    private DBConfig defaultDBConfig;
    private boolean lastValueColumnSetted = false;
    private String configString;
    private String dateFormat;
    private String locale;
    private String timeZone;
    private final Map<String, FieldMeta> fieldMetaMap = new HashMap<String, FieldMeta>();
    private final List<FieldMeta> fieldValues = new ArrayList<FieldMeta>();
    protected Map<String, FieldMeta> valuesIdxByName = new LinkedHashMap<String, FieldMeta>();
    private transient DataRefactor dataRefactor;
    private transient InitJobContextCall initJobContextCall;
    private String dataRefactorClass;
    private int tranDataBufferQueue = 10;

    public String getDataTimeField() {
        return this.dataTimeField;
    }

    public ImportBuilder setDataTimeField(String dataTimeField) {
        this.dataTimeField = dataTimeField;
        return this;
    }

    public ImportBuilder setImportEndAction(ImportEndAction importEndAction) {
        this.importEndAction = importEndAction;
        return this;
    }

    public ImportEndAction getImportEndAction() {
        return this.importEndAction;
    }

    public List<ETLMetrics> getMetrics() {
        return this.metrics;
    }

    public ImportBuilder setInputConfig(InputConfig inputConfig) {
        this.inputConfig = inputConfig;
        return this;
    }

    public ImportBuilder setImportStartAction(ImportStartAction importStartAction) {
        this.importStartAction = importStartAction;
        return this;
    }

    public ImportStartAction getImportStartAction() {
        return this.importStartAction;
    }

    public ImportBuilder setOutputConfig(OutputConfig outputConfig) {
        this.outputConfig = outputConfig;
        return this;
    }

    public String getSplitFieldName() {
        return this.splitFieldName;
    }

    @Deprecated
    public ImportBuilder addParam(String key, Object value) {
        return this.addJobInputParam(key, value);
    }

    public ImportBuilder addJobInputParam(String key, Object value) {
        if (this.jobInputParams == null) {
            this.jobInputParams = new LinkedHashMap();
        }
        this.jobInputParams.put(key, value);
        return this;
    }

    public ImportBuilder addJobDynamicInputParam(String key, DynamicParam dynamicParam) {
        if (this.jobDynamicInputParams == null) {
            this.jobDynamicInputParams = new LinkedHashMap<String, DynamicParam>();
        }
        this.jobDynamicInputParams.put(key, dynamicParam);
        return this;
    }

    public ImportBuilder addJobOutputParam(String key, Object value) {
        if (this.jobOutputParams == null) {
            this.jobOutputParams = new LinkedHashMap();
        }
        this.jobOutputParams.put(key, value);
        return this;
    }

    public ImportBuilder addJobDynamicOutputParam(String key, DynamicParam dynamicParam) {
        if (this.jobDynamicOutputParams == null) {
            this.jobDynamicOutputParams = new LinkedHashMap<String, DynamicParam>();
        }
        this.jobDynamicOutputParams.put(key, dynamicParam);
        return this;
    }

    public ImportBuilder setSplitFieldName(String splitFieldName) {
        this.splitFieldName = splitFieldName;
        return this;
    }

    public DataTranPlugin buildDataTranPlugin(ImportContext importContext) {
        DataTranPlugin dataTranPlugin = importContext.buildDataTranPlugin();
        return dataTranPlugin;
    }

    public Date getScheduleDate() {
        return this.scheduleDate;
    }

    public ImportBuilder setScheduleDate(Date scheduleDate) {
        this.scheduleDate = scheduleDate;
        return this;
    }

    public Long getDeyLay() {
        return this.deyLay;
    }

    public boolean isExternalTimer() {
        return this.externalTimer;
    }

    protected DataStream createDataStream() {
        return new DataStream();
    }

    public Map<String, Object> getGeoipConfig() {
        return this.geoipConfig;
    }

    public void setStatusTableId(String statusTableId) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setStatusTableId(statusTableId);
    }

    public long getLogsendTaskMetric() {
        return this.logsendTaskMetric;
    }

    public ImportBuilder setLogsendTaskMetric(long logsendTaskMetric) {
        this.logsendTaskMetric = logsendTaskMetric;
        return this;
    }

    public long getAsynResultPollTimeOut() {
        return this.asynResultPollTimeOut;
    }

    public ImportBuilder setAsynResultPollTimeOut(long asynResultPollTimeOut) {
        this.asynResultPollTimeOut = asynResultPollTimeOut;
        return this;
    }

    public ImportBuilder setIncreamentEndOffset(Integer increamentEndOffset) {
        this.increamentEndOffset = increamentEndOffset;
        return this;
    }

    public ImportBuilder setAsynFlushStatus(boolean asynFlushStatus) {
        this.asynFlushStatus = asynFlushStatus;
        return this;
    }

    public Boolean getUseLowcase() {
        return this.useLowcase;
    }

    public ImportBuilder setUseLowcase(Boolean useLowcase) {
        this.useLowcase = useLowcase;
        return this;
    }

    public String getExportResultHandlerClass() {
        return this.exportResultHandlerClass;
    }

    @JsonIgnore
    public ExportResultHandler getExportResultHandler() {
        return this.exportResultHandler;
    }

    public ImportBuilder setExportResultHandler(ExportResultHandler exportResultHandler) {
        this.exportResultHandler = exportResultHandler;
        if (exportResultHandler != null) {
            this.exportResultHandlerClass = exportResultHandler.getClass().getName();
        }
        return this;
    }

    protected void buildGeoipConfig() {
        if (this.geoipDatabase != null) {
            if (this.geoipConfig == null) {
                this.geoipConfig = new HashMap<String, Object>();
            }
            this.geoipConfig.put("ip.database", this.geoipDatabase);
            if (this.geoipAsnDatabase != null) {
                this.geoipConfig.put("ip.asnDatabase", this.geoipAsnDatabase);
            }
            if (this.geoipIspConverter != null) {
                this.geoipConfig.put("ip.ispConverter", this.geoipIspConverter);
            }
            if (this.geoip2regionDatabase != null) {
                this.geoipConfig.put("ip.ip2regionDatabase", this.geoip2regionDatabase);
            }
            if (this.geoipCachesize != null) {
                this.geoipConfig.put("ip.cachesize", this.geoipCachesize + "");
            } else {
                this.geoipConfig.put("ip.cachesize", "10000");
            }
        }
    }

    protected void buildStatusDBConfig() {
        if (this.statusDbname == null) {
            DefaultApplicationContext propertiesContainer = null;
            String prefix = "config.";
            propertiesContainer = DefaultApplicationContext.getApplicationContext((String)"conf/elasticsearch-boot-config.xml", (boolean)false);
            String dbName = propertiesContainer.getExternalProperty(prefix + "db.name");
            if (dbName == null || dbName.equals("")) {
                return;
            }
            this.statusDbConfig = new DBConfig();
            this._buildDBConfig((GetProperties)propertiesContainer, dbName, this.statusDbConfig, "config.");
        } else {
            this.statusDbConfig = new DBConfig();
            this.statusDbConfig.setDbName(this.statusDbname);
            if (this.statusTableDML != null && !this.statusTableDML.equals("")) {
                this.statusDbConfig.setStatusTableDML(this.statusTableDML);
            }
        }
    }

    protected void buildDBConfig() {
        DefaultApplicationContext propertiesContainer = DefaultApplicationContext.getApplicationContext((String)"conf/elasticsearch-boot-config.xml", (boolean)false);
        String dbName = propertiesContainer.getExternalProperty("db.name");
        if (dbName == null || dbName.equals("")) {
            return;
        }
        this.defaultDBConfig = new DBConfig();
        this._buildDBConfig((GetProperties)propertiesContainer, dbName, this.defaultDBConfig, "");
    }

    public DBConfig getDefaultDBConfig() {
        return this.defaultDBConfig;
    }

    protected void buildOtherDBConfigs() {
        DefaultApplicationContext propertiesContainer = DefaultApplicationContext.getApplicationContext((String)"conf/elasticsearch-boot-config.xml", (boolean)false);
        String thirdDatasources = propertiesContainer.getExternalProperty("thirdDatasources");
        if (thirdDatasources == null || thirdDatasources.equals("")) {
            return;
        }
        String[] names = thirdDatasources.split(",");
        ArrayList<DBConfig> dbConfigs = new ArrayList<DBConfig>();
        for (int i = 0; i < names.length; ++i) {
            String prefix = names[i].trim();
            if (prefix.equals("")) continue;
            DBConfig dbConfig = new DBConfig();
            this._buildDBConfig((GetProperties)propertiesContainer, prefix, dbConfig, prefix + ".");
            dbConfigs.add(dbConfig);
        }
        this.configs = dbConfigs;
    }

    protected void _buildDBConfig(GetProperties propertiesContainer, String dbName, DBConfig dbConfig, String prefix) {
        String maxIdleTime;
        String maxWait;
        String connectionTimeout;
        String columnLableUpperCase;
        String _maxSize;
        String _minIdleSize;
        String _initSize;
        String _jdbcFetchSize;
        String _showSql;
        String _usePool;
        if (!this.customDBConfigs.containsKey(prefix + "db.name")) {
            dbConfig.setDbName(dbName);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.user")) {
            String dbUser = propertiesContainer.getExternalProperty(prefix + "db.user");
            dbConfig.setDbUser(dbUser);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.password")) {
            String dbPassword = propertiesContainer.getExternalProperty(prefix + "db.password");
            dbConfig.setDbPassword(dbPassword);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.driver")) {
            String dbDriver = propertiesContainer.getExternalProperty(prefix + "db.driver");
            dbConfig.setDbDriver(dbDriver);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.enableDBTransaction")) {
            boolean enableDBTransaction = propertiesContainer.getExternalBooleanProperty(prefix + "db.enableDBTransaction", false);
            dbConfig.setEnableDBTransaction(enableDBTransaction);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.url")) {
            String dbUrl = propertiesContainer.getExternalProperty(prefix + "db.url");
            dbConfig.setDbUrl(dbUrl);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.usePool") && (_usePool = propertiesContainer.getExternalProperty(prefix + "db.usePool")) != null && !_usePool.equals("")) {
            boolean usePool = Boolean.parseBoolean(_usePool);
            dbConfig.setUsePool(usePool);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.validateSQL")) {
            String validateSQL = propertiesContainer.getExternalProperty(prefix + "db.validateSQL");
            dbConfig.setValidateSQL(validateSQL);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.showsql") && (_showSql = propertiesContainer.getExternalProperty(prefix + "db.showsql")) != null && !_showSql.equals("")) {
            boolean showSql = Boolean.parseBoolean(_showSql);
            dbConfig.setShowSql(showSql);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.jdbcFetchSize") && (_jdbcFetchSize = propertiesContainer.getExternalProperty(prefix + "db.jdbcFetchSize")) != null && !_jdbcFetchSize.equals("")) {
            int jdbcFetchSize = Integer.parseInt(_jdbcFetchSize);
            dbConfig.setJdbcFetchSize(jdbcFetchSize);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.initSize") && (_initSize = propertiesContainer.getExternalProperty(prefix + "db.initSize")) != null && !_initSize.equals("")) {
            int initSize = Integer.parseInt(_initSize);
            dbConfig.setInitSize(initSize);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.minIdleSize") && (_minIdleSize = propertiesContainer.getExternalProperty(prefix + "db.minIdleSize")) != null && !_minIdleSize.equals("")) {
            int minIdleSize = Integer.parseInt(_minIdleSize);
            dbConfig.setMinIdleSize(minIdleSize);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.maxSize") && (_maxSize = propertiesContainer.getExternalProperty(prefix + "db.maxSize")) != null && !_maxSize.equals("")) {
            int maxSize = Integer.parseInt(_maxSize);
            dbConfig.setMaxSize(maxSize);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.statusTableDML")) {
            String statusTableDML = propertiesContainer.getExternalProperty(prefix + "db.statusTableDML");
            dbConfig.setStatusTableDML(statusTableDML);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.dbAdaptor")) {
            String dbAdaptor = propertiesContainer.getExternalProperty(prefix + "db.dbAdaptor");
            dbConfig.setDbAdaptor(dbAdaptor);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.dbtype")) {
            String dbtype = propertiesContainer.getExternalProperty(prefix + "db.dbtype");
            dbConfig.setDbtype(dbtype);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.columnLableUpperCase") && (columnLableUpperCase = propertiesContainer.getExternalProperty(prefix + "db.columnLableUpperCase")) != null) {
            boolean _columnLableUpperCase = Boolean.parseBoolean(columnLableUpperCase);
            dbConfig.setColumnLableUpperCase(_columnLableUpperCase);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.dbInfoEncryptClass")) {
            String dbInfoEncryptClass = propertiesContainer.getExternalProperty(prefix + "db.dbInfoEncryptClass");
            dbConfig.setDbInfoEncryptClass(dbInfoEncryptClass);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.removeAbandoned")) {
            String removeAbandoned = propertiesContainer.getExternalProperty(prefix + "db.removeAbandoned");
            dbConfig.setRemoveAbandoned(removeAbandoned != null && removeAbandoned.equals("true"));
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.connectionTimeout") && (connectionTimeout = propertiesContainer.getExternalProperty(prefix + "db.connectionTimeout")) != null && !connectionTimeout.equals("")) {
            int _connectionTimeout = Integer.parseInt(connectionTimeout);
            dbConfig.setConnectionTimeout(_connectionTimeout);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.maxWait") && (maxWait = propertiesContainer.getExternalProperty(prefix + "db.maxWait")) != null && !maxWait.equals("")) {
            int _maxWait = Integer.parseInt(maxWait);
            dbConfig.setMaxWait(_maxWait);
        }
        if (!this.customDBConfigs.containsKey(prefix + "db.maxIdleTime") && (maxIdleTime = propertiesContainer.getExternalProperty(prefix + "db.maxIdleTime")) != null && !maxIdleTime.equals("")) {
            int _maxIdleTime = Integer.parseInt(maxIdleTime);
            dbConfig.setMaxIdleTime(_maxIdleTime);
        }
    }

    public String getApplicationPropertiesFile() {
        return this.applicationPropertiesFile;
    }

    public void setApplicationPropertiesFile(String applicationPropertiesFile) {
        this.applicationPropertiesFile = applicationPropertiesFile;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public ImportBuilder setParallel(boolean parallel) {
        this.parallel = parallel;
        return this;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public ImportBuilder setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public int getQueue() {
        return this.queue;
    }

    public ImportBuilder setQueue(int queue) {
        this.queue = queue;
        return this;
    }

    public boolean isAsyn() {
        return this.asyn;
    }

    public ImportBuilder setAsyn(boolean asyn) {
        this.asyn = asyn;
        return this;
    }

    public ImportBuilder setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
        return this;
    }

    public ImportBuilder setPeriod(Long period) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setPeriod(period);
        return this;
    }

    public ImportBuilder setScheduleEndDate(Date scheduleEndDate) {
        this.scheduleEndDate = scheduleEndDate;
        return this;
    }

    public ImportBuilder setDeyLay(Long deyLay) {
        this.deyLay = deyLay;
        return this;
    }

    public ImportBuilder setScheduleSelf() {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new TimerScheduleConfig();
        }
        return this;
    }

    public ImportBuilder setFixedRate(Boolean fixedRate) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        } else if (this.scheduleConfig instanceof TimerScheduleConfig) {
            return this;
        }
        this.scheduleConfig.setFixedRate(fixedRate);
        return this;
    }

    public ImportBuilder addSkipScanNewFileTimeRange(String timeRange) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new TimerScheduleConfig();
        } else if (this.scheduleConfig instanceof TimerScheduleConfig) {
            ((TimerScheduleConfig)this.scheduleConfig).addSkipScanNewFileTimeRange(timeRange);
        }
        return this;
    }

    public ImportBuilder addScanNewFileTimeRange(String timeRange) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new TimerScheduleConfig();
        } else if (this.scheduleConfig instanceof TimerScheduleConfig) {
            ((TimerScheduleConfig)this.scheduleConfig).addScanNewFileTimeRange(timeRange);
        }
        return this;
    }

    public ScheduleConfig getScheduleConfig() {
        return this.scheduleConfig;
    }

    public ImportIncreamentConfig getImportIncreamentConfig() {
        return this.importIncreamentConfig;
    }

    @Deprecated
    public ImportBuilder setDateLastValueColumn(String dateLastValueColumn) {
        return this.setLastValueColumn(dateLastValueColumn);
    }

    public ImportBuilder setLastValueColumn(String numberLastValueColumn) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueColumn(numberLastValueColumn);
        this.lastValueColumnSetted = true;
        return this;
    }

    @Deprecated
    public ImportBuilder setNumberLastValueColumn(String numberLastValueColumn) {
        return this.setLastValueColumn(numberLastValueColumn);
    }

    public ImportBuilder setLastValueStorePath(String lastValueStorePath) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueStorePath(lastValueStorePath);
        return this;
    }

    public ImportBuilder setLastValueStoreTableName(String lastValueStoreTableName) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueStoreTableName(lastValueStoreTableName);
        return this;
    }

    public ImportBuilder setFromFirst(boolean fromFirst) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setFromFirst(fromFirst);
        return this;
    }

    public ImportBuilder setLastValue(Object lastValue) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValue(lastValue);
        return this;
    }

    public ImportBuilder setLastValueType(int lastValueType) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueType(lastValueType);
        return this;
    }

    public ImportBuilder setLastValueDateformat(String lastValueDateformat) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueDateformat(lastValueDateformat);
        return this;
    }

    public Integer getScheduleBatchSize() {
        return this.scheduleBatchSize;
    }

    public ImportBuilder setScheduleBatchSize(Integer scheduleBatchSize) {
        this.scheduleBatchSize = scheduleBatchSize;
        return this;
    }

    public ImportBuilder addCallInterceptor(CallInterceptor interceptor) {
        if (this.callInterceptors == null) {
            this.callInterceptors = new ArrayList<CallInterceptor>();
            this.callInterceptorClasses = new ArrayList<String>();
        }
        this.callInterceptors.add(interceptor);
        this.callInterceptorClasses.add(interceptor.getClass().getName());
        return this;
    }

    public ImportBuilder addCallInterceptor(CallInterceptor interceptor, boolean firsted) {
        if (this.callInterceptors == null) {
            this.callInterceptors = new ArrayList<CallInterceptor>();
            this.callInterceptorClasses = new ArrayList<String>();
        }
        if (!firsted) {
            this.callInterceptors.add(interceptor);
            this.callInterceptorClasses.add(interceptor.getClass().getName());
        } else {
            this.callInterceptors.add(0, interceptor);
            this.callInterceptorClasses.add(0, interceptor.getClass().getName());
        }
        return this;
    }

    public boolean isPrintTaskLog() {
        return this.printTaskLog;
    }

    public ImportBuilder setPrintTaskLog(boolean printTaskLog) {
        this.printTaskLog = printTaskLog;
        return this;
    }

    public String toString() {
        if (this.configString != null) {
            return this.configString;
        }
        try {
            StringBuilder ret = new StringBuilder();
            ret.append("parallel=").append(this.parallel);
            if (this.scheduleConfig != null) {
                ret.append(",scheduleConfig=").append(this.scheduleConfig.toString());
            }
            if (this.importIncreamentConfig != null) {
                ret.append(",importIncreamentConfig=").append(this.importIncreamentConfig.toString());
            }
            if (this.geoipConfig != null) {
                ret.append(",geoipConfig=").append(this.geoipConfig);
            }
            ret.append(",useJavaName=").append(this.useJavaName);
            ret.append(",useLowcase=").append(this.useLowcase);
            ret.append(",fetchSize=").append(this.fetchSize);
            ret.append(",batchSize=").append(this.batchSize);
            ret.append(",continueOnError=").append(this.continueOnError);
            ret.append(",flushInterval=").append(this.flushInterval);
            ret.append(",asynFlushStatus=").append(this.asynFlushStatus);
            ret.append(",asynFlushStatusInterval=").append(this.asynFlushStatusInterval);
            ret.append(",asyn=").append(this.asyn);
            ret.append(",statusDbname=").append(this.statusDbname);
            ret.append(",statusTableDML=").append(this.statusTableDML);
            if (this.splitHandler != null) {
                ret.append(",splitHandler=" + this.splitHandler.getClass().getCanonicalName());
            } else {
                ret.append(",splitHandler=null");
            }
            if (this.dataRefactor != null) {
                ret.append(",dataRefactor=" + this.dataRefactor.getClass().getCanonicalName());
            } else {
                ret.append(",dataRefactor=null");
            }
            if (this.exportResultHandler != null) {
                ret.append(",exportResultHandler=" + this.exportResultHandler.getClass().getCanonicalName());
            } else {
                ret.append(",exportResultHandler=null");
            }
            if (this.callInterceptorClasses != null) {
                ret.append(",callInterceptorClasses=" + this.callInterceptorClasses);
            } else {
                ret.append(",callInterceptorClasses=null");
            }
            this.configString = ret.toString();
            return this.configString;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.configString = "";
            return this.configString;
        }
    }

    public List<DBConfig> getConfigs() {
        return this.configs;
    }

    public static FieldMeta addFieldValue(List<FieldMeta> fieldValues, String fieldName, Object value) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setTargetFieldName(fieldName);
        fieldMeta.setValue(value);
        fieldValues.add(fieldMeta);
        return fieldMeta;
    }

    public static FieldMeta addFieldValue(List<FieldMeta> fieldValues, String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setTargetFieldName(fieldName);
        fieldMeta.setValue(value);
        fieldMeta.setDateFormateMeta(ImportBuilder.buildDateFormateMeta(dateFormat, locale, timeZone));
        fieldValues.add(fieldMeta);
        return fieldMeta;
    }

    public ImportBuilder setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public ImportBuilder setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public ImportBuilder setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public DateFormateMeta buildDateFormateMeta(String dateFormat) {
        return dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)this.locale, (String)this.timeZone);
    }

    public static DateFormateMeta buildDateFormateMeta(String dateFormat, String locale, String timeZone) {
        return dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)locale, (String)timeZone);
    }

    private FieldMeta buildFieldMeta(String sourceFieldName, String targetFieldName, String dateFormat) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setSourceFieldName(sourceFieldName);
        fieldMeta.setTargetFieldName(targetFieldName);
        fieldMeta.setIgnore(false);
        fieldMeta.setDateFormateMeta(dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)this.locale, (String)this.timeZone));
        return fieldMeta;
    }

    private static FieldMeta buildIgnoreFieldMeta(String sourceFieldName) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setSourceFieldName(sourceFieldName);
        fieldMeta.setIgnore(true);
        return fieldMeta;
    }

    private FieldMeta buildFieldMeta(String sourceFieldName, String targetFieldName, String dateFormat, String locale, String timeZone) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setSourceFieldName(sourceFieldName);
        fieldMeta.setTargetFieldName(targetFieldName);
        fieldMeta.setIgnore(false);
        fieldMeta.setDateFormateMeta(dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)locale, (String)timeZone));
        return fieldMeta;
    }

    public ImportBuilder addFieldMapping(String sourceFieldName, String targetFieldName) {
        this.fieldMetaMap.put(sourceFieldName, this.buildFieldMeta(sourceFieldName, targetFieldName, null));
        return this;
    }

    public ImportBuilder addIgnoreFieldMapping(String sourceFieldName) {
        ImportBuilder.addIgnoreFieldMapping(this.fieldMetaMap, sourceFieldName);
        return this;
    }

    public static void addIgnoreFieldMapping(Map<String, FieldMeta> fieldMetaMap, String sourceColumnName) {
        fieldMetaMap.put(sourceColumnName, ImportBuilder.buildIgnoreFieldMeta(sourceColumnName));
    }

    public ImportBuilder addFieldMapping(String sourceColumnName, String targetFieldName, String dateFormat) {
        this.fieldMetaMap.put(sourceColumnName, this.buildFieldMeta(sourceColumnName, targetFieldName, dateFormat));
        return this;
    }

    public ImportBuilder addFieldMapping(String sourceColumnName, String targetFieldName, String dateFormat, String locale, String timeZone) {
        this.fieldMetaMap.put(sourceColumnName, this.buildFieldMeta(sourceColumnName, targetFieldName, dateFormat, locale, timeZone));
        return this;
    }

    public ImportBuilder addFieldValue(String fieldName, Object value) {
        FieldMeta fieldMeta = ImportBuilder.addFieldValue(this.fieldValues, fieldName, value);
        this.valuesIdxByName.put(fieldName, fieldMeta);
        return this;
    }

    public ImportBuilder addFieldValue(String fieldName, String dateFormat, Object value) {
        FieldMeta fieldMeta = ImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, this.locale, this.timeZone);
        this.valuesIdxByName.put(fieldName, fieldMeta);
        return this;
    }

    public ImportBuilder addFieldValue(String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        FieldMeta fieldMeta = ImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, locale, timeZone);
        this.valuesIdxByName.put(fieldName, fieldMeta);
        return this;
    }

    public String getDataRefactorClass() {
        return this.dataRefactorClass;
    }

    public ImportBuilder setDataRefactor(DataRefactor dataRefactor) {
        this.dataRefactor = dataRefactor;
        this.dataRefactorClass = dataRefactor.getClass().getName();
        return this;
    }

    public ImportBuilder setExternalTimer(boolean externalTimer) {
        this.externalTimer = externalTimer;
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setExternalTimer(externalTimer);
        return this;
    }

    public static void main(String[] args) {
        logger.info("meta:_id".substring(5));
    }

    private void initMetrics(BaseImportConfig baseImportConfig) {
        if (this.metrics != null && this.metrics.size() > 0) {
            if (this.outputConfig != null && this.outputConfig instanceof MetricsOutputConfig) {
                throw new DataImportException("\u6307\u6807\u8f93\u51fa\u63d2\u4ef6\u4e0d\u652f\u6301\u4f5c\u4e1a\u7ea7\u522b\u6307\u6807\u8ba1\u7b97\u5668\uff0c\u4e0d\u80fd\u4eceimportbuilder\u8bbe\u7f6emetrics\uff01");
            }
            for (Metrics metrics : this.metrics) {
                metrics.init();
            }
            baseImportConfig.setMetrics(this.metrics);
            baseImportConfig.setDataTimeField(this.dataTimeField);
            baseImportConfig.setUseDefaultMapData(this.useDefaultMapData);
        }
        if (this.flushMetricsOnScheduleTaskCompleted) {
            baseImportConfig.setFlushMetricsOnScheduleTaskCompleted(true);
            baseImportConfig.setCleanKeysWhenflushMetricsOnScheduleTaskCompleted(this.cleanKeysWhenflushMetricsOnScheduleTaskCompleted);
            baseImportConfig.setWaitCompleteWhenflushMetricsOnScheduleTaskCompleted(this.waitCompleteWhenflushMetricsOnScheduleTaskCompleted);
        }
    }

    protected void buildImportConfig(BaseImportConfig baseImportConfig) {
        baseImportConfig.setImportStartAction(this.importStartAction);
        baseImportConfig.setImportEndAction(this.importEndAction);
        baseImportConfig.setUseJavaName(false);
        this.initMetrics(baseImportConfig);
        baseImportConfig.setJobInputParams(this.jobInputParams);
        baseImportConfig.setJobOutputParams(this.jobOutputParams);
        baseImportConfig.setJobDynamicInputParams(this.jobDynamicInputParams);
        baseImportConfig.setJobDynamicOutputParams(this.jobDynamicOutputParams);
        baseImportConfig.setLastValueColumnSetted(this.lastValueColumnSetted);
        if (this.geoipConfig != null && this.geoipConfig.size() > 0) {
            baseImportConfig.setGeoipConfig(this.geoipConfig);
        }
        baseImportConfig.setDateFormat(this.dateFormat);
        baseImportConfig.setLocale(this.locale);
        baseImportConfig.setTimeZone(this.timeZone);
        baseImportConfig.setFetchSize(this.fetchSize);
        baseImportConfig.setUseJavaName(this.useJavaName);
        baseImportConfig.setFieldMetaMap(this.fieldMetaMap);
        baseImportConfig.setFieldValues(this.fieldValues);
        baseImportConfig.setValuesIdxByName(this.valuesIdxByName);
        baseImportConfig.setDataRefactor(this.dataRefactor);
        baseImportConfig.setSortLastValue(this.sortLastValue);
        baseImportConfig.setStatusDbConfig(this.statusDbConfig);
        baseImportConfig.setConfigs(this.configs);
        baseImportConfig.setBatchSize(this.batchSize);
        baseImportConfig.setDefaultDBConfig(this.defaultDBConfig);
        baseImportConfig.setApplicationPropertiesFile(this.applicationPropertiesFile);
        baseImportConfig.setParallel(this.parallel);
        baseImportConfig.setThreadCount(this.threadCount);
        baseImportConfig.setQueue(this.queue);
        baseImportConfig.setAsyn(this.asyn);
        baseImportConfig.setContinueOnError(this.continueOnError);
        baseImportConfig.setAsynResultPollTimeOut(this.asynResultPollTimeOut);
        baseImportConfig.setScheduleConfig(this.scheduleConfig);
        baseImportConfig.setImportIncreamentConfig(this.importIncreamentConfig);
        if (this.scheduleBatchSize != null) {
            baseImportConfig.setScheduleBatchSize(this.scheduleBatchSize);
        } else {
            baseImportConfig.setScheduleBatchSize(this.batchSize);
        }
        baseImportConfig.setCallInterceptors(this.callInterceptors);
        baseImportConfig.setUseLowcase(this.useLowcase);
        baseImportConfig.setPrintTaskLog(this.printTaskLog);
        baseImportConfig.setTranDataBufferQueue(this.tranDataBufferQueue);
        baseImportConfig.setFlushInterval(this.flushInterval);
        baseImportConfig.setIgnoreNullValueField(this.ignoreNullValueField);
        baseImportConfig.setIncreamentEndOffset(this.increamentEndOffset);
        baseImportConfig.setAsynFlushStatus(this.asynFlushStatus);
        baseImportConfig.setAsynFlushStatusInterval(this.asynFlushStatusInterval);
        baseImportConfig.setSerialAllData(this.serialAllData);
        baseImportConfig.setLogsendTaskMetric(this.logsendTaskMetric);
        baseImportConfig.setSplitHandler(this.getSplitHandler());
        baseImportConfig.setSplitFieldName(this.getSplitFieldName());
        baseImportConfig.setDeyLay(this.deyLay);
        baseImportConfig.setScheduleDate(this.scheduleDate);
        baseImportConfig.setScheduleEndDate(this.scheduleEndDate);
        if (this.jobId != null) {
            baseImportConfig.setJobId(this.jobId);
        }
        if (this.jobName != null) {
            baseImportConfig.setJobName(this.jobName);
        } else if (baseImportConfig.getJobId() != null) {
            baseImportConfig.setJobName("Datatran-Job-" + baseImportConfig.getJobId());
        } else {
            baseImportConfig.setJobName("Datatran-Job");
        }
    }

    public ImportBuilder setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public Boolean getUseJavaName() {
        return this.useJavaName;
    }

    public ImportBuilder setUseJavaName(Boolean useJavaName) {
        this.useJavaName = useJavaName;
        return this;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public ImportBuilder setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    private JobContext initJobcontext() {
        JobContext jobContext = new JobContext();
        if (this.initJobContextCall != null) {
            try {
                this.initJobContextCall.initJobContext(jobContext);
            }
            catch (Exception e) {
                throw new DataImportException(e);
            }
        }
        return jobContext;
    }

    protected DataStream innerBuilder() {
        JobContext jobContext = this.initJobcontext();
        this.buildGeoipConfig();
        this.buildDBConfig();
        this.buildOtherDBConfigs();
        this.buildStatusDBConfig();
        try {
            if (logger.isInfoEnabled()) {
                logger.info("Import Configs:");
                logger.info(this.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        BaseImportContext importContext = new BaseImportContext();
        importContext.setJobContext(jobContext);
        BaseImportConfig baseImportConfig = new BaseImportConfig();
        this.buildImportConfig(baseImportConfig);
        importContext.setBaseImportConfig(baseImportConfig);
        this.inputConfig.build(this);
        this.outputConfig.build(this);
        importContext.setInputConfig(this.inputConfig);
        importContext.setOutputConfig(this.outputConfig);
        if (this.exportResultHandler != null) {
            baseImportConfig.setExportResultHandler(this.outputConfig.buildExportResultHandler(this.exportResultHandler));
        }
        importContext.afterBuild(this);
        final DataStream dataStream = this.createDataStream();
        dataStream.setImportContext(importContext);
        dataStream.setDataTranPlugin(this.buildDataTranPlugin(importContext));
        dataStream.initDatastream();
        importContext.registEndAction(new EndAction(){

            @Override
            public void endAction() {
                dataStream.endAction(null);
            }
        });
        return dataStream;
    }

    public static ImportBuilder newInstance() {
        return new ImportBuilder();
    }

    public DataStream builder() {
        return this.builder(false);
    }

    public DataStream builder(boolean enableSchdulePause) {
        AutopauseScheduleAssert scheduleAssert = null;
        if (enableSchdulePause) {
            if (logger.isInfoEnabled()) {
                logger.info("Use AutopauseScheduleAssert.");
            }
            scheduleAssert = new AutopauseScheduleAssert();
        }
        return this.builder(scheduleAssert);
    }

    public DataStream builder(ScheduleAssert scheduleAssert) {
        if (this.inputConfig == null) {
            throw new DataImportException("InputConfig is null and must be set to ImportBuilder.");
        }
        if (this.outputConfig == null) {
            throw new DataImportException("OutputConfig is null and must be set to ImportBuilder.");
        }
        DataStream dataStream = this.innerBuilder();
        if (scheduleAssert != null) {
            if (scheduleAssert instanceof WrappedScheduleAssert) {
                dataStream.setScheduleAssert(scheduleAssert);
            } else {
                dataStream.setScheduleAssert(new WrappedScheduleAssert(scheduleAssert));
            }
        }
        return dataStream;
    }

    public ImportBuilder setTranDataBufferQueue(int tranDataBufferQueue) {
        this.tranDataBufferQueue = tranDataBufferQueue;
        return this;
    }

    public long getFlushInterval() {
        return this.flushInterval;
    }

    public ImportBuilder setFlushInterval(long flushInterval) {
        this.flushInterval = flushInterval;
        return this;
    }

    public boolean isIgnoreNullValueField() {
        return this.ignoreNullValueField;
    }

    public ImportBuilder setIgnoreNullValueField(boolean ignoreNullValueField) {
        this.ignoreNullValueField = ignoreNullValueField;
        return this;
    }

    public boolean isSortLastValue() {
        return this.sortLastValue;
    }

    public ImportBuilder setSortLastValue(boolean sortLastValue) {
        this.sortLastValue = sortLastValue;
        return this;
    }

    public boolean isUseBatchContextIndexName() {
        return this.useBatchContextIndexName;
    }

    public ImportBuilder setUseBatchContextIndexName(boolean useBatchContextIndexName) {
        this.useBatchContextIndexName = useBatchContextIndexName;
        return this;
    }

    public ImportBuilder setGeoipDatabase(String geoipDatabase) {
        this.geoipDatabase = geoipDatabase;
        return this;
    }

    public ImportBuilder setGeoipAsnDatabase(String geoipAsnDatabase) {
        this.geoipAsnDatabase = geoipAsnDatabase;
        return this;
    }

    public ImportBuilder setGeoip2regionDatabase(String geoip2regionDatabase) {
        this.geoip2regionDatabase = geoip2regionDatabase;
        return this;
    }

    public ImportBuilder setGeoipCachesize(int geoipCachesize) {
        this.geoipCachesize = geoipCachesize;
        return this;
    }

    public String getStatusDbname() {
        return this.statusDbname;
    }

    public ImportBuilder setStatusDbname(String statusDbname) {
        this.statusDbname = statusDbname;
        return this;
    }

    public String getStatusTableDML() {
        return this.statusTableDML;
    }

    public ImportBuilder setStatusTableDML(String statusTableDML) {
        this.statusTableDML = statusTableDML;
        return this;
    }

    public ImportBuilder setGeoipIspConverter(Object geoipIspConverter) {
        this.geoipIspConverter = geoipIspConverter;
        return this;
    }

    public long getAsynFlushStatusInterval() {
        return this.asynFlushStatusInterval;
    }

    public ImportBuilder setAsynFlushStatusInterval(long asynFlushStatusInterval) {
        this.asynFlushStatusInterval = asynFlushStatusInterval;
        return this;
    }

    @JsonIgnore
    public SplitHandler getSplitHandler() {
        return this.splitHandler;
    }

    public ImportBuilder setSplitHandler(SplitHandler splitHandler) {
        this.splitHandler = splitHandler;
        return this;
    }

    public boolean isSerialAllData() {
        return this.serialAllData;
    }

    public ImportBuilder setSerialAllData(boolean serialAllData) {
        this.serialAllData = serialAllData;
        return this;
    }

    public ImportBuilder setJobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobId() {
        return this.jobId;
    }

    public ImportBuilder setJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public ImportBuilder setInitJobContextCall(InitJobContextCall initJobContextCall) {
        this.initJobContextCall = initJobContextCall;
        return this;
    }

    public ImportBuilder addMetrics(ETLMetrics metrics) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<ETLMetrics>();
        }
        this.metrics.add(metrics);
        return this;
    }

    public ImportBuilder setUseDefaultMapData(boolean useDefaultMapData) {
        this.useDefaultMapData = useDefaultMapData;
        return this;
    }

    public ImportBuilder setFlushMetricsOnScheduleTaskCompleted(boolean flushMetricsOnScheduleTaskCompleted) {
        this.flushMetricsOnScheduleTaskCompleted = flushMetricsOnScheduleTaskCompleted;
        return this;
    }

    public ImportBuilder setCleanKeysWhenflushMetricsOnScheduleTaskCompleted(boolean cleanKeysWhenflushMetricsOnScheduleTaskCompleted) {
        this.cleanKeysWhenflushMetricsOnScheduleTaskCompleted = cleanKeysWhenflushMetricsOnScheduleTaskCompleted;
        return this;
    }

    public ImportBuilder setWaitCompleteWhenflushMetricsOnScheduleTaskCompleted(boolean waitCompleteWhenflushMetricsOnScheduleTaskCompleted) {
        this.waitCompleteWhenflushMetricsOnScheduleTaskCompleted = waitCompleteWhenflushMetricsOnScheduleTaskCompleted;
        return this;
    }

    public List<CallInterceptor> taskCallInterceptors() {
        return this.callInterceptors;
    }
}

