/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import com.frameworkset.common.poolman.util.DBConf;
import com.frameworkset.common.poolman.util.DBStartResult;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.orm.annotation.BatchContext;
import com.frameworkset.util.SimpleStringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.ExportCount;
import org.frameworkset.tran.JobCountDownLatch;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.config.DynamicParam;
import org.frameworkset.tran.config.DynamicParamContext;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.InputPlugin;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.plugin.metrics.output.ETLMetrics;
import org.frameworkset.tran.schedule.AfterCallException;
import org.frameworkset.tran.schedule.CallInterceptor;
import org.frameworkset.tran.schedule.PreCallException;
import org.frameworkset.tran.schedule.ScheduleAssert;
import org.frameworkset.tran.schedule.ScheduleEndCall;
import org.frameworkset.tran.schedule.ScheduleService;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.status.DefaultStatusManager;
import org.frameworkset.tran.status.InitLastValueClumnName;
import org.frameworkset.tran.status.LoadCurrentStatus;
import org.frameworkset.tran.status.SetLastValueType;
import org.frameworkset.tran.status.SingleStatusManager;
import org.frameworkset.tran.status.StatusManager;
import org.frameworkset.tran.util.TranUtil;
import org.frameworkset.util.ResourceEnd;
import org.frameworkset.util.ResourceStart;
import org.frameworkset.util.ResourceStartResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTranPluginImpl
implements DataTranPlugin {
    protected static Logger logger = LoggerFactory.getLogger(DataTranPluginImpl.class);
    protected InputPlugin inputPlugin;
    protected OutputPlugin outputPlugin;
    private ExportCount exportCount;
    protected StatusManager statusManager;
    protected ScheduleAssert scheduleAssert;
    protected DBStartResult dbStartResult = new DBStartResult();
    protected ImportContext importContext;
    protected ScheduleService scheduleService;
    protected Thread delayThread;
    protected Thread scheduledEndThread;
    protected boolean initOtherDSes;
    protected boolean initDefaultDS;
    protected volatile int status = 0;
    protected volatile boolean hasTran = false;
    private ReentrantLock lock = new ReentrantLock();
    private AtomicInteger tranCounts = new AtomicInteger(0);
    private TranErrorWrapper errorWrapper;
    private volatile boolean forceStop = false;
    private List<ResourceStartResult> resourceStartResults;

    @Override
    public ExportCount getExportCount() {
        return this.exportCount;
    }

    @Override
    public boolean useFilePointer() {
        return false;
    }

    @Override
    public InputPlugin getInputPlugin() {
        return this.inputPlugin;
    }

    @Override
    public OutputPlugin getOutputPlugin() {
        return this.outputPlugin;
    }

    @Override
    public ScheduleAssert getScheduleAssert() {
        return this.scheduleAssert;
    }

    @Override
    public void setScheduleAssert(ScheduleAssert scheduleAssert) {
        this.scheduleAssert = scheduleAssert;
    }

    @Override
    public Map getJobInputParams(TaskContext taskContext) {
        Map<String, DynamicParam> dynamicParams;
        Map _params = this.importContext.getJobInputParams();
        HashMap params = new HashMap();
        if (_params != null && _params.size() > 0) {
            params.putAll(_params);
        }
        if ((dynamicParams = this.importContext.getJobDynamicOutputParams()) == null || dynamicParams.size() == 0) {
            return params;
        }
        Iterator<Map.Entry<String, DynamicParam>> iterator = dynamicParams.entrySet().iterator();
        DynamicParamContext dynamicParamContext = new DynamicParamContext();
        dynamicParamContext.setImportContext(this.importContext);
        dynamicParamContext.setTaskContext(taskContext);
        while (iterator.hasNext()) {
            Map.Entry<String, DynamicParam> entry = iterator.next();
            Object value = null;
            try {
                value = entry.getValue().getValue(entry.getKey(), dynamicParamContext);
            }
            catch (DataImportException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataImportException("get value of " + entry.getKey() + " failed:", e);
            }
            if (value == null) continue;
            params.put(entry.getKey(), value);
        }
        return params;
    }

    @Override
    public Map getJobInputParams(DynamicParamContext dynamicParamContext) {
        Map<String, DynamicParam> dynamicParams;
        Map _params = this.importContext.getJobInputParams();
        HashMap params = new HashMap();
        if (_params != null && _params.size() > 0) {
            params.putAll(_params);
        }
        if ((dynamicParams = this.importContext.getJobDynamicOutputParams()) == null || dynamicParams.size() == 0) {
            return params;
        }
        for (Map.Entry<String, DynamicParam> entry : dynamicParams.entrySet()) {
            Object value = null;
            try {
                value = entry.getValue().getValue(entry.getKey(), dynamicParamContext);
            }
            catch (DataImportException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataImportException("get value of " + entry.getKey() + " failed:", e);
            }
            if (value == null) continue;
            params.put(entry.getKey(), value);
        }
        return params;
    }

    @Override
    public Map getJobOutputParams(TaskContext taskContext) {
        Map<String, DynamicParam> dynamicParams;
        Map _params = this.importContext.getJobOutputParams();
        HashMap params = new HashMap();
        if (_params != null && _params.size() > 0) {
            params.putAll(_params);
        }
        if ((dynamicParams = this.importContext.getJobDynamicOutputParams()) == null || dynamicParams.size() == 0) {
            return params;
        }
        Iterator<Map.Entry<String, DynamicParam>> iterator = dynamicParams.entrySet().iterator();
        DynamicParamContext dynamicParamContext = new DynamicParamContext();
        dynamicParamContext.setImportContext(this.importContext);
        dynamicParamContext.setTaskContext(taskContext);
        while (iterator.hasNext()) {
            Map.Entry<String, DynamicParam> entry = iterator.next();
            Object value = null;
            try {
                value = entry.getValue().getValue(entry.getKey(), dynamicParamContext);
            }
            catch (DataImportException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataImportException("get value of " + entry.getKey() + " failed:", e);
            }
            if (value == null) continue;
            params.put(entry.getKey(), value);
        }
        return params;
    }

    @Override
    public Map getJobOutputParams(DynamicParamContext dynamicParamContext) {
        Map<String, DynamicParam> dynamicParams;
        Map _params = this.importContext.getJobOutputParams();
        HashMap params = new HashMap();
        if (_params != null && _params.size() > 0) {
            params.putAll(_params);
        }
        if ((dynamicParams = this.importContext.getJobDynamicOutputParams()) == null || dynamicParams.size() == 0) {
            return params;
        }
        for (Map.Entry<String, DynamicParam> entry : dynamicParams.entrySet()) {
            Object value = null;
            try {
                value = entry.getValue().getValue(entry.getKey(), dynamicParamContext);
            }
            catch (DataImportException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataImportException("get value of " + entry.getKey() + " failed:", e);
            }
            if (value == null) continue;
            params.put(entry.getKey(), value);
        }
        return params;
    }

    @Override
    public boolean isSchedulePaussed(boolean autoPause) {
        if (this.scheduleAssert != null) {
            return !this.scheduleAssert.assertSchedule(autoPause);
        }
        return false;
    }

    @Override
    public BaseDataTran createBaseDataTran(TaskContext taskContext, TranResultSet tranResultSet, JobCountDownLatch countDownLatch, Status currentStatus) {
        return this.outputPlugin.createBaseDataTran(taskContext, tranResultSet, countDownLatch, currentStatus);
    }

    @Override
    public void doImportData(TaskContext taskContext) {
        this.inputPlugin.doImportData(taskContext);
    }

    @Override
    public void addStatus(Status currentStatus) throws DataImportException {
        this.statusManager.addStatus(currentStatus);
    }

    public boolean isComplete(Status status) {
        return status.getStatus() == 1;
    }

    public boolean isLostFile(Status status) {
        return status.getStatus() == 2;
    }

    @Override
    public Context buildContext(TaskContext taskContext, TranResultSet tranResultSet, BatchContext batchContext) {
        return this.inputPlugin.buildContext(taskContext, tranResultSet, batchContext);
    }

    @Override
    public String getLastValueVarName() {
        return this.inputPlugin.getLastValueVarName();
    }

    @Override
    public Long getTimeRangeLastValue() {
        return this.inputPlugin.getTimeRangeLastValue();
    }

    public DataTranPluginImpl(ImportContext importContext) {
        this.importContext = importContext;
        importContext.setDataTranPlugin(this);
    }

    @Override
    public ImportContext getImportContext() {
        return this.importContext;
    }

    @Override
    public void setImportContext(ImportContext importContext) {
        this.importContext = importContext;
    }

    protected boolean isPrintTaskLog() {
        return this.importContext.isPrintTaskLog() && logger.isInfoEnabled();
    }

    @Override
    public void preCall(TaskContext taskContext) {
        List<CallInterceptor> callInterceptors = this.importContext.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            return;
        }
        for (CallInterceptor callInterceptor : callInterceptors) {
            try {
                callInterceptor.preCall(taskContext);
            }
            catch (DataImportException e) {
                throw new PreCallException(e);
            }
            catch (Exception e) {
                throw new PreCallException(e);
            }
        }
        TranUtil.initTaskContextSQLInfo(taskContext, this.importContext);
    }

    @Override
    public void afterCall(TaskContext taskContext) {
        List<CallInterceptor> callInterceptors = this.importContext.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            return;
        }
        CallInterceptor callInterceptor = null;
        for (int j = callInterceptors.size() - 1; j >= 0; --j) {
            callInterceptor = callInterceptors.get(j);
            try {
                callInterceptor.afterCall(taskContext);
                continue;
            }
            catch (Exception e) {
                logger.error("afterCall failed:", (Throwable)e);
                this.throwException(taskContext, new AfterCallException("afterCall failed:", e));
            }
        }
    }

    @Override
    public void throwException(TaskContext taskContext, Throwable e) {
        List<CallInterceptor> callInterceptors = this.importContext.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            return;
        }
        CallInterceptor callInterceptor = null;
        for (int j = callInterceptors.size() - 1; j >= 0; --j) {
            callInterceptor = callInterceptors.get(j);
            try {
                callInterceptor.throwException(taskContext, e);
                continue;
            }
            catch (Exception e1) {
                logger.error("afterCall failed:", (Throwable)e1);
            }
        }
    }

    @Override
    public boolean isEnableAutoPauseScheduled() {
        return true;
    }

    protected void delay() {
        Long deyLay = this.importContext.getDeyLay();
        Date date = this.importContext.getScheduleDate();
        long _delay = 0L;
        if (date != null) {
            _delay = date.getTime() - System.currentTimeMillis();
        } else if (deyLay != null && deyLay > 0L) {
            _delay = deyLay;
        }
        final long tmp = _delay;
        if (tmp > 0L) {
            this.delayThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(tmp);
                    }
                    catch (InterruptedException e) {
                        logger.info("job delay is interrupted.");
                    }
                }
            }, "Datatran-DelayThread");
            this.delayThread.start();
            try {
                this.delayThread.join();
            }
            catch (InterruptedException e) {
                logger.info("job delay join is interrupted.");
            }
            this.delayThread = null;
        }
    }

    @Override
    public void importData(final ScheduleEndCall scheduleEndCall) throws DataImportException {
        if (this.scheduleService == null) {
            this.delay();
            if (this.status == 5 || this.status == 2) {
                return;
            }
            long importStartTime = System.currentTimeMillis();
            TaskContext taskContext = this.inputPlugin.isEnablePluginTaskIntercept() ? new TaskContext(this.importContext) : null;
            try {
                if (this.inputPlugin.isEnablePluginTaskIntercept()) {
                    this.preCall(taskContext);
                }
                this.inputPlugin.doImportData(taskContext);
                if (this.inputPlugin.isEnablePluginTaskIntercept()) {
                    this.afterCall(taskContext);
                }
                long importEndTime = System.currentTimeMillis();
                if (this.isPrintTaskLog()) {
                    logger.info("Execute job Take " + (importEndTime - importStartTime) + " ms");
                }
            }
            catch (Exception e) {
                if (this.inputPlugin.isEnablePluginTaskIntercept()) {
                    this.throwException(taskContext, e);
                }
                logger.error("scheduleImportData failed:", (Throwable)e);
            }
        } else {
            try {
                if (!this.importContext.isExternalTimer()) {
                    Date scheduleEndDate = this.importContext.getScheduleEndDate();
                    Date now = new Date();
                    if (scheduleEndDate != null && now.after(scheduleEndDate)) {
                        logger.info("Job scheduleEndDate reached,Ignore schedule this job.");
                        return;
                    }
                    boolean scheduled = this.scheduleService.timeSchedule();
                    if (scheduled && scheduleEndDate != null) {
                        final long waitTime = scheduleEndDate.getTime() - System.currentTimeMillis();
                        this.scheduledEndThread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                if (waitTime > 0L) {
                                    try {
                                        Thread.sleep(waitTime);
                                        scheduleEndCall.call();
                                    }
                                    catch (InterruptedException interruptedException) {}
                                } else {
                                    scheduleEndCall.call();
                                }
                            }
                        }, "Datatran-ScheduledEndThread");
                        this.scheduledEndThread.start();
                    }
                } else {
                    if (this.scheduleService.isSchedulePaused(this.isEnableAutoPauseScheduled())) {
                        if (logger.isInfoEnabled()) {
                            logger.info("Ignore  Paussed Schedule Task,waiting for next resume schedule sign to continue.");
                        }
                        return;
                    }
                    this.scheduleService.externalTimeSchedule();
                }
            }
            catch (DataImportException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataImportException(e);
            }
        }
    }

    public void beforeInit() {
        this.inputPlugin.beforeInit();
        this.outputPlugin.beforeInit();
    }

    @Override
    public void initStatusTableId() {
        this.inputPlugin.initStatusTableId();
    }

    @Override
    public void loadCurrentStatus(List<Status> statuses) {
    }

    @Override
    public String getJobType() {
        return this.inputPlugin.getJobType();
    }

    @Override
    public LoadCurrentStatus getLoadCurrentStatus() {
        return this.statusManager.getLoadCurrentStatus();
    }

    protected void initStatusManager() {
        this.statusManager = new SingleStatusManager(this);
    }

    private void _initStatusManager() {
        if (this.importContext.isAsynFlushStatus()) {
            this.initStatusManager();
        } else {
            this.statusManager = new DefaultStatusManager(this);
        }
        this.statusManager.initTableAndStatus(this.getInitLastValueClumnName());
    }

    protected InitLastValueClumnName getInitLastValueClumnName() {
        return new InitLastValueClumnName(){

            @Override
            public void initLastValueClumnName() {
                DataTranPluginImpl.this.statusManager.initLastValueClumnName();
            }
        };
    }

    @Override
    public SetLastValueType getSetLastValueType() {
        return new SetLastValueType(){

            @Override
            public void set() {
                DataTranPluginImpl.this.statusManager.initLastValueType();
            }
        };
    }

    public void initDefaultDS() {
        if (this.initDefaultDS) {
            return;
        }
        try {
            DBConfig dbConfig = this.importContext.getDefaultDBConfig();
            if (dbConfig != null) {
                DataTranPluginImpl.initDS(this.dbStartResult, dbConfig);
            }
        }
        finally {
            this.initDefaultDS = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initOtherDSes() {
        if (this.initOtherDSes) {
            return;
        }
        try {
            List<DBConfig> dbConfigs = this.importContext.getOhterDBConfigs();
            if (dbConfigs != null && dbConfigs.size() > 0) {
                for (DBConfig dbConfig : dbConfigs) {
                    DataTranPluginImpl.initDS(this.dbStartResult, dbConfig);
                }
            }
        }
        finally {
            this.initOtherDSes = true;
        }
    }

    public static void initDS(DBStartResult dbStartResult, DBConfig dbConfig) {
        if (dbConfig != null && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbName()) && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbDriver()) && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbUrl()) && !dbStartResult.contain(dbConfig.getDbName())) {
            DBConf temConf = new DBConf();
            temConf.setPoolname(dbConfig.getDbName());
            temConf.setDriver(dbConfig.getDbDriver());
            temConf.setJdbcurl(dbConfig.getDbUrl());
            temConf.setUsername(dbConfig.getDbUser());
            temConf.setPassword(dbConfig.getDbPassword());
            temConf.setReadOnly(null);
            temConf.setTxIsolationLevel(null);
            temConf.setValidationQuery(dbConfig.getValidateSQL());
            temConf.setJndiName(dbConfig.getDbName() + "_jndi");
            temConf.setInitialConnections(dbConfig.getInitSize());
            temConf.setMinimumSize(dbConfig.getMinIdleSize());
            temConf.setMaximumSize(dbConfig.getMaxSize());
            temConf.setUsepool(dbConfig.isUsePool());
            temConf.setExternal(false);
            temConf.setExternaljndiName(null);
            temConf.setShowsql(dbConfig.isShowSql());
            temConf.setEncryptdbinfo(false);
            temConf.setQueryfetchsize(dbConfig.getJdbcFetchSize() == null ? null : dbConfig.getJdbcFetchSize());
            temConf.setDbAdaptor(dbConfig.getDbAdaptor());
            temConf.setDbtype(dbConfig.getDbtype());
            temConf.setColumnLableUpperCase(dbConfig.isColumnLableUpperCase());
            temConf.setDbInfoEncryptClass(dbConfig.getDbInfoEncryptClass());
            boolean ret = SQLManager.startPool((DBConf)temConf);
            if (ret) {
                dbStartResult.addDBStartResult(temConf.getPoolname());
            }
        }
    }

    @Override
    public void init(ImportContext importContext) {
        this.importContext = importContext;
        this.exportCount = new ExportCount();
        this.inputPlugin = importContext.getInputPlugin();
        this.outputPlugin = importContext.getOutputPlugin();
        this.inputPlugin.setDataTranPlugin(this);
        this.outputPlugin.setDataTranPlugin(this);
        this.initDefaultDS();
        this.initOtherDSes();
        this.beforeInit();
        this.inputPlugin.init();
        this.outputPlugin.init();
        this.initSchedule();
        this._initStatusManager();
        this.inputPlugin.afterInit();
        this.outputPlugin.afterInit();
    }

    @Override
    public boolean isMultiTran() {
        return this.inputPlugin.isMultiTran();
    }

    @Override
    public String getLastValueClumnName() {
        return this.statusManager.getLastValueClumnName();
    }

    @Override
    public boolean isContinueOnError() {
        return this.importContext.isContinueOnError();
    }

    @Override
    public Status getCurrentStatus() {
        return this.statusManager.getCurrentStatus();
    }

    @Override
    public void setHasTran() {
        this.lock.lock();
        try {
            this.tranCounts.incrementAndGet();
            this.hasTran = true;
            this.status = 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static void stopDatasources(DBStartResult dbStartResult) {
        Map dbs;
        if (dbStartResult != null && (dbs = dbStartResult.getDbstartResult()) != null && dbs.size() > 0) {
            for (Map.Entry entry : dbs.entrySet()) {
                String db = (String)entry.getKey();
                try {
                    SQLUtil.stopPool((String)db);
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("SQLUtil.stopPool(" + db + ") failed:", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void setNoTran() {
        this.lock.lock();
        try {
            int count = this.tranCounts.decrementAndGet();
            if (count <= 0) {
                this.hasTran = false;
                this.status = 3;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isStopCollectData() {
        return this.inputPlugin.isStopCollectData();
    }

    @Override
    public boolean isPluginStopAppending() {
        this.lock.lock();
        try {
            boolean bl = this.status == 2;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isPluginStopREADY() {
        this.lock.lock();
        try {
            boolean bl = this.status == 3;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean checkTranToStop() {
        this.lock.lock();
        try {
            boolean bl = this.status == 2 || this.status == 3 || this.status == 5 || !this.hasTran;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void checkTranFinished() {
        while (this.status != 3 && this.hasTran) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void _afterDestory(boolean waitTranStop, boolean fromScheduleEnd) {
        this.checkTranFinished();
        WrapedExportResultHandler wrapedExportResultHandler = this.importContext.getExportResultHandler();
        if (wrapedExportResultHandler != null) {
            try {
                wrapedExportResultHandler.destroy();
            }
            catch (Throwable e) {
                logger.error("Destroy WrapedExportResultHandler failed:", e);
            }
        }
        if (this.statusManager != null) {
            this.statusManager.stop();
        }
        this.endAction();
        this.inputPlugin.destroy(waitTranStop);
        this.outputPlugin.destroy(waitTranStop);
        this.statusManager.stopStatusDatasource();
        DataTranPluginImpl.stopDatasources(this.dbStartResult);
        this.status = 5;
        this.importContext.cleanResource();
    }

    private void endAction() {
        if (this.importContext.getEndAction() != null) {
            try {
                this.importContext.getEndAction().endAction();
            }
            catch (Exception e) {
                logger.error("importContext.getEndAction().endAction failed:", (Throwable)e);
            }
        }
    }

    private void stopMetrics() {
        List<ETLMetrics> etlMetrics = this.importContext.getMetrics();
        if (etlMetrics != null && etlMetrics.size() > 0) {
            for (ETLMetrics etlMetric : etlMetrics) {
                try {
                    etlMetric.stopMetrics();
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void destroy(final boolean waitTranStop, final boolean fromScheduleEnd) {
        this.status = 2;
        if (this.scheduleService != null) {
            this.scheduleService.stop();
        }
        try {
            this.inputPlugin.stopCollectData();
        }
        catch (Exception e) {
            logger.warn("", (Throwable)e);
        }
        try {
            this.outputPlugin.stopCollectData();
        }
        catch (Exception e) {
            logger.warn("", (Throwable)e);
        }
        this.stopMetrics();
        if (this.delayThread != null) {
            try {
                this.delayThread.interrupt();
                this.delayThread.join();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!fromScheduleEnd && this.scheduledEndThread != null) {
            try {
                this.scheduledEndThread.interrupt();
                this.scheduledEndThread.join();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.scheduledEndThread = null;
        }
        if (waitTranStop) {
            this._afterDestory(waitTranStop, fromScheduleEnd);
        } else {
            Thread stopThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    DataTranPluginImpl.this._afterDestory(waitTranStop, fromScheduleEnd);
                }
            }, "Destroy-DataTranPlugin-Thread");
            stopThread.start();
        }
    }

    @Override
    public Object[] putLastParamValue(Map params) {
        return this.statusManager.putLastParamValue(params);
    }

    @Override
    public boolean isIncreamentImport() {
        return this.statusManager.isIncreamentImport();
    }

    @Override
    public Map getParamValue(Map params) {
        return this.statusManager.getParamValue(params);
    }

    @Override
    public int getLastValueType() {
        return this.statusManager.getLastValueType();
    }

    @Override
    public void flushLastValue(Object lastValue, Status currentStatus, boolean reachEOFClosed) {
        this.statusManager.flushLastValue(lastValue, currentStatus, reachEOFClosed);
    }

    @Override
    public void flushLastValue(Object lastValue, Status currentStatus) {
        this.statusManager.flushLastValue(lastValue, currentStatus);
    }

    @Override
    public void forceflushLastValue(Status currentStatus) {
        this.statusManager.forceflushLastValue(currentStatus);
    }

    @Override
    public void handleOldedTasks(List<Status> olded) {
        this.statusManager.handleOldedTasks(olded);
    }

    @Override
    public void handleOldedTask(Status olded) {
        this.statusManager.handleOldedTask(olded);
    }

    @Override
    public ScheduleService getScheduleService() {
        return this.scheduleService;
    }

    public TranErrorWrapper getErrorWrapper() {
        return this.errorWrapper;
    }

    @Override
    public void setErrorWrapper(TranErrorWrapper errorWrapper) {
        this.errorWrapper = errorWrapper;
    }

    @Override
    public void setForceStop() {
        this.forceStop = true;
    }

    @Override
    public boolean assertCondition() {
        if (this.forceStop) {
            return false;
        }
        if (this.errorWrapper != null) {
            return this.errorWrapper.assertCondition();
        }
        return true;
    }

    public boolean assertCondition(Exception e) {
        if (this.errorWrapper != null) {
            return this.errorWrapper.assertCondition(e);
        }
        return true;
    }

    public void initSchedule() {
        if (this.importContext.getScheduleConfig() != null) {
            this.scheduleService = new ScheduleService();
            this.scheduleService.setEnablePluginTaskIntercept(this.inputPlugin.isEnablePluginTaskIntercept());
            this.scheduleService.init(this.importContext);
        }
    }

    @Override
    public void initResources(ResourceStart resourceStart) {
        try {
            ResourceStartResult resourceStartResult = resourceStart.startResource();
            if (resourceStartResult != null) {
                if (this.resourceStartResults == null) {
                    this.resourceStartResults = new ArrayList<ResourceStartResult>();
                }
                this.resourceStartResults.add(resourceStartResult);
            }
        }
        catch (Exception e) {
            logger.error("Resource Start failed:", (Throwable)e);
        }
    }

    @Override
    public void destroyResources(ResourceEnd resourceEnd) {
        if (this.resourceStartResults != null) {
            for (ResourceStartResult resourceStartResult : this.resourceStartResults) {
                try {
                    resourceEnd.endResource(resourceStartResult);
                }
                catch (Exception e) {
                    logger.error("End Resource failed:", (Throwable)e);
                }
            }
        }
    }
}

