/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import java.text.SimpleDateFormat;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.schedule.ScheduleAssert;
import org.frameworkset.tran.schedule.ScheduleEndCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStream {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ScheduleAssert scheduleAssert;
    protected ImportContext importContext;
    private DataTranPlugin dataTranPlugin;
    private boolean inited;
    private Lock lock = new ReentrantLock();
    private boolean endActioned = false;
    private Object endActionLock = new Object();
    private Object destroyLock = new Object();
    private boolean destoried;
    private String configString;

    public ImportContext getImportContext() {
        return this.importContext;
    }

    public void startAction() {
        if (this.importContext.getImportStartAction() != null) {
            try {
                this.importContext.getImportStartAction().startAction(this.importContext);
            }
            catch (Exception e) {
                this.logger.warn("", (Throwable)e);
            }
        }
    }

    public void afterStartAction() {
        if (this.importContext.getImportStartAction() != null) {
            try {
                this.importContext.getImportStartAction().afterStartAction(this.importContext);
            }
            catch (Exception e) {
                this.logger.warn("", (Throwable)e);
            }
        }
    }

    public void setDataTranPlugin(DataTranPlugin dataTranPlugin) {
        this.dataTranPlugin = dataTranPlugin;
    }

    public void initDatastream() {
        this.startAction();
        this.dataTranPlugin.init(this.importContext);
        this.afterStartAction();
    }

    public void setImportContext(ImportContext importContext) {
        this.importContext = importContext;
    }

    public void execute() throws DataImportException {
        try {
            this.init();
            if (this.dataTranPlugin != null) {
                this.dataTranPlugin.importData(new ScheduleEndCall(){

                    @Override
                    public void call() {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String date = dateFormat.format(DataStream.this.importContext.getScheduleEndDate());
                        DataStream.this.logger.info("Schedule job end date[{}] reached,schedule job stop begin....", (Object)date);
                        DataStream.this.destroy(true);
                        DataStream.this.logger.info("Schedule job end date[{}] reached,schedule job stop complete.", (Object)date);
                    }
                });
            }
        }
        catch (DataImportException e) {
            this.endAction(e);
            throw e;
        }
        catch (Exception e) {
            this.endAction(e);
            throw new DataImportException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAction(Exception e) {
        Object object = this.endActionLock;
        synchronized (object) {
            if (this.endActioned) {
                return;
            }
            this.endActioned = true;
        }
        if (this.importContext != null && this.importContext.getImportEndAction() != null) {
            try {
                this.importContext.getImportEndAction().endAction(this.importContext, e);
            }
            catch (Exception ee) {
                this.logger.warn("", (Throwable)ee);
            }
        }
    }

    public void destroy() {
        this.destroy(false);
    }

    public void destroy(boolean waitTranStopped) {
        this.destroy(waitTranStopped, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(boolean waitTranStopped, boolean fromScheduleEnd) {
        if (this.destoried) {
            return;
        }
        Object object = this.destroyLock;
        synchronized (object) {
            if (this.destoried) {
                return;
            }
            this.destoried = true;
        }
        if (this.importContext != null) {
            this.logger.info("Destroy DataStream begin,waitTranStopped[{}].", (Object)waitTranStopped);
            this.importContext.destroy(waitTranStopped, fromScheduleEnd);
            this.logger.info("DataStream stopped.");
        } else {
            this.logger.info("DataStream stopped.");
        }
    }

    public String getConfigString() {
        return this.configString;
    }

    public void setConfigString(String configString) {
        this.configString = configString;
    }

    public void init() {
        if (this.inited) {
            this.importContext.resume();
            return;
        }
        if (this.importContext == null || this.importContext.getImportConfig() == null || this.importContext.getInputConfig() == null || this.importContext.getOutputConfig() == null) {
            throw new DataImportException("import Config is null.");
        }
        this.lock.lock();
        try {
            this.inited = true;
        }
        catch (Exception e) {
            this.inited = true;
            throw new DataImportException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean pauseSchedule() {
        if (this.scheduleAssert != null) {
            return this.scheduleAssert.pauseSchedule();
        }
        return false;
    }

    public boolean resumeSchedule() {
        if (this.scheduleAssert != null) {
            return this.scheduleAssert.resumeSchedule();
        }
        return false;
    }

    public void setScheduleAssert(ScheduleAssert scheduleAssert) {
        this.scheduleAssert = scheduleAssert;
        if (this.dataTranPlugin != null) {
            this.dataTranPlugin.setScheduleAssert(scheduleAssert);
        }
    }
}

