/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.easymapper.util;

import com.baidu.unbiz.easymapper.util.ClassUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtil.class);

    public static <T> T newInstance(Class<T> clazz) {
        Constructor<?>[] constructors = ReflectionUtil.getAllConstructorsOfClass(clazz, true);
        if (constructors == null || constructors.length == 0) {
            return null;
        }
        Object[] initParameters = ReflectionUtil.getInitParameters(constructors[0].getParameterTypes());
        try {
            Object instance = constructors[0].newInstance(initParameters);
            return (T)instance;
        }
        catch (Exception e) {
            LOGGER.error("newInstance", (Throwable)e);
            return null;
        }
    }

    public static Constructor<?>[] getAllConstructorsOfClass(Class<?> clazz, boolean accessible) {
        if (clazz == null) {
            return null;
        }
        AccessibleObject[] constructors = clazz.getDeclaredConstructors();
        if (constructors != null && constructors.length > 0) {
            AccessibleObject.setAccessible(constructors, accessible);
        }
        return constructors;
    }

    private static Object[] getInitParameters(Class<?>[] parameterTypes) {
        int length = parameterTypes.length;
        Object[] result = new Object[length];
        for (int i = 0; i < length; ++i) {
            Object init;
            result[i] = parameterTypes[i].isPrimitive() ? (init = ClassUtil.getPrimitiveDefaultValue(parameterTypes[i])) : null;
        }
        return result;
    }
}

