/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.easymapper.metadata;

import com.baidu.unbiz.easymapper.metadata.Property;
import com.baidu.unbiz.easymapper.metadata.Type;
import com.baidu.unbiz.easymapper.metadata.TypeFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class PropertyResolver {
    private final boolean includePublicFields;
    private final Map<java.lang.reflect.Type, Map<String, Property>> propertiesCache = new ConcurrentHashMap<java.lang.reflect.Type, Map<String, Property>>();

    public PropertyResolver(boolean includePublicFields) {
        this.includePublicFields = includePublicFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Property> getProperties(java.lang.reflect.Type theType) {
        Map<String, Property> properties = this.propertiesCache.get(theType);
        if (properties == null) {
            java.lang.reflect.Type type = theType;
            synchronized (type) {
                properties = this.propertiesCache.get(theType);
                if (properties == null) {
                    Type referenceType;
                    properties = new LinkedHashMap<String, Property>();
                    if (theType instanceof Type) {
                        referenceType = (Type)theType;
                    } else if (theType instanceof Class) {
                        referenceType = TypeFactory.valueOf((Class)theType);
                    } else {
                        throw new IllegalArgumentException("type " + theType + " not supported.");
                    }
                    LinkedList<java.lang.reflect.Type> types = new LinkedList<java.lang.reflect.Type>();
                    types.addFirst(referenceType.getRawType());
                    while (!types.isEmpty()) {
                        Class type2 = (Class)types.removeFirst();
                        this.collectProperties(type2, referenceType, properties);
                        if (type2.getSuperclass() != null && !Object.class.equals(type2.getSuperclass())) {
                            types.add(type2.getSuperclass());
                        }
                        List<Class<?>> interfaces = Arrays.asList(type2.getInterfaces());
                        types.addAll(interfaces);
                    }
                    if (this.includePublicFields) {
                        this.collectPublicFieldProperties(referenceType, properties);
                    }
                    this.propertiesCache.put(theType, Collections.unmodifiableMap(properties));
                }
            }
        }
        return properties;
    }

    protected void collectPublicFieldProperties(Type<?> referenceType, Map<String, Property> properties) {
        for (Field f : ((Class)referenceType.getRawType()).getFields()) {
            Property existing;
            if (Modifier.isStatic(f.getModifiers())) continue;
            Property.Builder builder = new Property.Builder();
            builder.expression(f.getName());
            builder.name(f.getName());
            Class<?> rawType = f.getType();
            Type<?> genericType = this.resolveGenericType(f.getGenericType(), f.getDeclaringClass(), referenceType);
            if (genericType != null && !genericType.isAssignableFrom(rawType)) {
                builder.type(genericType);
            } else {
                builder.type(TypeFactory.valueOf(rawType));
            }
            if (!Modifier.isFinal(f.getModifiers())) {
                builder.setter(f.getName() + " = %s");
            }
            if ((existing = properties.get(f.getName())) == null) {
                builder.getter(f.getName());
                properties.put(f.getName(), builder.build(this));
                continue;
            }
            if (existing.getSetter() != null) continue;
            builder.merge(existing);
            properties.put(f.getName(), builder.build(this));
        }
    }

    protected abstract void collectProperties(Class<?> var1, Type<?> var2, Map<String, Property> var3);

    public Type<?> resolvePropertyType(Method readMethod, Class<?> rawType, Class<?> owningType, Type<?> referenceType) {
        rawType = this.resolveRawPropertyType(rawType, readMethod);
        Type<?> resolvedGenericType = null;
        if ((referenceType.isParameterized() || this.hasTypeParameters(owningType) || this.hasTypeParameters(rawType)) && readMethod != null) {
            try {
                resolvedGenericType = this.resolveGenericType(readMethod.getDeclaringClass().getDeclaredMethod(readMethod.getName(), new Class[0]).getGenericReturnType(), owningType, referenceType);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("readMethod does not exist", e);
            }
        }
        if (resolvedGenericType == null || resolvedGenericType.isAssignableFrom(rawType)) {
            resolvedGenericType = TypeFactory.valueOf(rawType);
        }
        return resolvedGenericType;
    }

    private Type<?> resolveGenericType(java.lang.reflect.Type genericType, Class<?> owningType, Type<?> referenceType) {
        Type resolvedType = null;
        Type<?> reference = referenceType;
        do {
            Type<?> referenceInterface = null;
            if (genericType instanceof TypeVariable) {
                if (reference.isParameterized()) {
                    java.lang.reflect.Type t = reference.getTypeByVariable((TypeVariable)genericType);
                    if (t != null) {
                        resolvedType = TypeFactory.valueOf(t);
                    }
                } else if (this.hasTypeParameters(owningType) && owningType.isInterface()) {
                    referenceInterface = reference.findInterface(TypeFactory.valueOf(owningType));
                }
            } else if (genericType instanceof ParameterizedType) {
                if (reference.isSelfOrAncestorParameterized()) {
                    resolvedType = TypeFactory.resolveValueOf((ParameterizedType)genericType, reference);
                } else if (this.hasTypeParameters(owningType) && owningType.isInterface()) {
                    referenceInterface = reference.findInterface(TypeFactory.valueOf(owningType));
                } else {
                    resolvedType = TypeFactory.valueOf((ParameterizedType)genericType);
                }
            }
            Type<?> type = reference = referenceInterface != null ? referenceInterface : reference.getSuperType();
        } while (resolvedType == null && reference != TypeFactory.TYPE_OF_OBJECT);
        return resolvedType;
    }

    private Class<?> resolveRawPropertyType(Class<?> rawType, Method readMethod) {
        try {
            return readMethod == null ? rawType : readMethod.getDeclaringClass().getDeclaredMethod(readMethod.getName(), new Class[0]).getReturnType();
        }
        catch (Exception e) {
            return rawType;
        }
    }

    protected boolean hasTypeParameters(Class<?> type) {
        boolean hasTypeParams = false;
        if (type.getTypeParameters().length > 0) {
            hasTypeParams = true;
        } else if (type.getGenericSuperclass() instanceof ParameterizedType) {
            hasTypeParams = true;
        } else {
            for (java.lang.reflect.Type anInterface : type.getGenericInterfaces()) {
                if (!(anInterface instanceof ParameterizedType)) continue;
                hasTypeParams = true;
                break;
            }
        }
        return hasTypeParams;
    }

    protected Property processProperty(String propertyName, Class<?> propertyType, Method readMethod, Method writeMethod, Class<?> owningType, Type<?> referenceType, Map<String, Property> properties) {
        Property.Builder builder = new Property.Builder();
        Property property = null;
        builder.expression(propertyName);
        builder.name(propertyName);
        if (readMethod != null) {
            builder.getter(readMethod.getName() + "()");
        }
        if (writeMethod != null) {
            builder.setter(writeMethod.getName() + "(%s)");
        }
        if (readMethod != null || writeMethod != null) {
            builder.type(this.resolvePropertyType(readMethod, propertyType, owningType, referenceType));
            property = builder.build(this);
            Property existing = properties.get(propertyName);
            if (existing == null) {
                properties.put(propertyName, property);
            } else if (existing.getType().isAssignableFrom(property.getType())) {
                property = builder.merge(existing).build(this);
                properties.put(propertyName, property);
            }
        }
        return property;
    }

    protected String capitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }
}

