/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.darabonba.encode;

import com.aliyun.tea.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.Provider;
import java.util.Arrays;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Encoder {
    public static final String ENCODING = "UTF-8";
    public static final String HASH_SHA256 = "SHA-256";
    public static final String HASH_SM3 = "SM3";
    public static final String HMAC_SHA256 = "HMAC-SHA256";
    public static final String RSA_SHA256 = "RSA-SHA256";
    public static final String HMAC_SM3 = "HMAC-SM3";

    public static String urlEncode(String url) throws UnsupportedEncodingException {
        return url != null ? URLEncoder.encode(url, ENCODING) : "";
    }

    public static String percentEncode(String raw) throws UnsupportedEncodingException {
        return raw != null ? URLEncoder.encode(raw, ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }

    public static String pathEncode(String path) throws Exception {
        if (StringUtils.isEmpty((CharSequence)path) || "/".equals(path)) {
            return path;
        }
        String[] paths = path.split("/");
        StringBuilder sb = new StringBuilder();
        for (String s : paths) {
            sb.append(Encoder.percentEncode(s));
            sb.append("/");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    public static String hexEncode(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : raw) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static byte[] hash(byte[] raw, String signatureAlgorithm) throws Exception {
        if (signatureAlgorithm == null) {
            return null;
        }
        if (signatureAlgorithm.contains(HMAC_SHA256) || signatureAlgorithm.contains(RSA_SHA256)) {
            MessageDigest digest = MessageDigest.getInstance(HASH_SHA256);
            return digest.digest(raw);
        }
        if (signatureAlgorithm.contains(HMAC_SM3)) {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            MessageDigest digest = MessageDigest.getInstance(HASH_SM3, (Provider)provider);
            return digest.digest(raw);
        }
        return null;
    }

    public static String base64EncodeToString(byte[] raw) throws Exception {
        return DaraBase64.RFC4648.encode(raw);
    }

    public static byte[] base64Decode(String src) throws Exception {
        return DaraBase64.RFC4648.decode(src);
    }

    public static class DaraBase64 {
        private final byte[] newline;
        private final int linemax;
        private final boolean isURL;
        private final boolean doPadding;
        private final boolean isMIME;
        private static final char[] toBase64;
        private static final char[] toBase64URL;
        private static final int[] fromBase64;
        private static final int[] fromBase64URL;
        static final DaraBase64 RFC4648;

        private DaraBase64(boolean isURL, boolean isMIME, byte[] newline, int linemax, boolean doPadding) {
            this.isURL = isURL;
            this.isMIME = isMIME;
            this.newline = newline;
            this.linemax = linemax;
            this.doPadding = doPadding;
        }

        private int encodeOutLength(int srclen) {
            int len = 0;
            if (this.doPadding) {
                len = 4 * ((srclen + 2) / 3);
            } else {
                int n = srclen % 3;
                len = 4 * (srclen / 3) + (n == 0 ? 0 : n + 1);
            }
            if (this.linemax > 0) {
                len += (len - 1) / this.linemax * this.newline.length;
            }
            return len;
        }

        public String encode(byte[] src) throws UnsupportedEncodingException {
            int len = this.encodeOutLength(src.length);
            byte[] dst = new byte[len];
            int ret = this.encode0(src, 0, src.length, dst);
            if (ret != dst.length) {
                return new String(Arrays.copyOf(dst, ret), Encoder.ENCODING);
            }
            return new String(dst, Encoder.ENCODING);
        }

        private int encode0(byte[] src, int off, int end, byte[] dst) {
            char[] base64 = this.isURL ? toBase64URL : toBase64;
            int sp = off;
            int slen = (end - off) / 3 * 3;
            int sl = off + slen;
            if (this.linemax > 0 && slen > this.linemax / 4 * 3) {
                slen = this.linemax / 4 * 3;
            }
            int dp = 0;
            while (sp < sl) {
                int sl0 = Math.min(sp + slen, sl);
                int sp0 = sp;
                int dp0 = dp;
                while (sp0 < sl0) {
                    int bits = (src[sp0++] & 0xFF) << 16 | (src[sp0++] & 0xFF) << 8 | src[sp0++] & 0xFF;
                    dst[dp0++] = (byte)base64[bits >>> 18 & 0x3F];
                    dst[dp0++] = (byte)base64[bits >>> 12 & 0x3F];
                    dst[dp0++] = (byte)base64[bits >>> 6 & 0x3F];
                    dst[dp0++] = (byte)base64[bits & 0x3F];
                }
                int dlen = (sl0 - sp) / 3 * 4;
                dp += dlen;
                sp = sl0;
                if (dlen != this.linemax || sp >= end) continue;
                for (byte b : this.newline) {
                    dst[dp++] = b;
                }
            }
            if (sp < end) {
                int b0 = src[sp++] & 0xFF;
                dst[dp++] = (byte)base64[b0 >> 2];
                if (sp == end) {
                    dst[dp++] = (byte)base64[b0 << 4 & 0x3F];
                    if (this.doPadding) {
                        dst[dp++] = 61;
                        dst[dp++] = 61;
                    }
                } else {
                    int b1 = src[sp++] & 0xFF;
                    dst[dp++] = (byte)base64[b0 << 4 & 0x3F | b1 >> 4];
                    dst[dp++] = (byte)base64[b1 << 2 & 0x3F];
                    if (this.doPadding) {
                        dst[dp++] = 61;
                    }
                }
            }
            return dp;
        }

        public byte[] decode(String src) throws UnsupportedEncodingException {
            return this.decode(src.getBytes(Encoder.ENCODING));
        }

        public byte[] decode(byte[] src) {
            byte[] dst = new byte[this.decodeOutLength(src, 0, src.length)];
            int ret = this.decode0(src, 0, src.length, dst);
            if (ret != dst.length) {
                dst = Arrays.copyOf(dst, ret);
            }
            return dst;
        }

        private int decodeOutLength(byte[] src, int sp, int sl) {
            int[] base64 = this.isURL ? fromBase64URL : fromBase64;
            int paddings = 0;
            int len = sl - sp;
            if (len == 0) {
                return 0;
            }
            if (len < 2) {
                if (this.isMIME && base64[0] == -1) {
                    return 0;
                }
                throw new IllegalArgumentException("Input byte[] should at least have 2 bytes for base64 bytes");
            }
            if (this.isMIME) {
                int n = 0;
                while (sp < sl) {
                    int b;
                    if ((b = src[sp++] & 0xFF) == 61) {
                        len -= sl - sp + 1;
                        break;
                    }
                    if ((b = base64[b]) != -1) continue;
                    ++n;
                }
                len -= n;
            } else if (src[sl - 1] == 61) {
                ++paddings;
                if (src[sl - 2] == 61) {
                    ++paddings;
                }
            }
            if (paddings == 0 && (len & 3) != 0) {
                paddings = 4 - (len & 3);
            }
            return 3 * ((len + 3) / 4) - paddings;
        }

        private int decode0(byte[] src, int sp, int sl, byte[] dst) {
            int[] base64 = this.isURL ? fromBase64URL : fromBase64;
            int dp = 0;
            int bits = 0;
            int shiftto = 18;
            while (sp < sl) {
                int b = src[sp++] & 0xFF;
                if ((b = base64[b]) < 0) {
                    if (b == -2) {
                        if ((shiftto != 6 || sp != sl && src[sp++] == 61) && shiftto != 18) break;
                        throw new IllegalArgumentException("Input byte array has wrong 4-byte ending unit");
                    }
                    if (this.isMIME) continue;
                    throw new IllegalArgumentException("Illegal base64 character " + Integer.toString(src[sp - 1], 16));
                }
                bits |= b << shiftto;
                if ((shiftto -= 6) >= 0) continue;
                dst[dp++] = (byte)(bits >> 16);
                dst[dp++] = (byte)(bits >> 8);
                dst[dp++] = (byte)bits;
                shiftto = 18;
                bits = 0;
            }
            if (shiftto == 6) {
                dst[dp++] = (byte)(bits >> 16);
            } else if (shiftto == 0) {
                dst[dp++] = (byte)(bits >> 16);
                dst[dp++] = (byte)(bits >> 8);
            } else if (shiftto == 12) {
                throw new IllegalArgumentException("Last unit does not have enough valid bits");
            }
            while (sp < sl) {
                if (this.isMIME && base64[src[sp++]] < 0) continue;
                throw new IllegalArgumentException("Input byte array has incorrect ending byte at " + sp);
            }
            return dp;
        }

        static {
            int i;
            toBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
            toBase64URL = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
            fromBase64 = new int[256];
            Arrays.fill(fromBase64, -1);
            for (i = 0; i < toBase64.length; ++i) {
                DaraBase64.fromBase64[DaraBase64.toBase64[i]] = i;
            }
            DaraBase64.fromBase64[61] = -2;
            fromBase64URL = new int[256];
            Arrays.fill(fromBase64URL, -1);
            for (i = 0; i < toBase64URL.length; ++i) {
                DaraBase64.fromBase64URL[DaraBase64.toBase64URL[i]] = i;
            }
            DaraBase64.fromBase64URL[61] = -2;
            RFC4648 = new DaraBase64(false, false, null, -1, true);
        }
    }
}

