/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.aliyuncs.push.model.v20160801;

import com.aliyuncs.RpcAcsRequest;

/**
 * @author auto create
 * @version 
 */
public class PushNoticeToiOSRequest extends RpcAcsRequest<PushNoticeToiOSResponse> {
	
	public PushNoticeToiOSRequest() {
		super("Push", "2016-08-01", "PushNoticeToiOS");
	}

	private String extParameters;

	private String apnsEnv;

	private Long appKey;

	private String targetValue;

	private String title;

	private String body;

	private String jobKey;

	private String target;

	public String getExtParameters() {
		return this.extParameters;
	}

	public void setExtParameters(String extParameters) {
		this.extParameters = extParameters;
		if(extParameters != null){
			putQueryParameter("ExtParameters", extParameters);
		}
	}

	public String getApnsEnv() {
		return this.apnsEnv;
	}

	public void setApnsEnv(String apnsEnv) {
		this.apnsEnv = apnsEnv;
		if(apnsEnv != null){
			putQueryParameter("ApnsEnv", apnsEnv);
		}
	}

	public Long getAppKey() {
		return this.appKey;
	}

	public void setAppKey(Long appKey) {
		this.appKey = appKey;
		if(appKey != null){
			putQueryParameter("AppKey", appKey.toString());
		}
	}

	public String getTargetValue() {
		return this.targetValue;
	}

	public void setTargetValue(String targetValue) {
		this.targetValue = targetValue;
		if(targetValue != null){
			putQueryParameter("TargetValue", targetValue);
		}
	}

	public String getTitle() {
		return this.title;
	}

	public void setTitle(String title) {
		this.title = title;
		if(title != null){
			putQueryParameter("Title", title);
		}
	}

	public String getBody() {
		return this.body;
	}

	public void setBody(String body) {
		this.body = body;
		if(body != null){
			putQueryParameter("Body", body);
		}
	}

	public String getJobKey() {
		return this.jobKey;
	}

	public void setJobKey(String jobKey) {
		this.jobKey = jobKey;
		if(jobKey != null){
			putQueryParameter("JobKey", jobKey);
		}
	}

	public String getTarget() {
		return this.target;
	}

	public void setTarget(String target) {
		this.target = target;
		if(target != null){
			putQueryParameter("Target", target);
		}
	}

	@Override
	public Class<PushNoticeToiOSResponse> getResponseClass() {
		return PushNoticeToiOSResponse.class;
	}

}
